<?php
namespace BdevsElement\Widget;

use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Typography;
Use \Elementor\Core\Schemes\Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Box_Shadow;

defined( 'ABSPATH' ) || die();

class Banner extends BDevs_El_Widget {


    /**
     * Get widget name.
     *
     * Retrieve Bdevs Element widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'banner';
    }

    /**
     * Get widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __( 'Pro Banner', 'bdevs-element' );
    }

    public function get_custom_help_url() {
        return 'http://elementor.bdevs.net//widgets/fact/';
    }

    /**
     * Get widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-photo-library';
    }

    public function get_keywords() {
        return [ 'banner', 'image', 'content' ];
    }

    protected function register_content_controls() {

        $this->start_controls_section(
            '_section_design_title',
            [
                'label' => __( 'Design Style', 'bdevs-element' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'design_style',
            [
                'label' => __( 'Design Style', 'bdevs-element' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => __( 'Style 1', 'bdevs-element' ),
                    'style_2' => __( 'Style 2', 'bdevs-element' ),
                    'style_3' => __( 'Style 3: Promo Section', 'bdevs-element' ),
                    'style_4' => __( 'Style 4: Couple Banner', 'bdevs-element' ),
                    'style_5' => __( 'Style 5: Fullwidth Banner', 'bdevs-element' ),
                    'style_6' => __( 'Style 6: Banner with button', 'bdevs-element' ),
                    'style_7' => __( 'Style 7: Fluid Banner with button', 'bdevs-element' ),
                   
                ],
                'default' => 'style_1',
                'frontend_available' => true,
                'style_transfer' => true,
            ]
        );

        $this->end_controls_section();         

        // banner
        $this->start_controls_section(
            '_section_image',
            [
                'label' => __( 'Content & Image', 'bdevs-element' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_3', 'style_5', 'style_6', 'style_7', 'style_8']
                ]
            ]
        );
        $this->add_control(
            'bg_image',
            [
                'type' => Controls_Manager::MEDIA,
                'label' => __( 'Image', 'bdevs-element' ),
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'extra_sub_title',
            [
                'type' => Controls_Manager::TEXT,
                'label' => __( 'Sub Title', 'bdevs-element' ),
                'label_block' => true,
                'default' => __('45% Flate On', 'bdevs-element'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'design_style' => ['style_5', 'style_7']
                ]
            ]
        );

        $this->add_control(
            'extra_title',
            [
                'type' => Controls_Manager::TEXT,
                'label' => __( 'Title', 'bdevs-element' ),
                'label_block' => true,
                'default' => __('Shop & Save Big On <br>Listed Categories Here', 'bdevs-element'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'extra_desc',
            [
                'type' => Controls_Manager::TEXTAREA,
                'label' => __( 'Description', 'bdevs-element' ),
                'label_block' => true,
                'default' => __('Description goes here', 'bdevs-element'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'design_style' => ['style_6']
                ]
            ]
        );


        $this->add_control(
            'extra_button_text',
            [
                'type' => Controls_Manager::TEXT,
                'label' => __( 'Button', 'bdevs-element' ),
                'label_block' => true,
                'default' => __('Explore Now', 'bdevs-element'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'design_style' => ['style_5', 'style_6', 'style_7', 'style_8']
                ]
            ]
        );
        $this->add_control(
            'extra_button_link',
            [
                'type' => Controls_Manager::TEXT,
                'label' => __( 'Button Link', 'bdevs-element' ),
                'label_block' => true,
                'default' => __('#', 'bdevs-element'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'design_style' => ['style_5', 'style_6', 'style_7', 'style_8']
                ]
            ]
        );

        $this->end_controls_section(); 

        $this->start_controls_section(
            '_section_media',
            [
                'label' => __( 'Icon / Image', 'bdevs-element' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_3', 'style_4']
                ]
            ]
        );

       $repeater = new Repeater();

        $repeater->add_control(
            'field_condition',
            [
                'label' => __( 'Field condition', 'bdevs-element' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'field_condition_1' => __( 'Style 1', 'bdevs-element' ),
                    'field_condition_4' => __( 'Style 4', 'bdevs-element' ),
                ],
                'default' => 'field_condition_1',
                'frontend_available' => true,
                'style_transfer' => true,
            ]
        );

        $repeater->add_control(
            'type',
            [
                'label' => __( 'Media Type', 'bdevs-element' ),
                'type' => Controls_Manager::CHOOSE,
                'label_block' => false,
                'options' => [
                    'icon' => [
                        'title' => __( 'Icon', 'bdevs-element' ),
                        'icon' => 'fa fa-smile-o',
                    ],
                    'image' => [
                        'title' => __( 'Image', 'bdevs-element' ),
                        'icon' => 'fa fa-image',
                    ],
                ],
                'default' => 'icon',
                'toggle' => false,
                'style_transfer' => true,
            ]
        );

        $repeater->add_control(
            'image',
            [
                'label' => __( 'Image', 'bdevs-element' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'type' => 'image'
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'medium_large',
                'separator' => 'none',
                'exclude' => [
                    'full',
                    'custom',
                    'large',
                    'shop_catalog',
                    'shop_single',
                    'shop_thumbnail'
                ],
                'condition' => [
                    'type' => 'image'
                ]
            ]
        );

        if ( bdevs_element_is_elementor_version( '<', '2.6.0' ) ) {
            $repeater->add_control(
                'icon',
                [
                    'label' => __( 'Icon', 'bdevs-element' ),
                    'label_block' => true,
                    'type' => Controls_Manager::ICON,
                    'options' => bdevs_element_get_bdevs_element_icons(),
                    'default' => 'fa fa-smile-o',
                    'condition' => [
                        'type' => 'icon'
                    ]
                ]
            );
        } 
        else {
            $repeater->add_control(
                'selected_icon',
                [
                    'type' => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'label_block' => true,
                    'default' => [
                        'value' => 'fas fa-smile-wink',
                        'library' => 'fa-solid',
                    ],
                    'condition' => [
                        'type' => 'icon'
                    ]
                ]
            );
        }

        $repeater->add_control(
            'title',
            [
                'label' => __( 'Title', 'bdevs-element' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __( 'Features Title', 'bdevs-element' ),
                'placeholder' => __( 'Type Icon Box Title', 'bdevs-element' ),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_control(
            'title_link',
            [
                'label' => __( 'Title link', 'bdevs-element' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __( '#', 'bdevs-element' ),
                'placeholder' => __( 'Type Title link', 'bdevs-element' ),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'field_condition' => ['field_condition_4']
                ]
            ]
        );


        $repeater->add_control(
            'banner_button_text',
            [
                'label' => __( 'Banner Button', 'bdevs-element' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __( 'Banner Button', 'bdevs-element' ),
                'placeholder' => __( 'Type Button Text', 'bdevs-element' ),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'field_condition' => ['field_condition_4']
                ]
            ]
        );

        $repeater->add_control(
            'banner_button_link',
            [
                'label' => __( 'Button Link', 'bdevs-element' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __( 'Button Link', 'bdevs-element' ),
                'placeholder' => __( 'Type Button Link', 'bdevs-element' ),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'field_condition' => ['field_condition_4']
                ]
            ]
        );

        $this->add_control(
            'slides',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '<# print(title || "Carousel Item"); #>',
                'default' => [
                    [
                        'image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'medium_large',
                'separator' => 'none',
                'exclude' => [
                    'full',
                    'custom',
                    'large',
                    'shop_catalog',
                    'shop_single',
                    'shop_thumbnail'
                ]
            ]
        );


        $this->end_controls_section();

        // _section_title
        $this->start_controls_section(
            '_section_title',
            [
                'label' => __( 'Title & Desccription', 'bdevs-element' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_1', 'style_2']
                ],
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'bdevs-element' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => 'Heading Title',
                'placeholder' => __( 'Heading Text', 'bdevs-element' ),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'description',
            [
                'label' => __( 'Description', 'bdevs-element' ),
                'label_block' => true,
                'type' => Controls_Manager::TEXTAREA,
                'default' => 'Description goes here',
                'placeholder' => __( 'Type description', 'bdevs-element' ),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        ); 

        $this->add_control(
            'banner_button_text',
            [
                'label' => __( 'Button Text', 'bdevs-element' ),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'default' => 'Shop Now',
                'placeholder' => __( 'Button Text', 'bdevs-element' ),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );      

        $this->add_control(
            'banner_link',
            [
                'label' => __( 'Link', 'bdevs-element' ),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'default' => '#',
                'placeholder' => __( 'Link', 'bdevs-element' ),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );      


        $this->add_control(
            'title_tag',
            [
                'label' => __( 'Title HTML Tag', 'bdevs-element' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'h1'  => [
                        'title' => __( 'H1', 'bdevs-element' ),
                        'icon' => 'eicon-editor-h1'
                    ],
                    'h2'  => [
                        'title' => __( 'H2', 'bdevs-element' ),
                        'icon' => 'eicon-editor-h2'
                    ],
                    'h3'  => [
                        'title' => __( 'H3', 'bdevs-element' ),
                        'icon' => 'eicon-editor-h3'
                    ],
                    'h4'  => [
                        'title' => __( 'H4', 'bdevs-element' ),
                        'icon' => 'eicon-editor-h4'
                    ],
                    'h5'  => [
                        'title' => __( 'H5', 'bdevs-element' ),
                        'icon' => 'eicon-editor-h5'
                    ],
                    'h6'  => [
                        'title' => __( 'H6', 'bdevs-element' ),
                        'icon' => 'eicon-editor-h6'
                    ]
                ],
                'default' => 'h2',
                'toggle' => false,
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label' => __( 'Alignment', 'bdevs-element' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', 'bdevs-element' ),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'bdevs-element' ),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', 'bdevs-element' ),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}}' => 'text-align: {{VALUE}};'
                ]
            ]
        );

        $this->end_controls_section();

    }

    protected function register_style_controls() {




        // Title / Content
        $this->start_controls_section(
            '_section_style_content',
            [
                'label' => __( 'Title / Content', 'bdevs-element' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'content_padding',
            [
                'label' => __( 'Content Padding', 'bdevs-element' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'content_background',
                'selector' => '{{WRAPPER}} .bdevs-el-content',
                'exclude' => [
                    'image'
                ]
            ]
        );

        // Title
        $this->add_control(
            '_heading_title_normal',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Title', 'bdevs-element' ),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'title_spacing_normal',
            [
                'label' => __( 'Bottom Spacing', 'bdevs-element' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_color_normal',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title',
                'selector' => '{{WRAPPER}} .bdevs-el-title',
                'scheme' => Typography::TYPOGRAPHY_2,
            ]
        );

        // Subtitle    
        $this->add_control(
            '_heading_subtitle',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Subtitle', 'bdevs-element' ),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'subtitle_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bdevs-element' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-subtitle' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'subtitle_color_normal',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-subtitle' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle',
                'selector' => '{{WRAPPER}} .bdevs-el-subtitle',
                'scheme' => Typography::TYPOGRAPHY_3,
            ]
        );

        // description
        $this->add_control(
            '_content_description',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Description', 'bdevs-element' ),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'description_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bdevs-element' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-content p' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'description_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-content p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'description',
                'selector' => '{{WRAPPER}} .bdevs-el-content p',
                'scheme' => Typography::TYPOGRAPHY_4,
            ]
        );


        $this->end_controls_section();

        // Button 1 style
        $this->start_controls_section(
            '_section_style_button',
            [
                'label' => __( 'Button', 'bdevs-element' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'button_padding',
            [
                'label' => __( 'Padding', 'bdevs-element' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'selector' => '{{WRAPPER}} .bdevs-el-btn',
                'scheme' => Typography::TYPOGRAPHY_4,
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button_border',
                'selector' => '{{WRAPPER}} .bdevs-el-btn',
            ]
        );

        $this->add_control(
            'button_border_radius',
            [
                'label' => __( 'Border Radius', 'bdevs-element' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_box_shadow',
                'selector' => '{{WRAPPER}} .bdevs-el-btn',
            ]
        );

        $this->add_control(
            'hr_button',
            [
                'type' => Controls_Manager::DIVIDER,
                'style' => 'thick',
            ]
        );

        $this->start_controls_tabs( '_tabs_button' );

        $this->start_controls_tab(
            '_tab_button_normal',
            [
                'label' => __( 'Normal', 'bdevs-element' ),
            ]
        );

        $this->add_control(
            'button_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_bg_color',
            [
                'label' => __( 'Background Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            '_tab_button_hover',
            [
                'label' => __( 'Hover', 'bdevs-element' ),
            ]
        );

        $this->add_control(
            'button_hover_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn:hover, {{WRAPPER}} .bdevs-el-btn:focus' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_hover_bg_color',
            [
                'label' => __( 'Background Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn:hover, {{WRAPPER}} .bdevs-el-btn:focus, {{WRAPPER}} epix-btn-1:before' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_hover_border_color',
            [
                'label' => __( 'Border Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'button_border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn:hover, {{WRAPPER}} .bdevs-el-btn:focus' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

        // tab item
        $this->start_controls_section(
            '_section_tab_content',
            [
                'label' => __( 'Tab Content', 'bdevs-element' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'content_tab_padding',
            [
                'label' => __( 'Content Padding', 'bdevs-element' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-content-tab' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'content_tab_background',
                'selector' => '{{WRAPPER}} .bdevs-el-content-tab',
                'exclude' => [
                    'image'
                ]
            ]
        );

        // Title
        $this->add_control(
            '_heading_title_tab_normal',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Title', 'bdevs-element' ),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'title_spacing_tab_normal',
            [
                'label' => __( 'Bottom Spacing', 'bdevs-element' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-title-tab' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_tab_color_normal',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-title-tab' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_tab',
                'selector' => '{{WRAPPER}} .bdevs-el-title-tab',
                'scheme' => Typography::TYPOGRAPHY_2,
            ]
        );

        // Subtitle    
        $this->add_control(
            '_heading_tab_subtitle',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Subtitle', 'bdevs-element' ),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'subtitle_tab_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bdevs-element' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-subtitle-tab' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'subtitle_tab_color_normal',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-subtitle-tab' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle_tab',
                'selector' => '{{WRAPPER}} .bdevs-el-subtitle-tab',
                'scheme' => Typography::TYPOGRAPHY_3,
            ]
        );

        $this->end_controls_section();


    }

    protected function render() {
        $settings = $this->get_settings_for_display();



        $title = bdevs_element_kses_basic( $settings['title' ] );


        ?>

        <?php if ( $settings['design_style'] === 'style_7' ) : 

            if( !empty($settings['bg_image']['id']) ) {
                $bg_image = wp_get_attachment_image_url($settings['bg_image']['id'], 'full');
            }
        ?>

        <div class="explore-area d-flex align-items-center explore-height"
            data-background="<?php echo esc_url($bg_image); ?>">
            <div class="container text-center text-xxl-end">
                <div class="epix-explore-content bdevs-el-content text-center d-inline-block">
                    <?php if( !empty($settings['extra_sub_title']) ) : ?>
                    <h6 class="epix-explore-subtitle bdevs-el-subtitle"><?php echo bdevs_element_kses_basic($settings['extra_sub_title']); ?></h6>
                    <?php endif; ?>
                    <?php if( !empty($settings['extra_title']) ) : ?>
                    <h3 class="epix-explore-title bdevs-el-title"><?php echo bdevs_element_kses_basic($settings['extra_title']); ?></h3>
                    <?php endif; ?>
                    <?php if( !empty($settings['extra_button_text']) ) : ?>
                    <a href="<?php echo esc_url($settings['extra_button_link']); ?>" class="epix-btn-black-2 bdevs-el-btn"><?php echo esc_html($settings['extra_button_text']); ?></a>
                    <?php endif; ?>
                </div>
            </div>
        </div>


        <?php elseif ( $settings['design_style'] === 'style_6' ) : 

            if( !empty($settings['bg_image']['id']) ) {
                $bg_image = wp_get_attachment_image_url($settings['bg_image']['id'], 'full');
            }

        ?>

        <div class="banner-3-1 style-2">
            <div class="thumb bdevs-el-thumb">
                <img src="<?php echo esc_url($bg_image); ?>" class="img-fluid" alt="<?php echo esc_html__('banner-bg', 'bdevs-element'); ?>">
            </div>
            <div class="content bdevs-el-content">
                <?php if( !empty($settings['extra_title']) ) : ?>
                <h3 class="bdevs-el-title"><?php echo bdevs_element_kses_basic($settings['extra_title']); ?></h3>
                <?php endif; ?>
                <?php if( !empty($settings['extra_desc']) ) : ?>
                <p><?php echo bdevs_element_kses_basic($settings['extra_desc']); ?></p>
                <?php endif; ?>
                <?php if( !empty($settings['extra_button_text']) ) : ?>
                <a href="<?php echo esc_url($settings['extra_button_link']); ?>" class="transparent-btn text-capitalize rounded-0 bdevs-el-btn"><?php echo esc_html($settings['extra_button_text']); ?> <i class="fal fa-angle-right"></i></a>
                <?php endif; ?>
            </div>
        </div>


        <?php elseif ( $settings['design_style'] === 'style_5' ) : 

            if( !empty($settings['bg_image']['id']) ) {
                $bg_image = wp_get_attachment_image_url($settings['bg_image']['id'], 'full');
            }


        ?>

        <section class="sub-banner-area">
          <div class="container">
            <div class="banner-inner bdevs-el-content pt-95 pb-80 pl-95 pr-95" data-background="<?php echo esc_url($bg_image); ?>">
              <div class="text-center d-inline-block">
                <?php if( !empty($settings['extra_sub_title']) ) : ?>
                <h5 class="epix-s-banner-subtitle bdevs-el-subtitle"><?php echo bdevs_element_kses_basic($settings['extra_sub_title']); ?></h5>
                <?php endif; ?>
                <?php if( !empty($settings['extra_title']) ) : ?>
                <h3 class="epix-s-banner-title bdevs-el-title"><?php echo bdevs_element_kses_basic($settings['extra_title']); ?></h3>
                <?php endif; ?>
                <?php if( !empty($settings['extra_button_text']) ) : ?>
                <a href="<?php echo esc_url($settings['extra_button_link']); ?>" class="epix-btn-1 bdevs-el-btn" tabindex="0"><span><?php echo esc_html($settings['extra_button_text']); ?><i
                      class="fal fa-angle-right"></i></span></a>
                <?php endif; ?>
              </div>
            </div>
          </div>
        </section>



        <?php elseif ( $settings['design_style'] === 'style_4' ) : 

            if( !empty($settings['bg_image']['id']) ) {
                $bg_image = wp_get_attachment_image_url($settings['bg_image']['id'], 'full');
            }


        ?>
        <div class="container">
            <div class="row">
              <div class="col-xxl-12">
                <div class="deal-product-collection pl-100 pr-100">

                    <?php foreach ( $settings['slides'] as $key=> $slide ):
                        if ( !empty($slide['image']['id']) ) {
                            $image = wp_get_attachment_image_url( $slide['image']['id'], $settings['thumbnail_size'] );
                            if ( ! $image ) {
                                $image = $slide['image']['url'];
                            }
                        }
                        if(0 == $key) {
                            $_border_cls = 'after-border';
                        }else {
                            $_border_cls = '';
                        }
                        if(1 == $key) {
                            $_align_cls = 'text-xl-end';
                        }else {
                            $_align_cls = '';
                        }
                    ?>
                  <div class="single-collection bdevs-el-content-tab <?php echo esc_attr($_border_cls); ?>">
                    <div class="<?php echo esc_attr($_align_cls); ?>">
                      <div class="d-collection-thumb">
                        <?php if( !empty($slide['selected_icon']) ): ?>
                            <?php bdevs_element_render_icon( $slide, 'icon', 'selected_icon', ['class' => 'bdevs-btn-icon'] ); ?>
                            <?php else: ?>
                            <img src="<?php echo esc_url($image); ?>" alt="icon" />
                        <?php endif; ?>
                      </div>
                      <div class="d-collection-content text-start">
                        <?php if( !empty($slide['title']) ) : ?>
                        <h4 class="bdevs-el-title"><a href="<?php echo esc_url($slide['title_link']); ?>"><?php echo bdevs_element_kses_basic($slide['title']); ?></a></h4>
                        <?php endif; ?>
                        <?php if( !empty($slide['banner_button_text']) ) : ?>
                        <a href="<?php echo esc_url($slide['banner_button_link']); ?>" class="link-details bdevs-el-btn"><?php echo esc_html($slide['banner_button_text']); ?><i class="fal fa-angle-right"></i></a>
                        <?php endif; ?>
                      </div>
                    </div>
                  </div>
                  <?php endforeach; ?>

                </div>
                
              </div>
            </div>
        </div>


        <?php elseif ( $settings['design_style'] === 'style_3' ) : 

            if( !empty($settings['bg_image']['id']) ) {
                $bg_image = wp_get_attachment_image_url($settings['bg_image']['id'], 'full');
            }



        ?>

        <section class="promo-area">
          <div class="container">
            <div class="promo-banner pl-75 pr-90 pt-30 pb-35 theme-bg">
              <div class="row">
                <div class="col-xxl-5 col-xl-5 col-lg-6">
                  <div class="box-wrap bdevs-el-content">
                    <?php foreach ( $settings['slides'] as $slide ):
                        if ( !empty($slide['image']['id']) ) {
                            $image = wp_get_attachment_image_url( $slide['image']['id'], $settings['thumbnail_size'] );
                            if ( ! $image ) {
                                $image = $slide['image']['url'];
                            }
                        }
                    ?>
                    <div class="epix-p-box">
                      <div class="epix-p-icon epixx_p_icon">
                        <?php if( !empty($slide['selected_icon']) ): ?>
                            <?php bdevs_element_render_icon( $slide, 'icon', 'selected_icon', ['class' => 'bdevs-btn-icon'] ); ?>
                            <?php else: ?>
                            <img src="<?php echo esc_url($image); ?>" alt="icon" />
                        <?php endif; ?>
                        <?php if( !empty($slide['title']) ) : ?>
                        <span class="label bdevs-el-title-tab"><?php echo esc_html($slide['title']); ?></span>
                        <?php endif; ?>
                      </div>
                    </div>
                    <?php endforeach; ?>

                  </div>
                </div>
                <div class="col-xxl-3 col-xl-3 d-none d-xl-block">
                  <?php if( !empty($bg_image) ) : ?>
                  <div class="promo-img">
                    <img src="<?php echo esc_url($bg_image); ?>" alt="<?php echo esc_html__('promo-img', 'bdevs-element'); ?>">
                  </div>
                  <?php endif; ?>
                </div>
                <?php if( !empty($settings['extra_title']) ) : ?>
                <div class="col-xxl-4 col-xl-4 col-lg-6 d-flex align-items-center justify-content-center justify-content-lg-end">
                  <h3 class="promo-title bdevs-el-title d-inline-block text-center"><?php echo bdevs_element_kses_basic($settings['extra_title']); ?></h3>
                </div>
                <?php endif; ?>

              </div>
            </div>
          </div>
        </section>

        <?php elseif ( $settings['design_style'] === 'style_2' ) : 
            $title = bdevs_element_kses_basic( $settings['title'] );
        ?>

        <div class="epix-single-banner-2 bdevs-el-content wow fadeInUp" data-wow-delay=".4s">
            <?php if( !empty($settings['title']) ) : ?>
            <h3 class="epix-c-heading-2 bdevs-el-title"><?php echo bdevs_element_kses_intermediate($settings['title']); ?></h3>
            <?php endif; ?>

            <?php if( !empty($settings['description']) ) : ?>
            <p><?php echo bdevs_element_kses_intermediate($settings['description']); ?></p>
            <?php endif; ?>

            <?php if ( $settings['banner_link'] ) : ?>  
            <a class="epix-white-btn bdevs-el-btn" href="<?php echo esc_url($settings['banner_link']); ?>"><?php echo bdevs_element_kses_intermediate($settings['banner_button_text']); ?><i class="fal fa-angle-right"></i></a>
            <?php endif; ?>
        </div>

        <?php else: 
        $this->add_render_attribute('title', 'class', 'bdevs-el-title');
        if( !empty($settings['bg_image']['id']) ) {
            $bg_image = wp_get_attachment_image_url( $settings['bg_image']['id'], 'full' );
        }
        
        ?>

        <div class="asingle-feature bdevs-el-content">
            <?php printf( '<%1$s %2$s>%3$s</%1$s>',
                tag_escape( $settings['title_tag'] ),
                $this->get_render_attribute_string( 'title' ),
                $title
            ); ?>
            <?php if( !empty($settings['description']) ) : ?>
            <p><?php echo bdevs_element_kses_intermediate($settings['description']); ?></p>
            <?php endif; ?>
            <?php if ( $settings['banner_link'] ) : ?>  
            <a class="feature-btn bdevs-el-btn" href="<?php echo esc_url($settings['banner_link']); ?>"><?php echo bdevs_element_kses_intermediate($settings['banner_button_text']); ?></a>
            <?php endif; ?>
        </div>

        <?php endif; ?>

        <?php
    }
}
