<?php

namespace BdevsElement\Widget;

use \Elementor\Group_Control_Background;
Use \Elementor\Core\Schemes\Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Control_Media;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Typography;

defined('ABSPATH') || die();

class Contact_info extends BDevs_El_Widget
{

    /**
     * Get widget name.
     *
     * Retrieve Bdevs Element widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'contact_info';
    }

    /**
     * Get widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return __('Contact Info', 'bdevs-element');
    }

    /**
     * Get widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-site-title';
    }

    public function get_keywords()
    {
        return ['info', 'blurb', 'box', 'text', 'content'];
    }

    /**
     * Register content related controls
     */
    protected function register_content_controls()
    {

        $this->start_controls_section(
            '_section_design_title',
            [
                'label' => __('Design Style', 'bdevs-element'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'design_style',
            [
                'label' => __('Design Style', 'bdevs-element'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => __('Style 1: Main Form', 'bdevs-element'),
                    'style_2' => __('Style 2: Form Two', 'bdevs-element'),
                ],
                'default' => 'style_1',
                'frontend_available' => true,
                'style_transfer' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_section_title',
            [
                'label' => __('Title & Description', 'bdevs-element'),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_1']
                ]
            ]
        );

        $this->add_control(
            'heading_switch',
            [
                'label' => __('Show', 'bdevs-element'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'bdevs-element'),
                'label_off' => __('Hide', 'bdevs-element'),
                'return_value' => 'yes',
                'default' => 'yes',
                'style_transfer' => true,
            ]
        );


        $this->add_control(
            'title',
            [
                'label' => __('Title', 'bdevs-element'),
                'label_block' => true,
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('bdevs Info Box Title', 'bdevs-element'),
                'placeholder' => __('Type Info Box Title', 'bdevs-element'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'contact_paragraph',
            [
                'label' => __('Contact paragraph', 'bdevs-element'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('Contact content goes here', 'bdevs-element'),
                'placeholder' => __('Type content', 'bdevs-element'),
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );
        $this->add_control(
            'title_tag',
            [
                'label' => __('Title HTML Tag', 'bdevs-element'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'h1' => [
                        'title' => __('H1', 'bdevs-element'),
                        'icon' => 'eicon-editor-h1'
                    ],
                    'h2' => [
                        'title' => __('H2', 'bdevs-element'),
                        'icon' => 'eicon-editor-h2'
                    ],
                    'h3' => [
                        'title' => __('H3', 'bdevs-element'),
                        'icon' => 'eicon-editor-h3'
                    ],
                    'h4' => [
                        'title' => __('H4', 'bdevs-element'),
                        'icon' => 'eicon-editor-h4'
                    ],
                    'h5' => [
                        'title' => __('H5', 'bdevs-element'),
                        'icon' => 'eicon-editor-h5'
                    ],
                    'h6' => [
                        'title' => __('H6', 'bdevs-element'),
                        'icon' => 'eicon-editor-h6'
                    ]
                ],
                'default' => 'h3',
                'toggle' => false,
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label' => __('Alignment', 'bdevs-element'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'bdevs-element'),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'bdevs-element'),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'bdevs-element'),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}}' => 'text-align: {{VALUE}};'
                ]
            ]
        );

        $this->end_controls_section();

        // img
        $this->start_controls_section(
            '_section_about_image',
            [
                'label' => __('Image', 'bdevs-element'),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_10']
                ]
            ]
        );

        $this->add_control(
            'shape_img_1',
            [
                'label' => __('Shape 1', 'bdevs-element'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'shape_img_2',
            [
                'label' => __('Shape 2', 'bdevs-element'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'large',
                'separator' => 'none',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_section_features_list',
            [
                'label' => __('Contact List', 'bdevs-element'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'field_condition',
            [
                'label' => __( 'Field condition', 'bdevs-element' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'field_condition_1' => __( 'Condition 1', 'bdevs-element' ),
                    'field_condition_2' => __( 'Condition 2', 'bdevs-element' ),
                    'field_condition_3' => __( 'Condition 3', 'bdevs-element' ),
                ],
                'default' => 'field_condition_1',
                'frontend_available' => true,
                'style_transfer' => true,
            ]
        );

        $repeater->add_control(
            'type',
            [
                'label' => __('Media Type', 'bdevs-element'),
                'type' => Controls_Manager::CHOOSE,
                'label_block' => false,
                'options' => [
                    'icon' => [
                        'title' => __('Icon', 'bdevs-element'),
                        'icon' => 'fa fa-smile-o',
                    ],
                    'image' => [
                        'title' => __('Image', 'bdevs-element'),
                        'icon' => 'fa fa-image',
                    ],
                ],
                'default' => 'icon',
                'toggle' => false,
                'style_transfer' => true,
            ]
        );

        $repeater->add_control(
            'image',
            [
                'label' => __('Image', 'bdevs-element'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'type' => 'image'
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'medium_large',
                'separator' => 'none',
                'exclude' => [
                    'full',
                    'custom',
                    'large',
                    'shop_catalog',
                    'shop_single',
                    'shop_thumbnail'
                ],
                'condition' => [
                    'type' => 'image'
                ]
            ]
        );

        if (bdevs_element_is_elementor_version('<', '2.6.0')) {
            $repeater->add_control(
                'icon',
                [
                    'label' => __('Icon', 'bdevs-element'),
                    'label_block' => true,
                    'type' => Controls_Manager::ICON,
                    'options' => bdevs_element_get_bdevs_element_icons(),
                    'default' => 'fa fa-smile-o',
                    'condition' => [
                        'type' => 'icon'
                    ]
                ]
            );
        } else {
            $repeater->add_control(
                'selected_icon',
                [
                    'type' => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'label_block' => true,
                    'default' => [
                        'value' => 'fas fa-smile-wink',
                        'library' => 'fa-solid',
                    ],
                    'condition' => [
                        'type' => 'icon'
                    ]
                ]
            );
        }

        $repeater->add_control(
            'tab_title',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'label' => __('Label', 'bdevs-element'),
                'default' => __('Label', 'bdevs-element'),
                'placeholder' => __('Type title here', 'bdevs-element'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_control(
            'tab_content',
            [
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'show_label' => false,
                'placeholder' => __('Type address here', 'bdevs-element'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'field_condition' => ['field_condition_1'],
                ],
            ]
        );

        $repeater->add_control(
            'tab_email',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'show_label' => false,
                'placeholder' => __('Type email', 'bdevs-element'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'field_condition' => ['field_condition_2'],
                ],
            ]
        );

        $repeater->add_control(
            'tab_email_link',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'show_label' => false,
                'placeholder' => __('Type email link', 'bdevs-element'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'field_condition' => ['field_condition_2'],
                ],
            ]
        );

        $repeater->add_control(
            'tab_email_2',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'show_label' => false,
                'placeholder' => __('Type email 2', 'bdevs-element'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'field_condition' => ['field_condition_2'],
                ],
            ]
        );

        $repeater->add_control(
            'tab_email_link_2',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'show_label' => false,
                'placeholder' => __('Type email link 2', 'bdevs-element'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'field_condition' => ['field_condition_2'],
                ],
            ]
        );

        $repeater->add_control(
            'tab_phone',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'show_label' => false,
                'placeholder' => __('Type phone number', 'bdevs-element'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'field_condition' => ['field_condition_3'],
                ],
            ]
        );


        $repeater->add_control(
            'tab_phone_link',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'show_label' => false,
                'placeholder' => __('Type phone link', 'bdevs-element'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'field_condition' => ['field_condition_3'],
                ],
            ]
        );

        $repeater->add_control(
            'tab_phone_2',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'show_label' => false,
                'placeholder' => __('Type phone number 2', 'bdevs-element'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'field_condition' => ['field_condition_3'],
                ],
            ]
        );


        $repeater->add_control(
            'tab_phone_link_2',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'show_label' => false,
                'placeholder' => __('Type phone link 2', 'bdevs-element'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'field_condition' => ['field_condition_3'],
                ],
            ]
        );
        $repeater->add_control(
            'button_text',
            [
                'label' => __('Button Text', 'bdevs-element'),
                'type' => Controls_Manager::TEXT,
                'default' => 'Learn More',
                'placeholder' => __('Type button text here', 'bdevs-element'),
                'label_block' => true,
                'condition' => [
                    'field_condition' => ['field_condition_30'],
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_control(
            'button_url',
            [
                'label' => __('Button URL', 'bdevs-element'),
                'type' => Controls_Manager::TEXT,
                'default' => '#',
                'placeholder' => __('button url', 'bdevs-element'),
                'label_block' => true,
                'condition' => [
                    'field_condition' => ['field_condition_30'],
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'slides',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '<# print(tab_title || "Carousel Item"); #>',
                'default' => [
                    [
                        'image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                ]
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            '_section_social_list',
            [
                'label' => __('Social List', 'bdevs-element'),
                'tab' => Controls_Manager::TAB_CONTENT,

            ]
        );

        $this->add_control(
            '_socials_title',
            [
                'label' => __('Social Title', 'bdevs-element'),
                'type' => Controls_Manager::TEXT,
                'default' => 'Keep Eye On',
                'placeholder' => __('Share Socials', 'bdevs-element'),
                'label_block' => true,
                'condition' => [
                    'design_style' => ['style_2'],
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater = new Repeater();


        $repeater->add_control(
            'type',
            [
                'label' => __('Media Type', 'bdevs-element'),
                'type' => Controls_Manager::CHOOSE,
                'label_block' => false,
                'options' => [
                    'icon_2' => [
                        'title' => __('Icon', 'bdevs-element'),
                        'icon' => 'fa fa-smile-o',
                    ],
                    'image_2' => [
                        'title' => __('Image', 'bdevs-element'),
                        'icon' => 'fa fa-image',
                    ],
                ],
                'default' => 'icon',
                'toggle' => false,
                'style_transfer' => true,
            ]
        );

        $repeater->add_control(
            'image_2',
            [
                'label' => __('Image', 'bdevs-element'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'type' => 'image_2'
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'medium_large',
                'separator' => 'none',
                'exclude' => [
                    'full',
                    'custom',
                    'large',
                    'shop_catalog',
                    'shop_single',
                    'shop_thumbnail'
                ],
                'condition' => [
                    'type' => 'image_2'
                ]
            ]
        );

        if (bdevs_element_is_elementor_version('<', '2.6.0')) {
            $repeater->add_control(
                'icon_2',
                [
                    'label' => __('Icon', 'bdevs-element'),
                    'label_block' => true,
                    'type' => Controls_Manager::ICON,
                    'options' => bdevs_element_get_bdevs_element_icons(),
                    'default' => 'fa fa-smile-o',
                    'condition' => [
                        'type' => 'icon_2'
                    ]
                ]
            );
        } else {
            $repeater->add_control(
                'selected_icon_2',
                [
                    'type' => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'label_block' => true,
                    'default' => [
                        'value' => 'fas fa-smile-wink',
                        'library' => 'fa-solid',
                    ],
                    'condition' => [
                        'type' => 'icon_2'
                    ]
                ]
            );
        }

        $repeater->add_control(
            'social_icon_link',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'label' => __('Social Link', 'bdevs-element'),
                'default' => __('#', 'bdevs-element'),
                'placeholder' => __('Insert Link', 'bdevs-element'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'socials',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '<# print(social_icon_link || "Carousel Item"); #>',
                'default' => [
                    [
                        'image_2' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'image_2' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                ]
            ]
        );

        $this->end_controls_section();

    }

    /**
     * Register styles related controls
     */
    protected function register_style_controls(){
        $this->start_controls_section(
            '_section_style_content',
            [
                'label' => __( 'Title / Content', 'bdevs-element' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->add_responsive_control(
            'content_padding',
            [
                'label' => __( 'Content Padding', 'bdevs-element' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'content_background',
                'selector' => '{{WRAPPER}} .bdevs-el-content',
                'exclude' => [
                    'image'
                ]
            ]
        );

                // Subtitle    
        $this->add_control(
            '_contact_icon',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Icon', 'bdevs-element' ),
                'separator' => 'before'
            ]
        );
        
        $this->add_responsive_control(
            'icon_spacing',
            [
                'label' => __( 'Icon Spacing', 'bdevs-element' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-icon' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
            'icon_color',
            [
                'label' => __( 'Icon Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-icon i' => 'color: {{VALUE}}',
                ],
            ]
        );

        // Section Title
        $this->add_control(
            '_heading_section_title',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Section Title', 'bdevs-element' ),
                'separator' => 'before'
            ]
        );
        
        $this->add_responsive_control(
            'title_section_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bdevs-element' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-title-section' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_section_color',
            [
                'label' => __( 'Title Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-title-section' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        // Title
        $this->add_control(
            '_heading_title',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Title', 'bdevs-element' ),
                'separator' => 'before'
            ]
        );
        
        $this->add_responsive_control(
            'title_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bdevs-element' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title',
                'selector' => '{{WRAPPER}} .bdevs-el-title',
                'scheme' => Typography::TYPOGRAPHY_2,
            ]
        );
        
        // Subtitle    
        $this->add_control(
            '_heading_subtitle',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Subtitle', 'bdevs-element' ),
                'separator' => 'before'
            ]
        );
        
        $this->add_responsive_control(
            'subtitle_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bdevs-element' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-subtitle' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
            'subtitle_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-subtitle' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'subtitle_hvr_color',
            [
                'label' => __( 'Text hover Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-subtitle a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle',
                'selector' => '{{WRAPPER}} .bdevs-el-subtitle',
                'scheme' => Typography::TYPOGRAPHY_3,
            ]
        );
        
        // description
        $this->add_control(
            '_content_description',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Description', 'bdevs-element' ),
                'separator' => 'before'
            ]
        );
        
        $this->add_responsive_control(
            'description_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bdevs-element' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-content p' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
            'description_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-content p' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'description',
                'selector' => '{{WRAPPER}} .bdevs-el-content p',
                'scheme' => Typography::TYPOGRAPHY_4,
            ]
        );
        
        
        $this->end_controls_section();

        // Button 1 style
        $this->start_controls_section(
            '_section_style_button',
            [
                'label' => __( 'Social Button', 'bdevs-element' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'button_padding',
            [
                'label' => __( 'Padding', 'bdevs-element' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'selector' => '{{WRAPPER}} .bdevs-el-btn',
                'scheme' => Typography::TYPOGRAPHY_4,
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button_border',
                'selector' => '{{WRAPPER}} .bdevs-el-btn',
            ]
        );

        $this->add_control(
            'button_border_radius',
            [
                'label' => __( 'Border Radius', 'bdevs-element' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_box_shadow',
                'selector' => '{{WRAPPER}} .bdevs-el-btn',
            ]
        );

        $this->add_control(
            'hr',
            [
                'type' => Controls_Manager::DIVIDER,
                'style' => 'thick',
            ]
        );

        $this->start_controls_tabs( '_tabs_button' );

        $this->start_controls_tab(
            '_tab_button_normal',
            [
                'label' => __( 'Normal', 'bdevs-element' ),
            ]
        );

        $this->add_control(
            'button_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_bg_color',
            [
                'label' => __( 'Background Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            '_tab_button_hover',
            [
                'label' => __( 'Hover', 'bdevs-element' ),
            ]
        );

        $this->add_control(
            'button_hover_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn:hover, {{WRAPPER}} .bdevs-el-btn:focus' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_hover_bg_color',
            [
                'label' => __( 'Background Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn:hover, {{WRAPPER}} .bdevs-el-btn:focus' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_hover_border_color',
            [
                'label' => __( 'Border Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'button_border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn:hover, {{WRAPPER}} .bdevs-el-btn:focus' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

       // services item 
       $this->start_controls_section(
        '_box_section_style_content',
        [
            'label' => __( 'Box Title / Content', 'bdevs-element' ),
            'tab'   => Controls_Manager::TAB_STYLE,
            'condition' => [
                'design_style' => ['style_500']
            ]
        ]
    );
    
    $this->add_responsive_control(
        '_box_content_padding',
        [
            'label' => __( 'Content Padding', 'bdevs-element' ),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', 'em', '%' ],
            'selectors' => [
                '{{WRAPPER}} .bdevs-box-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]
    );
    
    $this->add_group_control(
        Group_Control_Background::get_type(),
        [
            'name' => 'box_content_background',
            'selector' => '{{WRAPPER}} .bdevs-box-content',
            'exclude' => [
                'image'
            ]
        ]
    );
    
    // Box Title
    $this->add_control(
        '_box_heading_title',
        [
            'type' => Controls_Manager::HEADING,
            'label' => __( 'Title', 'bdevs-element' ),
            'separator' => 'before'
        ]
    );
    
    $this->add_responsive_control(
        '_box_title_spacing',
        [
            'label' => __( 'Bottom Spacing', 'bdevs-element' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => ['px'],
            'selectors' => [
                '{{WRAPPER}} .bdevs-box-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
            ],
        ]
    );
    
    $this->add_control(
        '_box_title_color',
        [
            'label' => __( 'Text Color', 'bdevs-element' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .bdevs-box-title' => 'color: {{VALUE}}',
            ],
        ]
    );
    
    $this->add_group_control(
        Group_Control_Typography::get_type(),
        [
            'name' => 'boxtitle',
            'selector' => '{{WRAPPER}} .bdevs-box-title',
            'scheme' => Typography::TYPOGRAPHY_2,
        ]
    );
    
    // description
    $this->add_control(
        '_box_content_description',
        [
            'type' => Controls_Manager::HEADING,
            'label' => __( 'Description', 'bdevs-element' ),
            'separator' => 'before'
        ]
    );
    
    $this->add_responsive_control(
        '_box_description_spacing',
        [
            'label' => __( 'Bottom Spacing', 'bdevs-element' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => ['px'],
            'selectors' => [
                '{{WRAPPER}} .bdevs-box-content p' => 'margin-bottom: {{SIZE}}{{UNIT}};',
            ],
        ]
    );
    
    $this->add_control(
        '_box_description_color',
        [
            'label' => __( 'Text Color', 'bdevs-element' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .bdevs-box-content p' => 'color: {{VALUE}}',
            ],
        ]
    );
    
    $this->add_group_control(
        Group_Control_Typography::get_type(),
        [
            'name' => 'boxdescription',
            'selector' => '{{WRAPPER}} .bdevs-box-content p',
            'scheme' => Typography::TYPOGRAPHY_4,
        ]
    );
    
    $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $this->add_inline_editing_attributes('title', 'basic');
        $this->add_render_attribute('title', 'data-wow-delay', '.4s');

        $title = bdevs_element_kses_basic($settings['title']);

        if (!empty($settings['shape_img_1']['id'])) {
            $shape_img_1 = wp_get_attachment_image_url($settings['shape_img_1']['id'], $settings['thumbnail_size']);
        }
        if (!empty($settings['shape_img_2']['id'])) {
            $shape_img_2 = wp_get_attachment_image_url($settings['shape_img_2']['id'], $settings['thumbnail_size']);
        }
        ?>

        <?php if ($settings['design_style'] === 'style_2'): 
        $this->add_render_attribute('title', 'class', 'fadeInUp wow');
        ?>

            <div class="epixx_contact_wrapper">
                <?php foreach ($settings['slides'] as $key => $slide) : ?>
                <li class="epixx_contact_single">
                    <span class="epixx_icon bdevs-el-icon">
                    <?php if ($slide['type'] === 'image' && ($slide['image']['url'] || $slide['image']['id'])) : ?>
                        <?php echo Group_Control_Image_Size::get_attachment_image_html($slide, 'thumbnail', 'image'); ?>
                        <?php elseif (!empty($slide['icon']) || !empty($slide['selected_icon']['value'])) : ?>
                        <?php bdevs_element_render_icon($slide, 'icon', 'selected_icon'); ?>
                    <?php endif; ?>
                    </span>
                    <div class="epixx_icon_content">
                        <?php if( !empty($slide['tab_title']) ) : ?>
                        <h6 class="bdevs-el-title"><?php echo bdevs_element_kses_basic($slide['tab_title']); ?></h6>
                        <?php endif; ?>

                        <?php if( !empty($slide['tab_content']) ) : ?>
                        <span class="bdevs-el-subtitle"><?php echo esc_html($slide['tab_content']); ?></span>
                        <?php endif; ?>

                        <?php if( !empty($slide['tab_email']) ) : ?>

                        <span class="bdevs-el-subtitle"><a href="mailto:<?php echo esc_url($slide['tab_email_link']); ?>"><?php echo esc_html($slide['tab_email']); ?></a></span>
                        <?php endif; ?>

                        <?php if( !empty($slide['tab_email_2']) ) : ?>

                        <span class="bdevs-el-subtitle"><a href="mailto:<?php echo esc_url($slide['tab_email_link_2']); ?>"><?php echo esc_html($slide['tab_email_2']); ?></a></span>
                        <?php endif; ?>


                        <?php if( !empty($slide['tab_phone']) ) : ?>
                        <span class="bdevs-el-subtitle"><a href="tel:<?php echo esc_url($slide['tab_phone_link']); ?>"><?php echo esc_html($slide['tab_phone']); ?></a></span>
                        <?php endif; ?>

                        <?php if( !empty($slide['tab_phone_2']) ) : ?>
                        <span class="bdevs-el-subtitle"><a href="tel:<?php echo esc_url($slide['tab_phone_link_2']); ?>"><?php echo esc_html($slide['tab_phone_2']); ?></a></span>
                        <?php endif; ?>
                    </div>
                </li>
                <?php endforeach; ?>

                <div class="epixx_contact_social">
                    <?php if( !empty($settings['_socials_title']) ) : ?>
                    <h4 class="epixx_social_title bdevs-el-title-section"><?php echo bdevs_element_kses_basic($settings['_socials_title']); ?></h4>
                    <?php endif; ?>
                    <ul>
                        <?php foreach ($settings['socials'] as $key => $social) : ?>
                        <li><a href="<?php echo esc_url($social['social_icon_link']); ?>" class="bdevs-el-btn">
                        <?php if ($social['type'] === 'image_2' && ($social['image_2']['url'] || $social['image_2']['id'])) : ?>
                        <?php echo Group_Control_Image_Size::get_attachment_image_html($slide, 'thumbnail', 'image_2'); ?>
                        <?php elseif (!empty($social['icon_2']) || !empty($social['selected_icon_2']['value'])) : ?>
                            <?php bdevs_element_render_icon($social, 'icon_2', 'selected_icon_2'); ?>
                        <?php endif; ?></a></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>

        <?php else : 
        $this->add_render_attribute('title', 'class', 'fadeInUp wow bdevs-el-title-section');
        ?>

        <div class="contact__info bdevs-el-content">
            <?php printf('<%1$s %2$s>%3$s</%1$s>',
                tag_escape($settings['title_tag']),
                $this->get_render_attribute_string('title'),
                $title
            ); ?>
            <ul class="mb-55">

                <?php foreach ($settings['slides'] as $key => $slide) : ?>
                <li class="d-flex mb-35">
                    
                    <div class="contact__info-icon bdevs-el-icon mr-20">
                        <?php if ($slide['type'] === 'image' && ($slide['image']['url'] || $slide['image']['id'])) : ?>
                    <?php echo Group_Control_Image_Size::get_attachment_image_html($slide, 'thumbnail', 'image'); ?>
                    <?php elseif (!empty($slide['icon']) || !empty($slide['selected_icon']['value'])) : ?>
                        <?php bdevs_element_render_icon($slide, 'icon', 'selected_icon'); ?>
                    <?php endif; ?>
                    </div>
                    
                    <div class="contact__info-content">
                        <?php if( !empty($slide['tab_title']) ) : ?>
                        <h6 class="bdevs-el-title"><?php echo bdevs_element_kses_basic($slide['tab_title']); ?></h6>
                        <?php endif; ?>

                        <?php if( !empty($slide['tab_content']) ) : ?>
                        <span class="bdevs-el-subtitle"><?php echo esc_html($slide['tab_content']); ?></span>
                        <?php endif; ?>

                        <?php if( !empty($slide['tab_email']) ) : ?>

                        <span class="bdevs-el-subtitle"><a href="mailto:<?php echo esc_url($slide['tab_email_link']); ?>"><?php echo esc_html($slide['tab_email']); ?></a></span>
                        <?php endif; ?>


                        <?php if( !empty($slide['tab_phone']) ) : ?>
                        <span class="bdevs-el-subtitle"><a href="tel:<?php echo esc_url($slide['tab_phone_link']); ?>"><?php echo esc_html($slide['tab_phone']); ?></a></span>
                        <?php endif; ?>

                        <?php if( !empty($slide['tab_phone_2']) ) : ?>
                        <span class="bdevs-el-subtitle"><a href="tel:<?php echo esc_url($slide['tab_phone_link_2']); ?>"><?php echo esc_html__(',  ', 'epixx'); ?><?php echo esc_html($slide['tab_phone_2']); ?></a></span>
                        <?php endif; ?>
                    </div>
                </li>
                <?php endforeach; ?>


            </ul>
            <p><?php echo bdevs_element_kses_basic($settings['contact_paragraph']); ?></p>

            <div class="contact__social">
                <ul>
                    <?php foreach ($settings['socials'] as $key => $social) : ?>
                    <li><a href="<?php echo esc_url($social['social_icon_link']); ?>" class="bdevs-el-btn">
                    <?php if ($social['type'] === 'image_2' && ($social['image_2']['url'] || $social['image_2']['id'])) : ?>
                    <?php echo Group_Control_Image_Size::get_attachment_image_html($slide, 'thumbnail', 'image_2'); ?>
                    <?php elseif (!empty($social['icon_2']) || !empty($social['selected_icon_2']['value'])) : ?>
                        <?php bdevs_element_render_icon($social, 'icon_2', 'selected_icon_2'); ?>
                    <?php endif; ?></a></li>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>

        <?php endif; ?>

        <?php
    }
}
