<?php
namespace BdevsElement\Widget;

use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Css_Filter;
use \Elementor\Repeater;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Typography;
Use \Elementor\Core\Schemes\Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Box_Shadow;

defined( 'ABSPATH' ) || die();

class Slider extends BDevs_El_Widget {

    /**
     * Get widget name.
     *
     * Retrieve Bdevs Element widget name.
     *
     * @since 1.0.1
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'slider';
    }


    /**
     * Get widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __( 'Slider', 'bdevs-element' );
    }

    public function get_custom_help_url() {
        return 'http://elementor.bdevs.net//widgets/slider/';
    }

    /**
     * Get widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-slider-full-screen';
    }

    public function get_keywords() {
        return [ 'slider', 'image', 'gallery', 'carousel' ];
    }

    protected function register_content_controls() {


        // Background Overlay
        $this->start_controls_section(
            '_section_background_overlay',
            [
                'label' => __( 'Background Overlay', 'elementor' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_10'],
                ], 
            ]
        );
        
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'label' => __( 'Background', 'bdevs-element' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .single-slider::before,{{WRAPPER}} .slider__content-2::before',
            ]
        );

        $this->add_control(
            'background_overlay_opacity',
            [
                'label' => __( 'Opacity', 'elementor' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => .5,
                ],
                'range' => [
                    'px' => [
                        'max' => 1,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}}  .single-slider::before,{{WRAPPER}} .slider__content-2::before' => 'opacity: {{SIZE}};',
                ]
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            '_section_slides',
            [
                'label' => __( 'Slides', 'bdevs-element' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label' => __( 'Design Style', 'bdevs-element' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => __( 'Style 1', 'bdevs-element' ),
                    'style_2' => __( 'Style 2', 'bdevs-element' ),
                    'style_3' => __( 'Style 3', 'bdevs-element' ),
                ],
                'default' => 'style_1',
                'frontend_available' => true,
                'style_transfer' => true,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'field_condition',
            [
                'label' => __( 'Field condition', 'bdevs-element' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => __( 'Style 1', 'bdevs-element' ),
                    'style_2' => __( 'Style 2', 'bdevs-element' ),
                    'style_3' => __( 'Style 3', 'bdevs-element' ),
                ],
                'default' => 'style_1',
                'frontend_available' => true,
                'style_transfer' => true,
            ]
        );


        $repeater->add_control(
            'image',
            [
                'type' => Controls_Manager::MEDIA,
                'label' => __( 'Image', 'bdevs-element' ),
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );   


        $repeater->add_control(
            'subtitle',
            [
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'show_label' => true,
                'label' => __( 'Sub Title', 'bdevs-element' ),
                'default' => __( 'Subtitle', 'bdevs-element' ),
                'placeholder' => __( 'Type subtitle here', 'bdevs-element' ),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );                    

        $repeater->add_control(
            'title',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'label' => __( 'Title', 'bdevs-element' ),
                'default' => __( 'Title Here', 'bdevs-element' ),
                'placeholder' => __( 'Type title here', 'bdevs-element' ),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );        

        $repeater->add_control(
            'desc',
            [
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'label' => __( 'Description', 'bdevs-element' ),
                'default' => __( 'Here content', 'bdevs-element' ),
                'placeholder' => __( 'Type title here', 'bdevs-element' ),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'field_condition' => ['style_3']
                ]
            ]
        );

        //button two
        $repeater->add_control(
            'button_text',
            [
                'label' => __( 'Text', 'bdevs-element' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Button Text',
                'placeholder' => __( 'Type button text here', 'bdevs-element' ),
                'label_block' => true, 
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_control(
            'button_link',
            [
                'label' => __( 'Link', 'bdevs-element' ),
                'type' => Controls_Manager::URL,
                'placeholder' => 'http://elementor.bdevs.net/', 
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        if ( bdevs_element_is_elementor_version( '<', '2.6.0' ) ) {
            $repeater->add_control(
                'button_icon',
                [
                    'label' => __( 'Icon', 'bdevs-element' ),
                    'label_block' => true,
                    'type' => Controls_Manager::ICON,
                    'options' => bdevs_element_get_bdevs_element_icons(),
                    'default' => 'fa fa-angle-right',
                ]
            );

            $condition = ['button_icon!' => ''];
        } else {
            $repeater->add_control(
                'button_selected_icon',
                [
                    'type' => Controls_Manager::ICONS,
                    'fa4compatibility' => 'button_icon',
                    'label_block' => true,
                ]
            );
            $condition = ['button_selected_icon[value]!' => ''];
        }

        $repeater->add_control(
            'button_icon_position',
            [
                'label' => __( 'Icon Position', 'bdevs-element' ),
                'type' => Controls_Manager::CHOOSE,
                'label_block' => false,
                'options' => [
                    'before' => [
                        'title' => __( 'Before', 'bdevs-element' ),
                        'icon' => 'eicon-h-align-left',
                    ],
                    'after' => [
                        'title' => __( 'After', 'bdevs-element' ),
                        'icon' => 'eicon-h-align-right',
                    ],
                ],
                'default' => 'before',
                'toggle' => false,
                'condition' => $condition,
                'style_transfer' => true,
            ]
        );

        $repeater->add_control(
            'button_icon_spacing',
            [
                'label' => __( 'Icon Spacing', 'bdevs-element' ),
                'type' => Controls_Manager::SLIDER,
                'condition' => $condition,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn--icon-before .bdevs-el-btn-icon' => 'margin-right: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .bdevs-el-btn--icon-after .bdevs-el-btn-icon' => 'margin-left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'slides',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '<# print(title || "Carousel Item"); #>',
                'default' => [
                    [
                        'image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ]
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'medium_large',
                'separator' => 'before',
                'exclude' => [
                    'custom'
                ]
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            '_section_video',
            [
                'label' => __( 'Video Section', 'bdevs-element' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_3']
                ]
            ]
        );



        $this->add_control(
            'video_img',
            [
                'type' => Controls_Manager::MEDIA,
                'label' => __( 'Video Img', 'bdevs-element' ),
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'video_url',
            [
                'type' => Controls_Manager::TEXT,
                'label' => __( 'Video URL', 'bdevs-element' ),
                'label_block' => true,
                'default' => __('#', 'bdevs-element'),
                'placeholder' => __('Place Video URL', 'bdevs-element'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );   


        $this->end_controls_section();

        $this->start_controls_section(
            '_section_banner_sm',
            [
                'label' => __( 'Banner Small', 'bdevs-element' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_3']
                ]
            ]
        );



        $this->add_control(
            'banner_img',
            [
                'type' => Controls_Manager::MEDIA,
                'label' => __( 'Banner Img', 'bdevs-element' ),
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'banner_title',
            [
                'type' => Controls_Manager::TEXT,
                'label' => __( 'Banner Title', 'bdevs-element' ),
                'label_block' => true,
                'default' => __('Music Monster', 'bdevs-element'),
                'placeholder' => __('Place Banner Title', 'bdevs-element'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );


        $this->add_control(
            'banner_desc',
            [
                'type' => Controls_Manager::TEXTAREA,
                'label' => __( 'Banner Description', 'bdevs-element' ),
                'label_block' => true,
                'default' => __('Description goes here', 'bdevs-element'),
                'placeholder' => __('Place Banner Desc', 'bdevs-element'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'banner_text',
            [
                'type' => Controls_Manager::TEXT,
                'label' => __( 'Button Text', 'bdevs-element' ),
                'label_block' => true,
                'default' => __('Shop Now', 'bdevs-element'),
                'placeholder' => __('Place Button Text', 'bdevs-element'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'banner_text_url',
            [
                'type' => Controls_Manager::TEXT,
                'label' => __( 'Button URL', 'bdevs-element' ),
                'label_block' => true,
                'default' => __('#', 'bdevs-element'),
                'placeholder' => __('Place Button URL', 'bdevs-element'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );   


        $this->end_controls_section();



        $this->start_controls_section(
            '_section_banner',
            [
                'label' => __( 'Banner Big', 'bdevs-element' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_3']
                ]
            ]
        );



        $this->add_control(
            'banner_img2',
            [
                'type' => Controls_Manager::MEDIA,
                'label' => __( 'Banner Img', 'bdevs-element' ),
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );


        $this->add_control(
            'banner_title2',
            [
                'type' => Controls_Manager::TEXT,
                'label' => __( 'Banner Title', 'bdevs-element' ),
                'label_block' => true,
                'default' => __('Music Monster', 'bdevs-element'),
                'placeholder' => __('Place Banner Title', 'bdevs-element'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );


        $this->add_control(
            'banner_desc2',
            [
                'type' => Controls_Manager::TEXTAREA,
                'label' => __( 'Banner Description', 'bdevs-element' ),
                'label_block' => true,
                'default' => __('Description goes here', 'bdevs-element'),
                'placeholder' => __('Place Banner Desc', 'bdevs-element'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'banner_text2',
            [
                'type' => Controls_Manager::TEXT,
                'label' => __( 'Button Text', 'bdevs-element' ),
                'label_block' => true,
                'default' => __('Shop Now', 'bdevs-element'),
                'placeholder' => __('Place Button Text', 'bdevs-element'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'banner_text2_url',
            [
                'type' => Controls_Manager::TEXT,
                'label' => __( 'Button URL', 'bdevs-element' ),
                'label_block' => true,
                'default' => __('#', 'bdevs-element'),
                'placeholder' => __('Place Button URL', 'bdevs-element'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );   


        $this->end_controls_section();

        // Slider Settings 
        $this->start_controls_section(
            '_section_settings',
            [
                'label' => __( 'Settings', 'bdevs-element' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

       $this->add_control(
            'ts_slider_autoplay',
            [
                'label' => esc_html__( 'Autoplay', 'bdevs-element' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'bdevs-element' ),
                'label_off' => esc_html__( 'No', 'bdevs-element' ),
                'return_value' => 'yes',
                'default' => 'no'
            ]
        );

        $this->add_control(
            'ts_slider_speed',
            [
               'label' => esc_html__( 'Slider Speed', 'bdevs-element' ),
               'type' => Controls_Manager::NUMBER,
               'placeholder' => esc_html__( 'Enter Slider Speed', 'bdevs-element' ),
               'default' => '5000',
               'condition' => ["ts_slider_autoplay" => ['yes']],
            ]
          );

        $this->add_control(
        'ts_slider_nav_show',
            [
            'label' => esc_html__( 'Nav show', 'bdevs-element' ),
            'type' => Controls_Manager::SWITCHER,
            'label_on' => esc_html__( 'Yes', 'bdevs-element' ),
            'label_off' => esc_html__( 'No', 'bdevs-element' ),
            'return_value' => 'yes',
            'default' => 'yes'
            ]
        );
        $this->add_control(
         'ts_slider_dot_nav_show',
             [
             'label' => esc_html__( 'Dot nav', 'bdevs-element' ),
             'type' => Controls_Manager::SWITCHER,
             'label_on' => esc_html__( 'Yes', 'bdevs-element' ),
             'label_off' => esc_html__( 'No', 'bdevs-element' ),
             'return_value' => 'yes',
             'default' => 'yes'
             ]
         );

        $this->end_controls_section();
    }

    // style control 
    protected function register_style_controls() {
        $this->start_controls_section(
            '_section_style_overlay',
            [
                'label' => __( 'BG Color', 'bdevs-element' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );


        $this->add_control(
            'slide_overlay_bg',
            [
                'label' => __( 'Slider Overlay BG Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sl-overlay::before' => 'background-color: {{VALUE}}',
                ],
            ]
        );


        $this->add_control(
            'slide_shape_bg',
            [
                'label' => __( 'Slider Shape BG Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-circle-shape, {{WRAPPER}} .slider-circle-shape-sm' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();


        // Title / Content
        $this->start_controls_section(
            '_section_style_content',
            [
                'label' => __( 'Title / Content', 'bdevs-element' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'content_padding',
            [
                'label' => __( 'Content Padding', 'bdevs-element' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'content_background',
                'selector' => '{{WRAPPER}} .bdevs-el-content',
                'exclude' => [
                    'image'
                ]
            ]
        );

        // Title
        $this->add_control(
            '_heading_title',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Title', 'bdevs-element' ),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'title_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bdevs-element' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title',
                'selector' => '{{WRAPPER}} .bdevs-el-title',
                'scheme' => Typography::TYPOGRAPHY_2,
            ]
        );

        // Subtitle    
        $this->add_control(
            '_heading_subtitle',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Subtitle', 'bdevs-element' ),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'subtitle_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bdevs-element' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-subtitle' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'subtitle_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-subtitle' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle',
                'selector' => '{{WRAPPER}} .bdevs-el-subtitle',
                'scheme' => Typography::TYPOGRAPHY_3,
            ]
        );

        // description
        $this->add_control(
            '_content_description',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Description', 'bdevs-element' ),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'description_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bdevs-element' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-content p' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'description_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-content p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'description',
                'selector' => '{{WRAPPER}} .bdevs-el-content p',
                'scheme' => Typography::TYPOGRAPHY_4,
            ]
        );


        $this->end_controls_section();

        // Button 1 style
        $this->start_controls_section(
            '_section_style_button',
            [
                'label' => __( 'Button', 'bdevs-element' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'button_padding',
            [
                'label' => __( 'Padding', 'bdevs-element' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'selector' => '{{WRAPPER}} .bdevs-el-btn',
                'scheme' => Typography::TYPOGRAPHY_4,
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button_border',
                'selector' => '{{WRAPPER}} .bdevs-el-btn',
            ]
        );

        $this->add_control(
            'button_border_radius',
            [
                'label' => __( 'Border Radius', 'bdevs-element' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_box_shadow',
                'selector' => '{{WRAPPER}} .bdevs-el-btn',
            ]
        );

        $this->add_control(
            'hr',
            [
                'type' => Controls_Manager::DIVIDER,
                'style' => 'thick',
            ]
        );

        $this->start_controls_tabs( '_tabs_button' );

        $this->start_controls_tab(
            '_tab_button_normal',
            [
                'label' => __( 'Normal', 'bdevs-element' ),
            ]
        );

        $this->add_control(
            'button_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_bg_color',
            [
                'label' => __( 'Background Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            '_tab_button_hover',
            [
                'label' => __( 'Hover', 'bdevs-element' ),
            ]
        );

        $this->add_control(
            'button_hover_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn:hover, {{WRAPPER}} .bdevs-el-btn:focus' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_hover_bg_color',
            [
                'label' => __( 'Background Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn:hover, {{WRAPPER}} .bdevs-el-btn:focus, {{WRAPPER}} epix-btn-1:before' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_hover_border_color',
            [
                'label' => __( 'Border Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'button_border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn:hover, {{WRAPPER}} .bdevs-el-btn:focus' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

        /** button 2 **/
        $this->start_controls_section(
            '_section_style_button2',
            [
                'label' => __( 'Button 2', 'bdevs-element' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'button2_padding',
            [
                'label' => __( 'Padding', 'bdevs-element' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn-sec' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button2_typography',
                'selector' => '{{WRAPPER}} .bdevs-el-btn-sec',
                'scheme' => Typography::TYPOGRAPHY_4,
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button2_border',
                'selector' => '{{WRAPPER}} .bdevs-el-btn-sec',
            ]
        );

        $this->add_control(
            'button2_border_radius',
            [
                'label' => __( 'Border Radius', 'bdevs-element' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn-sec' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button2_box_shadow',
                'selector' => '{{WRAPPER}} .bdevs-el-btn-sec',
            ]
        );

        $this->add_control(
            'hr2',
            [
                'type' => Controls_Manager::DIVIDER,
                'style' => 'thick',
            ]
        );

        $this->start_controls_tabs( '_tabs_button2' );

        $this->start_controls_tab(
            '_tab_button2_normal',
            [
                'label' => __( 'Normal', 'bdevs-element' ),
            ]
        );

        $this->add_control(
            'button2_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn-sec' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button2_bg_color',
            [
                'label' => __( 'Background Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn-sec' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            '_tab_button2_hover',
            [
                'label' => __( 'Hover', 'bdevs-element' ),
            ]
        );

        $this->add_control(
            'button2_hover_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn-sec:hover, {{WRAPPER}} .bdevs-el-btn-sec:focus' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button2_hover_bg_color',
            [
                'label' => __( 'Background Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn.red:hover, {{WRAPPER}} .bdevs-el-btn.red:focus' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button2_hover_border_color',
            [
                'label' => __( 'Border Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'button_border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn-sec:hover, {{WRAPPER}} .bdevs-el-btn-sec:focus' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();


        //slider banner small
        $this->start_controls_section(
            '_slider_banner_sm',
            [
                'label' => __( 'Banner Small', 'bdevs-element' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'design_style' => ['style_3']
                ],
            ]
        );

        $this->add_responsive_control(
            '_banner_sm_padding',
            [
                'label' => __( 'Content Padding', 'bdevs-element' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-content-sm' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        // Title
        $this->add_control(
            '_banner_sm_title',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Title', 'bdevs-element' ),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'banner_sm_title_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bdevs-element' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-title-sm' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'banner_sm_title_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-title-sm' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => '_banner_sm_title',
                'selector' => '{{WRAPPER}} .bdevs-el-title-sm',
                'scheme' => Typography::TYPOGRAPHY_2,
            ]
        );

        // Subtitle    
        $this->add_control(
            '_banner_sm_subtitle',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Subtitle', 'bdevs-element' ),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            '_banner_sm_subtitle_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bdevs-element' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-subtitle-sm' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            '_banner_sm_subtitle_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-subtitle-sm' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => '_banner_sm_subtitle',
                'selector' => '{{WRAPPER}} .bdevs-el-subtitle-sm',
                'scheme' => Typography::TYPOGRAPHY_3,
            ]
        );

        // description
        $this->add_control(
            '_banner_sm_description',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Description', 'bdevs-element' ),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            '_banner_sm_description_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bdevs-element' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-content-sm p' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            '_banner_sm_description_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-content-sm p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => '_banner_sm_description',
                'selector' => '{{WRAPPER}} .bdevs-el-content-sm p',
                'scheme' => Typography::TYPOGRAPHY_4,
            ]
        );


        //banner sm button 
        $this->add_control(
            '_banner_sm_button',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Banner Section sm', 'bdevs-element' ),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            '_banner_sm_button_padding',
            [
                'label' => __( 'Padding', 'bdevs-element' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn-sm' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => '_banner_sm_button_typography',
                'selector' => '{{WRAPPER}} .bdevs-el-btn-sm',
                'scheme' => Typography::TYPOGRAPHY_4,
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => '_banner_sm_button_border',
                'selector' => '{{WRAPPER}} .bdevs-el-btn-sm',
            ]
        );

        $this->add_control(
            '_banner_sm_button_border_radius',
            [
                'label' => __( 'Border Radius', 'bdevs-element' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn-sm' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => '_banner_sm_button_box_shadow',
                'selector' => '{{WRAPPER}} .bdevs-el-btn-sm',
            ]
        );

        $this->add_control(
            'hr_sm',
            [
                'type' => Controls_Manager::DIVIDER,
                'style' => 'thick',
            ]
        );

        $this->start_controls_tabs( '_sm_tabs_button' );

        $this->start_controls_tab(
            '_banner_sm_tab_button_normal',
            [
                'label' => __( 'Normal', 'bdevs-element' ),
            ]
        );

        $this->add_control(
            '_banner_sm_button_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn-sm' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            '_banner_sm_button_bg_color',
            [
                'label' => __( 'Background Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn-sm' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            '_banner_sm_tab_button_hover',
            [
                'label' => __( 'Hover', 'bdevs-element' ),
            ]
        );

        $this->add_control(
            '_banner_sm_button_hover_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn-sm:hover, {{WRAPPER}} .bdevs-el-btn-sm:focus' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            '_banner_sm_button_hover_bg_color',
            [
                'label' => __( 'Background Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn-sm:hover, {{WRAPPER}} .bdevs-el-btn-sm:focus' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            '_banner_sm_button_hover_border_color',
            [
                'label' => __( 'Border Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'button_border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn-sm:hover, {{WRAPPER}} .bdevs-el-btn-sm:focus' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

        //slider banner small
        $this->start_controls_section(
            '_slider_banner_lg',
            [
                'label' => __( 'Banner Large', 'bdevs-element' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'design_style' => ['style_3']
                ],
            ]
        );

        $this->add_responsive_control(
            '_banner_lg_padding',
            [
                'label' => __( 'Content Padding', 'bdevs-element' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-content-lg' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        // Title
        $this->add_control(
            '_banner_lg_title',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Title', 'bdevs-element' ),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'banner_lg_title_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bdevs-element' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-title-lg' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'banner_lg_title_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-title-lg' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => '_banner_lg_title',
                'selector' => '{{WRAPPER}} .bdevs-el-title-lg',
                'scheme' => Typography::TYPOGRAPHY_2,
            ]
        );

        // Subtitle    
        $this->add_control(
            '_banner_lg_subtitle',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Subtitle', 'bdevs-element' ),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            '_banner_lg_subtitle_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bdevs-element' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-subtitle-lg' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            '_banner_lg_subtitle_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-subtitle-lg' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => '_banner_lg_subtitle',
                'selector' => '{{WRAPPER}} .bdevs-el-subtitle-lg',
                'scheme' => Typography::TYPOGRAPHY_3,
            ]
        );

        // description
        $this->add_control(
            '_banner_lg_description',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Description', 'bdevs-element' ),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            '_banner_lg_description_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bdevs-element' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-content-lg p' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            '_banner_lg_description_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-content-lg p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => '_banner_lg_description',
                'selector' => '{{WRAPPER}} .bdevs-el-content-lg p',
                'scheme' => Typography::TYPOGRAPHY_4,
            ]
        );

        //banner lg button 
        $this->add_control(
            '_banner_lg_button',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Banner Section lg', 'bdevs-element' ),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            '_banner_lg_button_padding',
            [
                'label' => __( 'Padding', 'bdevs-element' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn-lg' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => '_banner_lg_button_typography',
                'selector' => '{{WRAPPER}} .bdevs-el-btn-lg',
                'scheme' => Typography::TYPOGRAPHY_4,
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => '_banner_lg_button_border',
                'selector' => '{{WRAPPER}} .bdevs-el-btn-lg',
            ]
        );

        $this->add_control(
            '_banner_lg_button_border_radius',
            [
                'label' => __( 'Border Radius', 'bdevs-element' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn-lg' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => '_banner_lg_button_box_shadow',
                'selector' => '{{WRAPPER}} .bdevs-el-btn-lg',
            ]
        );

        $this->add_control(
            'hr_lg',
            [
                'type' => Controls_Manager::DIVIDER,
                'style' => 'thick',
            ]
        );

        $this->start_controls_tabs( '_lg_tabs_button' );

        $this->start_controls_tab(
            '_banner_lg_tab_button_normal',
            [
                'label' => __( 'Normal', 'bdevs-element' ),
            ]
        );

        $this->add_control(
            '_banner_lg_button_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn-lg' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            '_banner_lg_button_bg_color',
            [
                'label' => __( 'Background Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn-lg' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            '_banner_lg_tab_button_hover',
            [
                'label' => __( 'Hover', 'bdevs-element' ),
            ]
        );

        $this->add_control(
            '_banner_lg_button_hover_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn-lg:hover, {{WRAPPER}} .bdevs-el-btn-lg:focus' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            '_banner_lg_button_hover_bg_color',
            [
                'label' => __( 'Background Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn-lg:hover, {{WRAPPER}} .bdevs-el-btn-lg:focus' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            '_banner_lg_button_hover_border_color',
            [
                'label' => __( 'Border Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'button_border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn-lg:hover, {{WRAPPER}} .bdevs-el-btn-lg:focus' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

        // Navigation - Arrow
        $this->start_controls_section(
            '_section_style_arrow',
            [
                'label' => __( 'Navigation - Arrow', 'bdevs-element' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'arrow_position_toggle',
            [
                'label' => __( 'Position', 'bdevs-element' ),
                'type' => Controls_Manager::POPOVER_TOGGLE,
                'label_off' => __( 'None', 'bdevs-element' ),
                'label_on' => __( 'Custom', 'bdevs-element' ),
                'return_value' => 'yes',
            ]
        );

        $this->start_popover();

        $this->add_responsive_control(
            'arrow_position_y',
            [
                'label' => __( 'Vertical', 'bdevs-element' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'condition' => [
                    'arrow_position_toggle' => 'yes'
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-navigation .bdevs-button-prev, {{WRAPPER}} .bdevs-navigation .bdevs-button-next' => 'top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'arrow_position_x',
            [
                'label' => __( 'Horizontal', 'bdevs-element' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'condition' => [
                    'arrow_position_toggle' => 'yes'
                ],
                'range' => [
                    'px' => [
                        'min' => -100,
                        'max' => 250,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-navigation .bdevs-button-prev' => 'left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .bdevs-navigation .bdevs-button-next' => 'right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_popover();

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'arrow_border',
                'selector' => '{{WRAPPER}} .bdevs-navigation .bdevs-button-next, {{WRAPPER}} .bdevs-navigation .bdevs-button-prev',
            ]
        );

        $this->add_responsive_control(
            'arrow_border_radius',
            [
                'label' => __( 'Border Radius', 'bdevs-element' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-navigation .bdevs-button-next, {{WRAPPER}} .bdevs-navigation .bdevs-button-prev' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;',
                ],
            ]
        );

        $this->start_controls_tabs( '_tabs_arrow' );

        $this->start_controls_tab(
            '_tab_arrow_normal',
            [
                'label' => __( 'Normal', 'bdevs-element' ),
            ]
        );

        $this->add_control(
            'arrow_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .bdevs-navigation .bdevs-button-next i, {{WRAPPER}} .bdevs-navigation .bdevs-button-prev i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'arrow_bg_color',
            [
                'label' => __( 'Background Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-navigation .bdevs-button-next, {{WRAPPER}} .bdevs-navigation .bdevs-button-prev' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            '_tab_arrow_hover',
            [
                'label' => __( 'Hover', 'bdevs-element' ),
            ]
        );

        $this->add_control(
            'arrow_hover_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-navigation .bdevs-button-next:hover i, {{WRAPPER}} .bdevs-navigation .bdevs-button-prev:hover i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'arrow_hover_bg_color',
            [
                'label' => __( 'Background Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-navigation .bdevs-button-prev:hover, {{WRAPPER}} .bdevs-navigation .bdevs-button-next:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'arrow_hover_border_color',
            [
                'label' => __( 'Border Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'arrow_border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-navigation .bdevs-button-next:hover, {{WRAPPER}} .bdevs-navigation .bdevs-button-prev:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            '_section_style_dots',
            [
                'label' => __( 'Navigation - Dots', 'bdevs-element' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'dots_nav_position_y',
            [
                'label' => __( 'Vertical Position', 'bdevs-element' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => -100,
                        'max' => 500,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .epixx-pagination' => 'bottom: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->add_responsive_control(
            'dots_nav_spacing',
            [
                'label' => __( 'Spacing', 'bdevs-element' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .epixx-pagination span' => 'margin-right: calc({{SIZE}}{{UNIT}} / 2 ) !important; margin-left: calc({{SIZE}}{{UNIT}} / 2) !important;',
                ],
            ]
        );

        $this->add_responsive_control(
            'dots_nav_align',
            [
                'label' => __( 'Alignment', 'bdevs-element' ),
                'type' => Controls_Manager::CHOOSE,
                'label_block' => false,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', 'bdevs-element' ),
                        'icon' => 'eicon-h-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'bdevs-element' ),
                        'icon' => 'eicon-h-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', 'bdevs-element' ),
                        'icon' => 'eicon-h-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .epixx-pagination' => 'text-align: {{VALUE}}'
                ]
            ]
        );

        $this->start_controls_tabs( '_tabs_dots' );
        $this->start_controls_tab(
            '_tab_dots_normal',
            [
                'label' => __( 'Normal', 'bdevs-element' ),
            ]
        );

        $this->add_control(
            'dots_nav_color',
            [
                'label' => __( 'Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .epixx-pagination span' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            '_tab_dots_hover',
            [
                'label' => __( 'Active', 'bdevs-element' ),
            ]
        );

        $this->add_control(
            'dots_nav_hover_color',
            [
                'label' => __( 'Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .epixx-pagination span.swiper-pagination-bullet-active' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        ;
        $this->end_controls_tabs();

        $this->end_controls_section();
    }


    protected function render() {
        $settings = $this->get_settings_for_display();

        // ================
        $show_navigation   =   $settings["ts_slider_nav_show"]=="yes"?true:false;
        $auto_nav_slide    =   $settings['ts_slider_autoplay'];
        $dot_nav_show      =   $settings['ts_slider_dot_nav_show'];
        $ts_slider_speed   =   $settings['ts_slider_speed'] ? $settings['ts_slider_speed'] : '5000';

        // ================


        if ( empty( $settings['slides'] ) ) {
            return;
        }

        $this->add_render_attribute( 'button_no_icon', 'class', 'custom_btn bg_default_orange btn-no-icon wow fadeInUp222' );

        ?>

        <?php if ( $settings['design_style'] === 'style_4' ):

        $this->add_render_attribute( 'button', 'class', 'z-btn z-btn-border' );
        
        ?>

        <section class="slider__area slider__area-2  slick-nav-style slick-dot-black">
            <div class="slider-active" data-controls="<?php echo esc_attr($slide_controls); ?>">
                <?php foreach ( $settings['slides'] as $key => $slide ) :
                    $image = wp_get_attachment_image_url( $slide['image']['id'], $settings['thumbnail_size'] );
                    if ( ! $image ) {
                        $image = $slide['image']['url'];
                    } 

                    $this->add_render_attribute( 'button_'. $key, 'class', 'z-btn z-btn-transparent bdevs-el-btn' );
                    $this->add_render_attribute( 'button_'. $key, 'href', $slide['button_link']['url'] );
                ?>

                <div class="single-slider single-slider-2 slider__height-shop d-flex align-items-center" data-background="<?php print esc_url($image); ?>">
                    <div class="container">
                        <div class="row">
                            <div class="col-xl-6 col-lg-7 col-md-9">
                                <div class="slider__content slider__content-2 slider__content-4 slider__content-shop-4 bdevs-el-content">
                                    <?php if( $slide['subtitle'] ): ?>
                                    <span class="bdevs-el-subtitle" data-animation="fadeInUp2" data-delay=".3s"><?php echo bdevs_element_kses_basic( $slide['subtitle'] ); ?></span>
                                    <?php endif; ?> 
                                    <?php if( $slide['title'] ): ?>
                                    <h1 class="bdevs-el-title" data-animation="fadeInUp2" data-delay=".5s">
                                        <?php echo bdevs_element_kses_basic( $slide['title'] ); ?></h1>
                                    <?php endif; ?> 
                                    <?php if ( $slide['desc'] ) : ?>
                                    <p data-animation="fadeInUp2" data-delay=".7s">
                                        <?php echo bdevs_element_kses_intermediate( $slide['desc'] ); ?>
                                    </p>
                                    <?php endif; 
                                        if(!empty($slide['button_text'])) :
                                    ?>
                                    <div class="slider__btn" data-animation="fadeInUp2" data-delay=".9s">
                                        <?php if ( $slide['button_text'] && ( ( empty( $slide['button_selected_icon'] ) || empty( $slide['button_selected_icon']['value'] ) ) && empty( $slide['button_icon'] ) ) ) :
                                                printf( '<a %1$s>%2$s</a>',
                                                    $this->get_render_attribute_string( 'button_'. $key ),
                                                    esc_html( $slide['button_text'] )
                                                    );
                                            elseif ( empty( $slide['button_text'] ) && ( ( !empty( $slide['button_selected_icon'] ) || empty( $slide['button_selected_icon']['value'] ) ) || !empty( $slide['button_icon'] ) ) ) : ?>
                                                <a <?php $this->print_render_attribute_string( 'button_'. $key ); ?>><?php bdevs_element_render_icon( $slide, 'button_icon', 'button_selected_icon' ); ?></a>
                                            <?php elseif ( $slide['button_text'] && ( ( !empty( $slide['button_selected_icon'] ) || empty( $slide['button_selected_icon']['value'] ) ) || !empty($slide['button_icon']) ) ) :
                                                if ( $slide['button_icon_position'] === 'before' ): ?>
                                                    <a <?php $this->print_render_attribute_string( 'button_'. $key ); ?>><span><?php bdevs_element_render_icon( $slide, 'button_icon', 'button_selected_icon', ['class' => 'bdevs-btn-icon'] ); ?></span> <?php echo esc_html($slide['button_text']); ?></a>
                                                    <?php
                                                else: ?>
                                                    <a <?php $this->print_render_attribute_string( 'button_'. $key ); ?>><?php echo esc_html($slide['button_text']); ?> <span><?php bdevs_element_render_icon( $slide, 'button_icon', 'button_selected_icon', ['class' => 'bdevs-btn-icon'] ); ?></span></a>
                                                <?php
                                                endif;
                                        endif; ?> 
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <?php endforeach; ?>    
            </div>
        </section>      

        <?php elseif ( $settings['design_style'] === 'style_3' ):

            if( !empty($settings['video_img']['id']) ) {
                $video_img = wp_get_attachment_image_url($settings['video_img']['id'], 'full');
            }

            if( !empty($settings['banner_img']['id']) ) {
                $banner_img = wp_get_attachment_image_url($settings['banner_img']['id'], 'full');
            }

            if( !empty($settings['banner_img2']['id']) ) {
                $banner_img2 = wp_get_attachment_image_url($settings['banner_img2']['id'], 'full');
            } 
        
        ?>

        <div class="slider-area">
            <div class="pl-20 pr-20">
                <div class="row row-20">
                    <div class="col-xxl-6 col-lg-6 slider-col-3-1">
                        <div class="slider-active-2 swiper-container" data-swipper_autoplay_stop="<?php echo $auto_nav_slide; ?>">
                            <div class="swiper-wrapper">

                                <?php foreach ( $settings['slides'] as $key => $slide ) :
                                    $image = wp_get_attachment_image_url( $slide['image']['id'], $settings['thumbnail_size'] );
                                    if ( ! $image ) {
                                        $image = $slide['image']['url'];
                                    }
                                    $this->add_render_attribute( 'button_'. $key, 'class', 'transparent-btn bdevs-el-btn' );
                                    $this->add_render_attribute( 'button_'. $key, 'href', $slide['button_link']['url'] );
                                    $this->add_render_attribute( 'button_before_'. $key, 'class', 'slide_before' );
                                    $this->add_render_attribute( 'button_after_'. $key, 'class', 'slide_after' );
                                ?>
                                <div class="swiper-slide">
                                    <div class="single-slider mb-20 d-block slider-height-3  d-flex align-items-center"
                                        data-background="<?php echo esc_url($image); ?>">
                                        <div class="slider-content-3 bdevs-el-content">
                                            <?php if( !empty($slide['subtitle']) ): ?>
                                            <h5 class="slide-subtitle-3 bdevs-el-subtitle" data-animation="fadeInUp2" data-delay=".3s"><?php echo bdevs_element_kses_basic($slide['subtitle']); ?></h5>
                                            <?php endif; ?>
                                            <?php if ( !empty($slide['title']) ) : ?>
                                            <h2 class="slide-title-3 bdevs-el-title" data-animation="fadeInUp2" data-delay=".5s"><?php echo bdevs_element_kses_basic($slide['title']); ?></h2>
                                            <?php endif; ?>
                                            <?php if ( !empty($slide['desc']) ) : ?>
                                            <p data-animation="fadeInUp2" data-delay=".7s"><?php echo bdevs_element_kses_basic($slide['desc']); ?></p>
                                            <?php endif; ?>


                                            <?php if(!empty( $slide['button_text'] )) : ?>

                                                <div class="epixx_slide3_button" data-animation="fadeInUp2" data-delay=".9s">

                                                <?php if ( $slide['button_text'] && ( ( empty( $slide['button_selected_icon'] ) || empty( $slide['button_selected_icon']['value'] ) ) && empty( $slide['button_icon'] ) ) ) :
                                                        printf( '<a %1$s>%2$s</a>',
                                                            $this->get_render_attribute_string( 'button_'. $key ),
                                                            esc_html( $slide['button_text'] )
                                                            );
                                                    elseif ( empty( $slide['button_text'] ) && ( ( !empty( $slide['button_selected_icon'] ) || empty( $slide['button_selected_icon']['value'] ) ) || !empty( $slide['button_icon'] ) ) ) : ?>
                                                        <a <?php $this->print_render_attribute_string( 'button_'. $key ); ?>><?php bdevs_element_render_icon( $slide, 'button_icon', 'button_selected_icon' ); ?></a>
                                                    <?php elseif ( $slide['button_text'] && ( ( !empty( $slide['button_selected_icon'] ) || empty( $slide['button_selected_icon']['value'] ) ) || !empty($slide['button_icon']) ) ) :
                                                        if ( $slide['button_icon_position'] === 'before' ): ?>
                                                            <a <?php $this->print_render_attribute_string( 'button_'. $key ); ?>><span <?php $this->print_render_attribute_string( 'button_before_'. $key ); ?>><?php bdevs_element_render_icon( $slide, 'button_icon', 'button_selected_icon', ['class' => 'bdevs-btn-icon'] ); ?><?php echo esc_html($slide['button_text']); ?></span></a>
                                                            <?php
                                                        else: ?>
                                                            <a <?php $this->print_render_attribute_string( 'button_'. $key ); ?>><span <?php $this->print_render_attribute_string( 'button_after_'. $key ); ?>><?php echo esc_html($slide['button_text']); ?><?php bdevs_element_render_icon( $slide, 'button_icon', 'button_selected_icon', ['class' => 'bdevs-btn-icon'] ); ?></span></a>
                                                        <?php
                                                        endif;
                                                endif; ?> 

                                                </div>

                                                <?php endif; ?>

                                        </div>
                                    </div>
                                </div>
                                <?php endforeach; ?>


                            </div>

                            <?php if(!empty($show_navigation)) : ?>
                            <div class="slider-pagination slider_2_epixx bdevs-navigation">
                                <div class="epixx-slider-next bdevs-button-next swiper-button-next"><i class="fal fa-angle-right"></i></div>
                                <div class="epixx-slider-prev bdevs-button-prev swiper-button-prev"><i class="fal fa-angle-left"></i></div>
                            </div>
                            <?php endif; ?>

                            <?php if(!empty($dot_nav_show)) : ?>
                            <div class="epixx-pagination"></div>
                            <?php endif; ?>

                        </div>
                    </div>
                    <div class="col-xxl-6 col-lg-6 slider-col-3-2">
                        <div class="row row-20">
                            <?php if( !empty($settings['video_url']) ) : ?>
                            <div class="col-xxl-6 col-sm-6 slider-col-3-3 mb-20">
                                <div class="video-product-box video-pro-height">

                                    <img src="<?php echo esc_url($video_img); ?>" alt="<?php echo esc_html__('banner-img', 'bdevs-element'); ?>">
                                    
                                    <a href="<?php echo esc_url($settings['video_url']); ?>" class="popup-video"><i class="fal fa-play"></i></a>
                                    
                                </div>
                            </div>
                            <?php endif; ?>
                            <div class="col-xxl-6 col-sm-6 slider-col-3-4 mb-20">
                                <div class="banner-3-1">

                                    <div class="thumb video-pro-height">
                                        <img src="<?php echo esc_url($banner_img); ?>" class="has-overlay-img" alt="<?php echo esc_html__('banner-img', 'bdevs-element'); ?>">
                                    </div>
                                    <div class="content bdevs-el-content-sm">
                                        <?php if( !empty($settings['banner_title']) ) : ?>
                                        <h3 class="bdevs-el-title-sm"><?php echo bdevs_element_kses_basic($settings['banner_title']); ?></h3>
                                        <?php endif; ?>
                                        <?php if( !empty($settings['banner_desc']) ) : ?>
                                        <p><?php echo bdevs_element_kses_basic($settings['banner_desc']); ?></p>
                                        <?php endif; ?>
                                        <?php if( !empty($settings['banner_text']) ) : ?>
                                        <a href="<?php echo esc_url($settings['banner_text_url']); ?>" class="transparent-btn bdevs-el-btn-sm"><?php echo bdevs_element_kses_basic($settings['banner_text']); ?> <i
                                                class="fal fa-angle-right"></i></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xxl-12">
                                <div class="banner-3-1">
                                    <div class="thumb video-pro-height-2">
                                        <img src="<?php echo esc_url($banner_img2); ?>" alt="<?php echo esc_html__('banner-img', 'bdevs-element'); ?>">
                                    </div>
                                    <div class="content bdevs-el-content-lg">
                                        <?php if( !empty($settings['banner_title2']) ) : ?>
                                        <h3 class="bdevs-el-title-lg"><?php echo bdevs_element_kses_basic($settings['banner_title2']); ?></h3>
                                        <?php endif; ?>

                                        <?php if( !empty($settings['banner_desc2']) ) : ?>
                                        <p><?php echo bdevs_element_kses_basic($settings['banner_desc2']); ?></p>
                                        <?php endif; ?>

                                        <?php if( !empty($settings['banner_text2']) ) : ?>
                                        <a href="<?php echo esc_url($settings['banner_text2_url']); ?>" class="transparent-btn bdevs-el-btn-lg"><?php echo bdevs_element_kses_basic($settings['banner_text2']); ?> <i
                                                class="fal fa-angle-right"></i></a>
                                        <?php endif; ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php elseif ( $settings['design_style'] === 'style_2' ): 
        
        ?>

        <div class="slider-area-2">
            <div class="pl-50 pr-50">
                <div class="slider-active-2 default-slick-arrow swiper-container" data-swipper_autoplay_stop="<?php echo $auto_nav_slide; ?>" >
                    <div class="swiper-wrapper">

                        <?php foreach ( $settings['slides'] as $key => $slide ) :
                            $image = wp_get_attachment_image_url( $slide['image']['id'], $settings['thumbnail_size'] );
                            if ( ! $image ) {
                                $image = $slide['image']['url'];
                            }
                            $this->add_render_attribute( 'button_'. $key, 'class', 'epix-btn-black bdevs-el-btn' );
                            $this->add_render_attribute( 'button_'. $key, 'href', $slide['button_link']['url'] );
                            $this->add_render_attribute( 'button_before_'. $key, 'class', 'slide_before' );
                            $this->add_render_attribute( 'button_after_'. $key, 'class', 'slide_after' );
                        ?>

                        <div class="single-slider swiper-slide bg-default slider-height d-flex align-items-center"
                            data-background="<?php echo esc_url($image); ?>" data-swiper-autoplay="<?php $ts_slider_speed; ?>">
                            <div class="container">
                                <div class="slider-content-2 bdevs-el-content">
                                    <?php if( !empty($slide['subtitle']) ): ?>
                                    <span class="epix-subtitle-2 bdevs-el-subtitle" data-animation="flipInX" data-delay=".2s"><?php echo bdevs_element_kses_basic($slide['subtitle']); ?></span>
                                    <?php endif; ?>
                                    <?php if ( !empty($slide['title']) ) : ?>
                                    <h3 class="epix-title-2 bdevs-el-title" data-animation="flipInX" data-delay=".5s"><?php echo bdevs_element_kses_basic($slide['title']); ?></h3>
                                    <?php endif; ?>


                                   <?php if(!empty( $slide['button_text'] )) : ?>

                                    <div class="epixx_slide2_button" data-animation="flipInX" data-delay=".8s">

                                    <?php if ( $slide['button_text'] && ( ( empty( $slide['button_selected_icon'] ) || empty( $slide['button_selected_icon']['value'] ) ) && empty( $slide['button_icon'] ) ) ) :
                                            printf( '<a %1$s>%2$s</a>',
                                                $this->get_render_attribute_string( 'button_'. $key ),
                                                esc_html( $slide['button_text'] )
                                                );
                                        elseif ( empty( $slide['button_text'] ) && ( ( !empty( $slide['button_selected_icon'] ) || empty( $slide['button_selected_icon']['value'] ) ) || !empty( $slide['button_icon'] ) ) ) : ?>
                                            <a <?php $this->print_render_attribute_string( 'button_'. $key ); ?>><?php bdevs_element_render_icon( $slide, 'button_icon', 'button_selected_icon' ); ?></a>
                                        <?php elseif ( $slide['button_text'] && ( ( !empty( $slide['button_selected_icon'] ) || empty( $slide['button_selected_icon']['value'] ) ) || !empty($slide['button_icon']) ) ) :
                                            if ( $slide['button_icon_position'] === 'before' ): ?>
                                                <a <?php $this->print_render_attribute_string( 'button_'. $key ); ?>><span <?php $this->print_render_attribute_string( 'button_before_'. $key ); ?>><?php bdevs_element_render_icon( $slide, 'button_icon', 'button_selected_icon', ['class' => 'bdevs-btn-icon'] ); ?><?php echo esc_html($slide['button_text']); ?></span></a>
                                                <?php
                                            else: ?>
                                                <a <?php $this->print_render_attribute_string( 'button_'. $key ); ?>><span <?php $this->print_render_attribute_string( 'button_after_'. $key ); ?>><?php echo esc_html($slide['button_text']); ?><?php bdevs_element_render_icon( $slide, 'button_icon', 'button_selected_icon', ['class' => 'bdevs-btn-icon'] ); ?></span></a>
                                            <?php
                                            endif;
                                    endif; ?> 

                                    </div>

                                    <?php endif; ?>

                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>

                    </div>

                    <?php if(!empty($show_navigation)) : ?>
                    <div class="slider-pagination bdevs-navigation"> 
                        <div class="swiper-button-next bdevs-button-next"><i class="fal fa-angle-right"></i></div>
                        <div class="swiper-button-prev bdevs-button-prev"><i class="fal fa-angle-left"></i></div>
                    </div>
                    <?php endif; ?>


                    <?php if(!empty($dot_nav_show)) : ?>
                    <div class="epixx-pagination"></div>
                    <?php endif; ?>


                </div>
            </div>
        </div>

        <?php else: 
        ?>

        <section class="slider-area">
          <div class="slider-active">
            <?php foreach ( $settings['slides'] as $key => $slide ) :
                $image = wp_get_attachment_image_url( $slide['image']['id'], $settings['thumbnail_size'] );
                if ( ! $image ) {
                    $image = $slide['image']['url'];
                }
                $this->add_render_attribute( 'button_'. $key, 'class', 'epix-btn-1 bdevs-el-btn' );
                $this->add_render_attribute( 'button_'. $key, 'href', $slide['button_link']['url'] );
                $this->add_render_attribute( 'button_before_'. $key, 'class', 'slide_before' );
                $this->add_render_attribute( 'button_after_'. $key, 'class', 'slide_after' );
            ?>
            <div class="single-slider d-flex align-items-center slider-height"
              data-background="<?php echo esc_url($image); ?>">
              <div class="container">
                <div class="slider-content bdevs-el-content text-center">

                <?php if( !empty($slide['subtitle']) ): ?>
                <span class="epix-slide-subtitle bdevs-el-subtitle" data-animation="fadeInUp2" data-delay=".3s"><?php echo bdevs_element_kses_basic( $slide['subtitle'] ); ?></span>
                <?php endif; ?>
                <?php if ( !empty($slide['title']) ) : ?>
                <h2 class="epix-slide-title bdevs-el-title" data-animation="fadeInUp2" data-delay=".5s"><?php echo bdevs_element_kses_basic( $slide['title'] ); ?></h2>
                <?php endif; ?>
                <?php if ( !empty($slide['desc']) ) : ?>
                <p data-animation="fadeInUp2" data-delay=".7s"><?php echo bdevs_element_kses_intermediate($slide['desc']); ?></p>
                <?php endif; ?>

                <?php if(!empty( $slide['button_text'] )) : ?>

                <div class="epixx_slide1_button" data-animation="fadeInUp2" data-delay=".7s">

                <?php if ( $slide['button_text'] && ( ( empty( $slide['button_selected_icon'] ) || empty( $slide['button_selected_icon']['value'] ) ) && empty( $slide['button_icon'] ) ) ) :
                        printf( '<a %1$s>%2$s</a>',
                            $this->get_render_attribute_string( 'button_'. $key ),
                            esc_html( $slide['button_text'] )
                            );
                    elseif ( empty( $slide['button_text'] ) && ( ( !empty( $slide['button_selected_icon'] ) || empty( $slide['button_selected_icon']['value'] ) ) || !empty( $slide['button_icon'] ) ) ) : ?>
                        <a <?php $this->print_render_attribute_string( 'button_'. $key ); ?>><?php bdevs_element_render_icon( $slide, 'button_icon', 'button_selected_icon' ); ?></a>
                    <?php elseif ( $slide['button_text'] && ( ( !empty( $slide['button_selected_icon'] ) || empty( $slide['button_selected_icon']['value'] ) ) || !empty($slide['button_icon']) ) ) :
                        if ( $slide['button_icon_position'] === 'before' ): ?>
                            <a <?php $this->print_render_attribute_string( 'button_'. $key ); ?>><span <?php $this->print_render_attribute_string( 'button_before_'. $key ); ?>><?php bdevs_element_render_icon( $slide, 'button_icon', 'button_selected_icon', ['class' => 'bdevs-btn-icon'] ); ?><?php echo esc_html($slide['button_text']); ?></span></a>
                            <?php
                        else: ?>
                            <a <?php $this->print_render_attribute_string( 'button_'. $key ); ?>><span <?php $this->print_render_attribute_string( 'button_after_'. $key ); ?>><?php echo esc_html($slide['button_text']); ?><?php bdevs_element_render_icon( $slide, 'button_icon', 'button_selected_icon', ['class' => 'bdevs-btn-icon'] ); ?></span></a>
                        <?php
                        endif;
                endif; ?> 

                </div>

                <?php endif; ?>
                </div>
              </div>
            </div>
            <?php endforeach; ?>

          </div>
        </section>

        <?php endif; ?>

    <?php
    }
}
