<?php
namespace BdevsElement\Widget;

use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Typography;
Use \Elementor\Core\Schemes\Typography;
use \Elementor\Icons_Manager;
use \Elementor\Repeater;
use \Elementor\Core\Schemes;
use \Elementor\Group_Control_Background;
use \BdevsElement\BDevs_El_Select2;
use Elementor\Utils;

defined('ABSPATH') || die();

class Woo_Product extends BDevs_El_Widget
{

    /**
     * Get widget name.
     *
     * Retrieve Bdevs Element widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'woo_product';
    }

    /**
     * Get widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return __('Woo Product', 'bdevs-element');
    }

    public function get_custom_help_url()
    {
        return 'http://elementor.bdevs.net//widgets/post-list/';
    }

    /**
     * Get widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-product-images';
    }

    public function get_keywords()
    {
        return ['posts', 'post', 'post-list', 'list', 'product'];
    }

    /**
     * Get a list of All Post Types
     *
     * @return array
     */
    public function get_post_types()
    {
        $post_types = bdevs_element_get_post_types([], ['elementor_library', 'attachment']);
        return $post_types;
    }

    protected function register_content_controls()
    {

        //Settings
        $this->start_controls_section(
            '_section_settings',
            [
                'label' => __('Settings', 'bdevs-element'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label' => __('Design Style', 'bdevs-element'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => __('Style 1', 'bdevs-element'),
                    'style_2' => __('Style 2', 'bdevs-element'),
                    'style_3' => __('Style 3', 'bdevs-element'),
                    'style_4' => __('Style 4', 'bdevs-element'),
                    'style_5' => __('Style 5: Product with banner', 'bdevs-element'),
                    'style_6' => __('Style 6: Hot Deals Offer Product', 'bdevs-element'),
                    'style_7' => __('Style 7: Product Carousel with Section button', 'bdevs-element'),
                    'style_8' => __('Style 8: Single Deals Product', 'bdevs-element'),
                ],
                'default' => 'style_1',
                'frontend_available' => true,
                'style_transfer' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_section_extra_content',
            [
                'label' => __('Product Content', 'bdevs-element'),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_2', 'style_3', 'style_5', 'style_6', 'style_7']
                ]
            ]
        );



        $this->add_control(
            'extra_image',
            [
                'label' => esc_html__( 'Choose Image', 'bdevs-element' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'design_style' => ['style_2', 'style_5', 'style_6', 'style_7']
                ]
            ]
        );


        $this->add_control(
            'extra_sub_title',
            [
                'label' => __('Sub Title', 'bdevs-element'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder' => __('Sub Title', 'bdevs-element'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'design_style' => ['style_2', 'style_7']
                ]
            ]
        );

        $this->add_control(
            'extra_title',
            [
                'label' => __('Title', 'bdevs-element'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder' => __('Title', 'bdevs-element'),
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );


        $this->add_control(
            'extra_desc',
            [
                'label' => __('Short Description', 'bdevs-element'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'placeholder' => __('Short Description', 'bdevs-element'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'design_style' => ['style_6']
                ]
            ]
        );

        $this->add_control(
            'sale_date',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'show_label' => true,
                'label' => __('Offer Upto Date', 'bdevs-element'),
                'default' => __('Mar 05 2022', 'bdevs-element'),
                'placeholder' => __('Type date', 'bdevs-element'),
                'condition' => [
                    'design_style' => ['style_3', 'style_6']
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'dell_price',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'show_label' => true,
                'label' => __('Old Price', 'bdevs-element'),
                'default' => __('180.00', 'bdevs-element'),
                'placeholder' => __('Type Price', 'bdevs-element'),
                'condition' => [
                    'design_style' => ['style_6']
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'activee_price',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'show_label' => true,
                'label' => __('Active Price', 'bdevs-element'),
                'default' => __('150.00', 'bdevs-element'),
                'placeholder' => __('Type Price', 'bdevs-element'),
                'condition' => [
                    'design_style' => ['style_6']
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );


        $this->add_control(
            'extra_button_text',
            [
                'label' => __('Button Text', 'bdevs-element'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder' => __('Explore Now', 'bdevs-element'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'design_style' => ['style_1', 'style_2', 'style_3', 'style_4', 'style_5', 'style_6', 'style_7']
                ],
            ]
        );

        $this->add_control(
            'extra_button_link',
            [
                'label' => __('Button URL', 'bdevs-element'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __('#', 'bdevs-element'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'design_style' => ['style_1', 'style_2', 'style_3', 'style_4', 'style_5', 'style_6', 'style_7']
                ],
            ]
        );



        $this->end_controls_section();


        $this->start_controls_section(
            '_section_post_list',
            [
                'label' => __('List', 'bdevs-element'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'extra_seciton_title',
            [
                'label' => __('Section Title', 'bdevs-element'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder' => __('Section Title', 'bdevs-element'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'design_style' => ['style_1', 'style_2', 'style_5', 'style_6']
                ]
            ]
        );

        $this->add_control(
            '_sub_title',
            [
                'label' => __('Sub Desc', 'bdevs-element'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder' => __('Customize Subtext', 'bdevs-element'),
                'default' => __('Hurry up! Offer ends in:', 'bdevs-element'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'design_style' => ['style_8']
                ]
            ]
        );

        $this->add_control(
            'post_type',
            [
                'label' => __('Source', 'bdevs-element'),
                'type' => Controls_Manager::SELECT,
                'options' => $this->get_post_types(),
                'default' => key($this->get_post_types()),
            ]
        );

        $this->add_control(
            'show_post_by',
            [
                'label' => __('Show post by:', 'bdevs-element'),
                'type' => Controls_Manager::SELECT,
                'default' => 'recent',
                'options' => [
                    'recent' => __('Recent Post', 'bdevs-element'),
                    'selected' => __('Selected Post', 'bdevs-element'),
                ],

            ]
        );

        $this->add_control(
            'posts_per_page',
            [
                'label' => __('Item Limit', 'bdevs-element'),
                'type' => Controls_Manager::NUMBER,
                'default' => 3,
                'dynamic' => ['active' => true],
                'condition' => [
                    'show_post_by' => ['recent']
                ]
            ]
        );

        $repeater = [];

        foreach ($this->get_post_types() as $key => $value) {

            $repeater[$key] = new Repeater();

            $repeater[$key]->add_control(
                'title',
                [
                    'label' => __('Title', 'bdevs-element'),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                    'placeholder' => __('Customize Title', 'bdevs-element'),
                    'dynamic' => [
                        'active' => true,
                    ],
                ]
            );

            $repeater[$key]->add_control(
                'post_id',
                [
                    'label' => __('Select ', 'bdevs-element') . $value,
                    'label_block' => true,
                    'type' => BDevs_El_Select2::TYPE,
                    'multiple' => false,
                    'placeholder' => 'Search ' . $value,
                    'data_options' => [
                        'post_type' => $key,
                        'action' => 'bdevs_element_post_list_query'
                    ],
                ]
            );


            $this->add_control(
                'selected_list_' . $key,
                [
                    'label' => '',
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $repeater[$key]->get_controls(),
                    'title_field' => '{{ title }}',
                    'condition' => [
                        'show_post_by' => 'selected',
                        'post_type' => $key
                    ],
                ]
            );
        }

        $this->end_controls_section();



        // Slider Settings 
        $this->start_controls_section(
            '_section_slider_settings',
            [
                'label' => __( 'Settings', 'bdevs-element' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

       $this->add_control(
            'ts_slider_autoplay',
            [
                'label' => esc_html__( 'Autoplay', 'bdevs-element' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'bdevs-element' ),
                'label_off' => esc_html__( 'No', 'bdevs-element' ),
                'return_value' => 'yes',
                'default' => 'no'
            ]
        );

        $this->add_control(
            'ts_slider_speed',
            [
               'label' => esc_html__( 'Slider Speed', 'bdevs-element' ),
               'type' => Controls_Manager::NUMBER,
               'placeholder' => esc_html__( 'Enter Slider Speed', 'bdevs-element' ),
               'default' => '5000',
               'condition' => ["ts_slider_autoplay" => ['yes']],
            ]
          );

        $this->add_control(
        'ts_slider_nav_show',
            [
            'label' => esc_html__( 'Nav show', 'bdevs-element' ),
            'type' => Controls_Manager::SWITCHER,
            'label_on' => esc_html__( 'Yes', 'bdevs-element' ),
            'label_off' => esc_html__( 'No', 'bdevs-element' ),
            'return_value' => 'yes',
            'default' => 'yes'
            ]
        );

        $this->end_controls_section();

    }

    protected function register_style_controls(){
        $this->start_controls_section(
            '_section_style_content',
            [
                'label' => __( 'Title / Content', 'bdevs-element' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->add_responsive_control(
            'content_padding',
            [
                'label' => __( 'Content Padding', 'bdevs-element' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'content_background',
                'selector' => '{{WRAPPER}} .bdevs-el-content',
                'exclude' => [
                    'image'
                ]
            ]
        );

        //Section Title
        $this->add_control(
            '_heading_section_title',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Section Title', 'bdevs-element' ),
                'separator' => 'before'
            ]
        );
        
        $this->add_responsive_control(
            '_section_title_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bdevs-element' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-title-section' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
            '_section_title_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-title-section' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => '_section_title',
                'selector' => '{{WRAPPER}} .bdevs-el-title-section',
                'scheme' => Typography::TYPOGRAPHY_2,
            ]
        );

        //Section Title
        $this->add_control(
            '_heading_section_subtitle',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'SubTitle', 'bdevs-element' ),
                'separator' => 'before'
            ]
        );
        
        $this->add_responsive_control(
            '_section_subtitle_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bdevs-element' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-subtitle-section' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
            '_section_subtitle_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-subtitle-section' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => '_section_subtitle',
                'selector' => '{{WRAPPER}} .bdevs-el-subtitle-section',
                'scheme' => Typography::TYPOGRAPHY_2,
            ]
        );

        //Title
        $this->add_control(
            '_heading_title',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Title', 'bdevs-element' ),
                'separator' => 'before'
            ]
        );
        
        
        $this->add_responsive_control(
            'title_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bdevs-element' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'title_hvr_color',
            [
                'label' => __( 'Text Hover Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-title:hover a' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title',
                'selector' => '{{WRAPPER}} .bdevs-el-title',
                'scheme' => Typography::TYPOGRAPHY_2,
            ]
        );
        
        // Subtitle    
        $this->add_control(
            '_heading_subtitle',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Subtitle', 'bdevs-element' ),
                'separator' => 'before'
            ]
        );
        
        $this->add_responsive_control(
            'subtitle_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bdevs-element' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-subtitle' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
            'subtitle_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-subtitle' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'subtitle_hvr_color',
            [
                'label' => __( 'Text Hover Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-subtitle:hover a' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle',
                'selector' => '{{WRAPPER}} .bdevs-el-subtitle',
                'scheme' => Typography::TYPOGRAPHY_3,
            ]
        );
        
        // description
        $this->add_control(
            '_content_description',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Description', 'bdevs-element' ),
                'separator' => 'before'
            ]
        );
        
        $this->add_responsive_control(
            'description_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bdevs-element' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-content p' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
            'description_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-content p' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'description',
                'selector' => '{{WRAPPER}} .bdevs-el-content p',
                'scheme' => Typography::TYPOGRAPHY_4,
            ]
        );
        
        
        $this->end_controls_section();

        // Button 1 style
        $this->start_controls_section(
            '_section_style_button',
            [
                'label' => __( 'Button', 'bdevs-element' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'button_padding',
            [
                'label' => __( 'Padding', 'bdevs-element' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'selector' => '{{WRAPPER}} .bdevs-el-btn',
                'scheme' => Typography::TYPOGRAPHY_4,
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button_border',
                'selector' => '{{WRAPPER}} .bdevs-el-btn',
            ]
        );

        $this->add_control(
            'button_border_radius',
            [
                'label' => __( 'Border Radius', 'bdevs-element' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_box_shadow',
                'selector' => '{{WRAPPER}} .bdevs-el-btn',
            ]
        );

        $this->add_control(
            'hr',
            [
                'type' => Controls_Manager::DIVIDER,
                'style' => 'thick',
            ]
        );

        $this->start_controls_tabs( '_tabs_button' );

        $this->start_controls_tab(
            '_tab_button_normal',
            [
                'label' => __( 'Normal', 'bdevs-element' ),
            ]
        );

        $this->add_control(
            'button_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_bg_color',
            [
                'label' => __( 'Background Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            '_tab_button_hover',
            [
                'label' => __( 'Hover', 'bdevs-element' ),
            ]
        );

        $this->add_control(
            'button_hover_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn:hover, {{WRAPPER}} .bdevs-el-btn:focus' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_hover_bg_color',
            [
                'label' => __( 'Background Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn:hover, {{WRAPPER}} .bdevs-el-btn:focus, {{WRAPPER}} .bdevs-el-btn:before' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_hover_border_color',
            [
                'label' => __( 'Border Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'button_border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn:hover, {{WRAPPER}} .bdevs-el-btn:focus' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();



        // Navigation - Arrow
        $this->start_controls_section(
            '_section_style_arrow',
            [
                'label' => __( 'Navigation - Arrow', 'bdevs-element' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'arrow_position_toggle',
            [
                'label' => __( 'Position', 'bdevs-element' ),
                'type' => Controls_Manager::POPOVER_TOGGLE,
                'label_off' => __( 'None', 'bdevs-element' ),
                'label_on' => __( 'Custom', 'bdevs-element' ),
                'return_value' => 'yes',
            ]
        );

        $this->start_popover();

        $this->add_responsive_control(
            'arrow_position_y',
            [
                'label' => __( 'Vertical', 'bdevs-element' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'condition' => [
                    'arrow_position_toggle' => 'yes'
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-navigation .bdevs-button-prev, {{WRAPPER}} .bdevs-navigation .bdevs-button-next' => 'top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'arrow_position_x',
            [
                'label' => __( 'Horizontal', 'bdevs-element' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'condition' => [
                    'arrow_position_toggle' => 'yes'
                ],
                'range' => [
                    'px' => [
                        'min' => -100,
                        'max' => 250,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-navigation .bdevs-button-prev' => 'left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .bdevs-navigation .bdevs-button-next' => 'right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_popover();

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'arrow_border',
                'selector' => '{{WRAPPER}} .bdevs-navigation .bdevs-button-next, {{WRAPPER}} .bdevs-navigation .bdevs-button-prev',
            ]
        );

        $this->add_responsive_control(
            'arrow_border_radius',
            [
                'label' => __( 'Border Radius', 'bdevs-element' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-navigation .bdevs-button-next, {{WRAPPER}} .bdevs-navigation .bdevs-button-prev' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;',
                ],
            ]
        );

        $this->start_controls_tabs( '_tabs_arrow' );

        $this->start_controls_tab(
            '_tab_arrow_normal',
            [
                'label' => __( 'Normal', 'bdevs-element' ),
            ]
        );

        $this->add_control(
            'arrow_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .bdevs-navigation .bdevs-button-next i, {{WRAPPER}} .bdevs-navigation .bdevs-button-prev i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'arrow_bg_color',
            [
                'label' => __( 'Background Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-navigation .bdevs-button-next, {{WRAPPER}} .bdevs-navigation .bdevs-button-prev' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            '_tab_arrow_hover',
            [
                'label' => __( 'Hover', 'bdevs-element' ),
            ]
        );

        $this->add_control(
            'arrow_hover_color',
            [
                'label' => __( 'Text Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-navigation .bdevs-button-next:hover i, {{WRAPPER}} .bdevs-navigation .bdevs-button-prev:hover i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'arrow_hover_bg_color',
            [
                'label' => __( 'Background Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-navigation .bdevs-button-prev:hover, {{WRAPPER}} .bdevs-navigation .bdevs-button-next:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'arrow_hover_border_color',
            [
                'label' => __( 'Border Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'arrow_border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-navigation .bdevs-button-next:hover, {{WRAPPER}} .bdevs-navigation .bdevs-button-prev:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();


        // Dots Slider
        $this->start_controls_section(
            '_section_style_dots',
            [
                'label' => __( 'Navigation - Dots', 'bdevs-element' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'design_style' => ['style_500']
                ]
            ]
        );

        $this->add_responsive_control(
            'dots_nav_position_y',
            [
                'label' => __( 'Vertical Position', 'bdevs-element' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => -100,
                        'max' => 500,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .epixx-pagination' => 'bottom: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->add_responsive_control(
            'dots_nav_spacing',
            [
                'label' => __( 'Spacing', 'bdevs-element' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .epixx-pagination span' => 'margin-right: calc({{SIZE}}{{UNIT}} / 2 ) !important; margin-left: calc({{SIZE}}{{UNIT}} / 2) !important;',
                ],
            ]
        );

        $this->add_responsive_control(
            'dots_nav_align',
            [
                'label' => __( 'Alignment', 'bdevs-element' ),
                'type' => Controls_Manager::CHOOSE,
                'label_block' => false,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', 'bdevs-element' ),
                        'icon' => 'eicon-h-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'bdevs-element' ),
                        'icon' => 'eicon-h-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', 'bdevs-element' ),
                        'icon' => 'eicon-h-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .epixx-pagination' => 'text-align: {{VALUE}}'
                ]
            ]
        );

        $this->start_controls_tabs( '_tabs_dots' );
        $this->start_controls_tab(
            '_tab_dots_normal',
            [
                'label' => __( 'Normal', 'bdevs-element' ),
            ]
        );

        $this->add_control(
            'dots_nav_color',
            [
                'label' => __( 'Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .epixx-pagination span' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            '_tab_dots_hover',
            [
                'label' => __( 'Active', 'bdevs-element' ),
            ]
        );

        $this->add_control(
            'dots_nav_hover_color',
            [
                'label' => __( 'Color', 'bdevs-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .epixx-pagination span.swiper-pagination-bullet-active' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        ;
        $this->end_controls_tabs();

        $this->end_controls_section();


    }

    protected function render()
    {

        $settings = $this->get_settings_for_display();

        // ================
        $show_navigation   =   $settings["ts_slider_nav_show"]=="yes"?true:false;
        $auto_nav_slide    =   $settings['ts_slider_autoplay'];
        $ts_slider_speed   =   $settings['ts_slider_speed'] ? $settings['ts_slider_speed'] : '5000';

        // ================

        if (!$settings['post_type']) return;
        $args = [
            'post_status' => 'publish',
            'post_type' => $settings['post_type'],
        ];
        if ('recent' === $settings['show_post_by']) {
            $args['posts_per_page'] = $settings['posts_per_page'];
        }

        $customize_title = [];
        $ids = [];
        if ('selected' === $settings['show_post_by']) {
            $args['posts_per_page'] = -1;
            $lists = $settings['selected_list_' . $settings['post_type']];
            if (!empty($lists)) {
                foreach ($lists as $index => $value) {
                    $ids[] = $value['post_id'];
                    if ($value['title']) $customize_title[$value['post_id']] = $value['title'];
                }
            }
            $args['post__in'] = (array)$ids;
            $args['orderby'] = 'post__in';
        }

        if ('selected' === $settings['show_post_by'] && empty($ids)) {
            $posts = [];
        } else {
            $posts = get_posts($args);
        }

        ?>


        <?php if (!empty($settings['design_style']) and $settings['design_style'] == 'style_8'):
        if( !empty($settings['extra_image']['id']) ) {
            $extra_image = wp_get_attachment_image_url($settings['extra_image']['id'], 'full');
        }
        if (count($posts) !== 0) :
            ?>

        <div class="offer-banner-2">
            <div class="container">
                 <?php foreach ($posts as $post):
                $product = wc_get_product($post->ID); 
                $deal_time = get_post_meta($post->ID, 'deal_date', true);
                $current_deal = current_time('timestamp');
                $convert_deal = strtotime($deal_time);
                ?> 
                <div class="offer-banner-2-content pt-60 pb-35">
                    <div class="offer-product-box">
                        <a href="<?php echo esc_url(get_the_permalink($post->ID)); ?>">
                            <?php echo get_the_post_thumbnail($post->ID, 'large', ['class' => 'img-fluid']); ?>
                        </a>
                    </div>
                    <div class="offer-product-content">
                        <div class="wrap offer_epixx_mb">
                            <span class="epix-p-subtitle bdevs-el-subtitle d-block"><?php echo esc_html($post->post_name); ?></span>
                            <h3 class="title bdevs-el-title">
                                <?php
                                $title = $post->post_title;
                                if ('selected' === $settings['show_post_by'] && array_key_exists($post->ID, $customize_title)) {
                                    $title = $customize_title[$post->ID];
                                }

                                printf('<a href="%2$s">%1$s</a>',
                                    esc_html($title),
                                    esc_url(get_the_permalink($post->ID))
                                );
                                ?>
                            </h3>
                            <div class="epix-price-box">
                              <?php echo \BdevsElement\BDevs_El_Woocommerce::product_price($post->ID, true); ?>
                            </div>
                        </div>
                         <?php if ($current_deal < $convert_deal) : ?>
                        <?php if( !empty($settings['_sub_title']) ) : ?>
                        <div class="offer-label mb-15">
                            <span class="bdevs-el-subtitle-section"><?php echo esc_html($settings['_sub_title']); ?></span>
                        </div>
                        <?php endif; ?>
                        <div class="deals-countdown deals-countdown-2 mb-25">
                            <div class="countdown-inner" data-countdown="" data-date="<?php print $deal_time; ?>">
                                <ul>
                                    <li><span data-days=""></span> <?php echo esc_html__('Days', 'bdevs-element'); ?></li>
                                    <li><span data-hours=""></span> <?php echo esc_html__('Hours', 'bdevs-element'); ?></li>
                                    <li><span data-minutes=""></span> <?php echo esc_html__('Mins', 'bdevs-element'); ?></li>
                                    <li><span data-seconds=""></span> <?php echo esc_html__('Secs', 'bdevs-element'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; ?>

            </div>
        </div>


        <?php
        else:
            printf('%1$s %2$s %3$s',
                __('No ', 'bdevs-element'),
                esc_html($settings['post_type']),
                __('Found', 'bdevs-element')
            );
        endif;
        ?>



        <?php elseif (!empty($settings['design_style']) and $settings['design_style'] == 'style_7'):
        if( !empty($settings['extra_image']['id']) ) {
            $extra_image = wp_get_attachment_image_url($settings['extra_image']['id'], 'full');
        }
        if (count($posts) !== 0) :
            ?>

        <div class="container">
            <div class="epix-product-wrapper bg-top pt-90" data-background="<?php echo esc_url($extra_image); ?>">
                <div class="row pb-95 epix-row-space">
                    <div class="col-xxl-12">
                        <div class="epix-section-title-3 mb-20">
                            <?php if( !empty($settings['extra_sub_title']) ) : ?>
                            <span class="s-subtitle bdevs-el-subtitle-section"><?php echo bdevs_element_kses_basic($settings['extra_sub_title']); ?></span>
                            <?php endif; ?>
                            <?php if( !empty($settings['extra_title']) ) : ?>
                            <h3 class="s-title bdevs-el-title-section"><?php echo bdevs_element_kses_basic($settings['extra_title']); ?></h3>
                            <?php endif; ?>
                        </div>
                        <?php if( !empty($settings['extra_button_text']) ) : ?>
                        <a href="<?php echo esc_url($settings['extra_button_link']); ?>" class="epix-btn-black-2 bdevs-el-btn"><?php echo bdevs_element_kses_basic($settings['extra_button_text']); ?></a>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-xxl-12">
                        <div class="product-boxed-space bg-white">
                            <div class="product-active swiper-container">
                                <div class="swiper-wrapper">
                                    <?php foreach ($posts as $post): ?>
                                    <div class="epix-single-product-3 style-2 epixx_single_pro text-center swiper-slide">
                                        <div class="epix-product-thumb-3">
                                            <div class="epix-action">
                                                <?php echo \BdevsElement\BDevs_El_Woocommerce::quick_view_button($post->ID); ?>
                                                <?php echo \BdevsElement\BDevs_El_Woocommerce::yith_wishlist($post->ID); ?>
                                                <?php echo \BdevsElement\BDevs_El_Woocommerce::add_to_cart_button($post->ID); ?>
                                            </div>
                                            <?php echo \BdevsElement\BDevs_El_Woocommerce::product_price_sale($post->ID, true); ?>
                                            <a href="<?php echo esc_url(get_the_permalink($post->ID)); ?>">
                                                <?php echo get_the_post_thumbnail($post->ID, 'large', ['class' => 'img-fluid']); ?>
                                            </a>
                                        </div>
                                        <div class="epix-price-box">
                                          <?php echo \BdevsElement\BDevs_El_Woocommerce::product_price($post->ID, true); ?>
                                        </div>
                                        <h5 class="epix-p-title epix-p-title-3 bdevs-el-title">
                                            <?php
                                            $title = $post->post_title;
                                            if ('selected' === $settings['show_post_by'] && array_key_exists($post->ID, $customize_title)) {
                                                $title = $customize_title[$post->ID];
                                            }

                                            printf('<a href="%2$s">%1$s</a>',
                                                esc_html($title),
                                                esc_url(get_the_permalink($post->ID))
                                            );
                                            ?>
                                        </h5>
                                    </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <?php
        else:
            printf('%1$s %2$s %3$s',
                __('No ', 'bdevs-element'),
                esc_html($settings['post_type']),
                __('Found', 'bdevs-element')
            );
        endif;
        ?>


        <?php elseif (!empty($settings['design_style']) and $settings['design_style'] == 'style_6'):
        if( !empty($settings['extra_image']['id']) ) {
            $extra_image = wp_get_attachment_image_url($settings['extra_image']['id'], 'full');
        }
        if (count($posts) !== 0) :
            ?>

        <div class="container">
            <div class="epix-offer-top p-rel">
                <div class="epix-offer-top-wrap">
                    <div class="row align-items-end">
                        <div class="col-xxl-6 col-8">
                            <?php if( !empty($settings['extra_seciton_title']) ) : ?>
                            <div class="epix-section-title-2">
                                <h4 class="s-title bdevs-el-title-section"><?php echo bdevs_element_kses_basic($settings['extra_seciton_title']); ?></h4>
                            </div>
                            <?php endif; ?>
                        </div>
                        <div class="col-xxl-6 col-4">
                            <div class="swiper-pagionation-2 text-end swiper-nav-default bdevs-navigation">
                                <div class="pagination-inner">
                                    <div class="accessories-button-prev-1 bdevs-button-prev"><i class="fal fa-angle-left"></i>
                                    </div>
                                    <div class="accessories-button-next-1 bdevs-button-next"><i class="fal fa-angle-right"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="epix-accessories-content">
                <div class="row g-0">
                    <div class="col-xxl-5 col-lg-9 col-xl-5 accessories-col-1">
                        <div class="timer-product-boxed bg-white">
                            <?php if( !empty($settings['extra_title']) ) : ?>
                            <h4 class="epix-accessories-title bdevs-el-title-section"><?php echo bdevs_element_kses_basic($settings['extra_title']); ?></h4>
                            <?php endif; ?>

                            <div class="timer-product-wrap">
                                <div class="thumb mr-20">
                                    <?php if( !empty($extra_image) ) : ?>
                                    <div class="epix-accessories-thumb mb-25 mt-10">
                                        <img src="<?php echo esc_url($extra_image); ?>" alt="<?php echo esc_html__('product-img', 'bdevs-element'); ?>">
                                    </div>
                                    <?php endif; ?>
                                    <div class="price-box epixx_sp_price_box">
                                        <span class="price">
                                            <?php if( !empty($settings['dell_price']) ) : ?>
                                            <del><?php echo bdevs_element_kses_basic($settings['dell_price']); ?></del> 
                                            <?php endif; ?>
                                            <?php if( !empty($settings['activee_price']) ) : ?>
                                            <span class="active"><?php echo bdevs_element_kses_basic($settings['activee_price']); ?></span>
                                            <?php endif; ?>

                                        </span>
                                        <?php if( !empty($settings['extra_button_text']) ) : ?>
                                        <a href="<?php echo esc_url($settings['extra_button_link']); ?>" class="add_cart_epixx_price bdevs-el-btn"><?php echo bdevs_element_kses_basic($settings['extra_button_text']); ?></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="content bdevs-el-content">
                                    <?php if( !empty($settings['extra_desc']) ) : ?>
                                    <div class="text">
                                        <p><?php echo bdevs_element_kses_basic($settings['extra_desc']); ?></p>
                                    </div>
                                    <?php endif; ?>
                                    <div class="countdown-default" data-countdown=""
                                        data-date="<?php echo esc_attr($settings['sale_date']); ?>">
                                        <ul>
                                            <li><span class="count" data-days=""></span> <span
                                                    class="label"><?php echo esc_html__('Days', 'bdevs-element'); ?></span></li>
                                            <li><span class="count" data-hours=""></span> <span
                                                    class="label"><?php echo esc_html__('Hours', 'bdevs-element'); ?></span></li>
                                            <li><span class="count" data-minutes=""></span> <span
                                                    class="label"><?php echo esc_html__('Mins', 'bdevs-element'); ?></span></li>
                                            <li><span class="count" data-seconds=""></span> <span
                                                    class="label"><?php echo esc_html__('Secs', 'bdevs-element'); ?></span></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <!-- /. timer product -->
                    </div>


                    <div class="col-xxl-7 col-lg-3 col-xl-7 accessories-col-2">
                        <div class="epix-accessories-products pl-10">
                            <div class="accessories-active swiper-container">
                                <div class="swiper-wrapper">

                                    <?php foreach ($posts as $post): ?>
                                    <div class="epix-single-product-3 style-2 epixx_single_pro text-center swiper-slide">
                                        <div class="epix-product-thumb-3 mb-10-i sale_epixx_6 pb-0">
                                            <?php echo \BdevsElement\BDevs_El_Woocommerce::product_price_sale($post->ID, true); ?>

                                            <div class="epix-action epix-action-2">
                                            <?php echo \BdevsElement\BDevs_El_Woocommerce::quick_view_button($post->ID); ?>
                                            <?php echo \BdevsElement\BDevs_El_Woocommerce::yith_wishlist($post->ID); ?>
                                            <?php echo \BdevsElement\BDevs_El_Woocommerce::add_to_cart_button($post->ID); ?>
                                            </div>
                                        <a href="<?php echo esc_url(get_the_permalink($post->ID)); ?>">
                                            <?php echo get_the_post_thumbnail($post->ID, 'large', ['class' => 'img-fluid']); ?>
                                        </a>
                                        </div>

                                        <div class="epix-price-box">
                                          <?php echo \BdevsElement\BDevs_El_Woocommerce::product_price($post->ID, true); ?>
                                        </div>

                                        <h5 class="epix-p-title epix-p-title-3 bdevs-el-title">
                                        <?php
                                        $title = $post->post_title;
                                        if ('selected' === $settings['show_post_by'] && array_key_exists($post->ID, $customize_title)) {
                                            $title = $customize_title[$post->ID];
                                        }

                                        printf('<a href="%2$s">%1$s</a>',
                                            esc_html($title),
                                            esc_url(get_the_permalink($post->ID))
                                        );
                                        ?>
                                        </h5>
                                    </div>
                                    <?php endforeach; ?>

                                </div>
                            </div>
                        </div>
                    </div>


                </div>
            </div>
        </div>

        <?php
        else:
            printf('%1$s %2$s %3$s',
                __('No ', 'bdevs-element'),
                esc_html($settings['post_type']),
                __('Found', 'bdevs-element')
            );
        endif;
        ?>

        <?php elseif (!empty($settings['design_style']) and $settings['design_style'] == 'style_5'):
        if( !empty($settings['extra_image']['id']) ) {
            $extra_image = wp_get_attachment_image_url($settings['extra_image']['id'], 'full');
        }
        if (count($posts) !== 0) :
            ?>

          <div class="container">
            <div class="handpicked-inner pl-30 pr-30 pt-35 bg-white">
              <div class="row mb-35">
                <?php if( !empty($settings['extra_seciton_title']) ) : ?>
                <div class="col-xxl-12">
                  <div class="epix-section-title text-center">
                    <h5 class="s-title bdevs-el-title-section"><?php echo bdevs_element_kses_basic($settings['extra_seciton_title']); ?></h5>
                  </div>
                </div>
                <?php endif; ?>
              </div>
              <div class="row mb-45">
                <div class="col-xxl-12">
                  <div class="epix-handpicked-banner" data-background="<?php echo esc_url($extra_image); ?>">
                    <?php if( !empty($settings['extra_title']) ) : ?>
                    <h4 class="epix-h-banner-text bdevs-el-subtitle-section"><?php echo bdevs_element_kses_basic($settings['extra_title']); ?></h4>
                    <?php endif; ?>
                    <?php if( !empty($settings['extra_button_text']) ) : ?>
                    <a href="<?php echo esc_url($settings['extra_button_link']); ?>" class="epix-white-btn bdevs-el-btn"><span><?php echo bdevs_element_kses_basic($settings['extra_button_text']); ?><i class="fal fa-angle-right"></i></span></a>
                    <?php endif; ?>
                  </div>
                </div>
              </div>
              <div class="row">
                <?php foreach ($posts as $post): ?>
                <div class="col-xxl-4 col-sm-6 col-md-4">
                  <div class="epix-handpicked-product epixx_handpicked_product epixx_single_pro mb-50">
                    <div class="epix-h-pro-thumb mr-35">
                        
                        <?php echo \BdevsElement\BDevs_El_Woocommerce::product_price_sale($post->ID, true); ?>

                      <a href="<?php echo esc_url(get_the_permalink($post->ID)); ?>">
                            <?php echo get_the_post_thumbnail($post->ID, 'large', ['class' => 'img-fluid']); ?>
                      </a>
                    </div>
                    <div class="epix-h-pro-content">
                      <div class="epix-product-content bdevs-el-content pe-0 ps-0 pt-0 pb-0">

                        <h5 class="epix-p-title bdevs-el-title">
                            <?php
                            $title = $post->post_title;
                            if ('selected' === $settings['show_post_by'] && array_key_exists($post->ID, $customize_title)) {
                                $title = $customize_title[$post->ID];
                            }

                            printf('<a href="%2$s">%1$s</a>',
                                esc_html($title),
                                esc_url(get_the_permalink($post->ID))
                            );
                            ?>
                        </h5>

                        <div class="wrap">
                          <?php echo \BdevsElement\BDevs_El_Woocommerce::product_rating($post->ID); ?>
                        </div>

                        <div class="epix-price-box mb-10">
                          <?php echo \BdevsElement\BDevs_El_Woocommerce::product_price($post->ID, true); ?>
                        </div>

                        <div class="epix-horizontal-action epix-product-thumb-3">
                            <div class="epix-action">
                                <?php echo \BdevsElement\BDevs_El_Woocommerce::quick_view_button($post->ID); ?>
                                <?php echo \BdevsElement\BDevs_El_Woocommerce::yith_wishlist($post->ID); ?>
                                <?php echo \BdevsElement\BDevs_El_Woocommerce::add_to_cart_button($post->ID); ?>
                            </div>
                        </div>

                      </div>
                    </div>
                  </div>
                </div>
                <?php endforeach; ?>

              </div>
            </div>
          </div>

        <?php
        else:
            printf('%1$s %2$s %3$s',
                __('No ', 'bdevs-element'),
                esc_html($settings['post_type']),
                __('Found', 'bdevs-element')
            );
        endif;
        ?>

    <?php elseif (!empty($settings['design_style']) and $settings['design_style'] == 'style_4'):
        if (count($posts) !== 0) :
            ?>

            <div class="unmissed-wrapper">
                <div class="product-col-space-wrap">
                  <div class="row g-0">
                    <?php foreach ($posts as $post): ?>
                    <div class="col-xxl-3 col-sm-6 col-md-4 col-lg-4 col-xl-3 wow fadeInUp" data-wow-delay=".2s">
                      <div class="epix-single-product epixx_single_pro">
                        <div class="epix-product-thumb epix-product-thumb-3 pb-0">
                            <a href="<?php echo esc_url(get_the_permalink($post->ID)); ?>">
                                <?php echo get_the_post_thumbnail($post->ID, 'large', ['class' => 'img-fluid']); ?>
                            </a>
                          <div class="epix-action">
                            <?php echo \BdevsElement\BDevs_El_Woocommerce::quick_view_button($post->ID); ?>
                            <?php echo \BdevsElement\BDevs_El_Woocommerce::yith_wishlist($post->ID); ?>
                            <?php echo \BdevsElement\BDevs_El_Woocommerce::add_to_cart_button($post->ID); ?>
                          </div>
                        </div>
                        <div class="epix-product-content bdevs-el-content">
                            <div class="wrap">
                              <?php echo \BdevsElement\BDevs_El_Woocommerce::product_rating($post->ID); ?>
                            </div>

                          <h5 class="epix-p-title bdevs-el-title">
                            <?php
                            $title = $post->post_title;
                            if ('selected' === $settings['show_post_by'] && array_key_exists($post->ID, $customize_title)) {
                                $title = $customize_title[$post->ID];
                            }

                            printf('<a href="%2$s">%1$s</a>',
                                esc_html($title),
                                esc_url(get_the_permalink($post->ID))
                            );
                            ?>
                        </h5>

                        <div class="epix-price-box">
                          <?php echo \BdevsElement\BDevs_El_Woocommerce::product_price($post->ID, true); ?>
                        </div>

                        </div>
                      </div>
                    </div>
                    <?php endforeach; ?>

                  </div>
                </div>
            </div>


        <?php
        else:
            printf('%1$s %2$s %3$s',
                __('No ', 'bdevs-element'),
                esc_html($settings['post_type']),
                __('Found', 'bdevs-element')
            );
        endif;
        ?>
    <?php elseif (!empty($settings['design_style']) and $settings['design_style'] == 'style_3'):
        if (count($posts) !== 0) :
        
        ?>

          <div class="container">
            <div class="deals-product bg-white">
              <div class="row  align-items-center">
                <div class="col-xxl-3 col-xl-3">
                  <div class="deal-product-left">
                    <?php if( !empty($settings['extra_title']) ) : ?>
                    <h3 class="deals-title bdevs-el-title-section"><?php echo bdevs_element_kses_basic($settings['extra_title']); ?></h3>
                    <?php endif; ?>
                    <div class="deals-countdown mb-25">
                      <div class="countdown-inner" data-countdown="" data-date="<?php echo esc_attr($settings['sale_date']); ?>">
                        <ul>
                          <li><span data-days=""></span> <?php echo esc_html__('Days', 'bdevs-element'); ?></li>
                          <li><span data-hours=""></span> <?php echo esc_html__('Hours', 'bdevs-element'); ?></li>
                          <li><span data-minutes=""></span> <?php echo esc_html__('Min', 'bdevs-element'); ?></li>
                          <li><span data-seconds=""></span> <?php echo esc_html__('Sec', 'bdevs-element'); ?></li>
                        </ul>
                      </div>
                    </div>
                    <?php if( !empty($settings['extra_button_text']) ) : ?>
                    <a href="<?php echo esc_url($settings['extra_button_link']); ?>" class="link-details bdevs-el-btn"><?php echo esc_html($settings['extra_button_text']); ?><i class="fal fa-angle-right"></i></a>
                    <?php endif; ?>
                  </div>
                </div>
                <div class="col-xxl-9 col-xl-9">
                  <div class="deal-product-wrap pl-80">
                    <div class="d-product-active-ml-30">
                      <div class="swiper-container d-product-active" data-swipper_autoplay_stop="<?php echo $auto_nav_slide; ?>">
                        <div class="swiper-wrapper">
                          <?php foreach ($posts as $post): ?>
                          <div class="swiper-slide epixx_single_pro" data-swiper-autoplay="<?php $ts_slider_speed; ?>">
                              <div class="epix-product-thumb-2 epix-product-thumb-3 epix-left-top">
                                <?php echo \BdevsElement\BDevs_El_Woocommerce::product_price_sale($post->ID, true); ?>

                                <a href="<?php echo esc_url(get_the_permalink($post->ID)); ?>">
                                    <?php echo get_the_post_thumbnail($post->ID, 'large', ['class' => 'img-fluid']); ?>
                                </a>

                                <div class="epix-action epix-right-0">
                                    <?php echo \BdevsElement\BDevs_El_Woocommerce::quick_view_button($post->ID); ?>
                                    <?php echo \BdevsElement\BDevs_El_Woocommerce::yith_wishlist($post->ID); ?>
                                    <?php echo \BdevsElement\BDevs_El_Woocommerce::add_to_cart_button($post->ID); ?>
                                </div>
                              </div>
                              <div class="epixx-product-content bdevs-el-content">

                                <div class="wrap">
                                  <?php echo \BdevsElement\BDevs_El_Woocommerce::product_rating($post->ID); ?>
                                </div>

                                <h5 class="epix-p-title bdevs-el-title mb-0">
                                    <?php
                                    $title = $post->post_title;
                                    if ('selected' === $settings['show_post_by'] && array_key_exists($post->ID, $customize_title)) {
                                        $title = $customize_title[$post->ID];
                                    }

                                    printf('<a href="%2$s">%1$s</a>',
                                        esc_html($title),
                                        esc_url(get_the_permalink($post->ID))
                                    );
                                    ?>
                                </h5>

                                <div class="epix-price-box">
                                  <?php echo \BdevsElement\BDevs_El_Woocommerce::product_price($post->ID, true); ?>
                                </div>

                            </div>
                          </div>
                          <?php endforeach; ?>
                        </div>

                        <?php if(!empty($show_navigation)) : ?>
                        <div class="epixx-navigation bdevs-navigation">
                            <div class="epixx-slider-next bdevs-button-next"><i class="fal fa-angle-right"></i></div>
                            <div class="epixx-slider-prev bdevs-button-prev"><i class="fal fa-angle-left"></i></div>
                        </div>
                        <?php endif; ?>

                      </div>
                    </div>
                  </div>
                  <!-- /. deals product wrap -->
                </div>
              </div>
            </div>
          </div>
        <?php
        else:
            printf('%1$s %2$s %3$s',
                __('No ', 'bdevs-element'),
                esc_html($settings['post_type']),
                __('Found', 'bdevs-element')
            );
        endif;
        ?>

    <?php elseif (!empty($settings['design_style']) and $settings['design_style'] == 'style_2') : 
        if( !empty($settings['extra_image']['id']) ) {
            $extra_image = wp_get_attachment_image_url( $settings['extra_image']['id'], 'full' );
        }
        ?>
        <?php if (count($posts) !== 0) : ?>

            <section class="new-arrival">
              <div class="container">
                <?php if( !empty($settings['extra_seciton_title']) ) : ?>
                <div class="row mb-45">
                  <div class="col-xxl-12">
                    <div class="epix-section-title text-center">
                      <h5 class="s-title bdevs-el-title-section"><?php echo bdevs_element_kses_basic($settings['extra_seciton_title']); ?></h5>
                    </div>
                  </div>
                </div>
                <?php endif; ?>

                <div class="row">
                  <div class="col-xxl-5 col-xl-5 arrival-col-1">
                    <div class="banner-3 wow fadeInUp" data-wow-delay=".2s">
                      <div class="thumb">
                        <img src="<?php echo esc_url($extra_image); ?>" class="w-100" alt="img">
                      </div>
                      <div class="content">
                        <?php if( !empty($settings['extra_sub_title']) ) : ?>
                        <span class="shipping text-uppercase bdevs-el-subtitle-section"><?php echo bdevs_element_kses_basic($settings['extra_sub_title']); ?></span>
                        <?php endif; ?>
                        <?php if( !empty($settings['extra_title']) ) : ?>
                        <h3 class="bdevs-el-title-section"><?php echo bdevs_element_kses_basic($settings['extra_title']); ?></h3>
                        <?php endif; ?>
                        <?php if( !empty($settings['extra_button_text']) ) : ?>
                        <a href="<?php echo esc_url($settings['extra_button_link']); ?>" class="epix-btn-2 bdevs-el-btn"><span><?php echo bdevs_element_kses_basic($settings['extra_button_text']); ?><i class="fal fa-angle-right"></i></span></a>
                        <?php endif; ?>
                      </div>
                    </div>
                  </div>
                  <div class="col-xxl-7 col-xl-7 product-col-space arrival-col-2">
                    <div class="row g-0">
                    <?php foreach ($posts as $post): ?>
                      <div class="col-xxl-4 col-sm-6 col-md-4 col-lg-4">
                        <div class="epix-single-product epix_height_200 epixx_single_pro wow fadeInUp" data-wow-delay=".2s">
                          <div class="epix-product-thumb epix-product-thumb-3 mb-0 pb-0">
                            <a href="<?php echo esc_url(get_the_permalink($post->ID)); ?>">
                                <?php echo get_the_post_thumbnail($post->ID, 'large', ['class' => 'img-fluid']); ?>
                            </a>
                            <div class="epix-action">
                                <?php echo \BdevsElement\BDevs_El_Woocommerce::quick_view_button($post->ID); ?>
                                <?php echo \BdevsElement\BDevs_El_Woocommerce::yith_wishlist($post->ID); ?>
                                <?php echo \BdevsElement\BDevs_El_Woocommerce::add_to_cart_button($post->ID); ?>
                            </div>
                          </div>
                          <div class="epix-product-content bdevs-el-content">
                            <div class="wrap">
                              <?php echo \BdevsElement\BDevs_El_Woocommerce::product_rating($post->ID); ?>
                            </div>
                            <h5 class="epix-p-title bdevs-el-title mb-0">
                                <?php
                                $title = $post->post_title;
                                if ('selected' === $settings['show_post_by'] && array_key_exists($post->ID, $customize_title)) {
                                    $title = $customize_title[$post->ID];
                                }

                                printf('<a href="%2$s">%1$s</a>',
                                    esc_html($title),
                                    esc_url(get_the_permalink($post->ID))
                                );
                                ?>
                            </h5>
                            <div class="epix-price-box">
                              <?php echo \BdevsElement\BDevs_El_Woocommerce::product_price($post->ID, true); ?>
                            </div>
                          </div>
                        </div>
                      </div>
                    <?php endforeach; ?>

                    </div>
                  </div>
                </div>
              </div>
            </section>
        <?php
        else:
            printf('%1$s %2$s %3$s',
                __('No ', 'bdevs-element'),
                esc_html($settings['post_type']),
                __('Found', 'bdevs-element')
            );
        endif;
        ?>
    <?php else: ?>
        <?php if (count($posts) !== 0) : ?>



        <div class="epix-offer-right pl-35">
            <div class="epix-offer-top">
                <div class="epix-offer-top-wrap">
                    <div class="row align-items-end">
                        <div class="col-xxl-6 col-8 c">
                            <?php if( !empty($settings['extra_seciton_title']) ) : ?>
                            <div class="epix-section-title-2">
                                <h4 class="s-title bdevs-el-title-section"><?php echo bdevs_element_kses_basic($settings['extra_seciton_title']); ?></h4>
                            </div>
                            <?php endif; ?>
                        </div>
                        <div class="col-xxl-6 col-4">
                            <div class="swiper-pagionation-2 text-end swiper-nav-default bdevs-navigation">
                                <div class="pagination-inner">
                                    <div class="swiper-button-prev2 bdevs-button-prev"><i class="fal fa-angle-left"></i>
                                    </div>
                                    <div class="swiper-button-next2 bdevs-button-next"><i class="fal fa-angle-right"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php  
            $news_array = array();               
            foreach($posts as $qKey => $news) {
                    $categories = get_the_category($news->ID);
                    array_push($news_array, $news);
                } 
                wp_reset_postdata();
                $news_count = count($news_array);
            ?>
            <div class="epix-offer-bottom">
                <div class="featured-active swiper-container" data-swipper_autoplay_stop="<?php echo $auto_nav_slide; ?>">
                    <div class="swiper-wrapper">
                        <?php 
                        for ( $i=0; $i < $news_count; $i+=6 ):
                        $news = $news_array[$i]; 
                        ?>
                        <div class="swiper-slide" data-swiper-autoplay="<?php $ts_slider_speed; ?>">
                            <div class="row">
                               <?php 
                               for ($k=$i+0; $k <= $i+5; $k++): 
                               $news = $news_array[$k]; ?>
                                <div class="col-xxl-6 col-md-6 col-sm-6">
                                    <div class="epix-single-product-3 mb-20">
                                        <div class="product-list-style epix_list">
                                            <div class="epix-product-thumb-3">
                                            <a href="<?php echo esc_url(get_the_permalink($news->ID)); ?>">
                                                <?php echo get_the_post_thumbnail($news->ID, 'large', ['class' => 'img-fluid']); ?>
                                            </a>
                                            </div>
                                            <div class="content bdevs-el-content">
                                                <div class="price-box epixx_sp_price_box">
                                                    <?php echo \BdevsElement\BDevs_El_Woocommerce::product_price($news->ID, true); ?>
                                                    <?php echo \BdevsElement\BDevs_El_Woocommerce::add_to_cart_button_text($news->ID, true); ?>
                                                    
                                                </div>
                                                <h5 class="epix-p-title epix-p-title-3 bdevs-el-title">
                                                    <?php
                                                    $title = $news->post_title;
                                                    if ('selected' === $settings['show_post_by'] && array_key_exists($news->ID, $customize_title)) {
                                                        $title = $customize_title[$news->ID];
                                                    }

                                                    printf('<a href="%2$s">%1$s</a>',
                                                        esc_html($title),
                                                        esc_url(get_the_permalink($news->ID))
                                                    );
                                                    ?>
                                                </h5>
                                                <span class="epix-p-subtitle epix-p-subtitle-2 bdevs-el-subtitle"><?php echo esc_html($news->post_date); ?></span>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php 
                                endfor; ?>
                            </div>
                        </div>
                        <?php 
                        endfor; ?>
                    </div>
                </div>
            </div>
        </div>

        <?php
        else:
            printf('%1$s %2$s %3$s',
                __('No ', 'bdevs-element'),
                esc_html($settings['post_type']),
                __('Found', 'bdevs-element')
            );
        endif;
        ?>
    <?php endif;
    }
}
