<?php 
/** 
 * The main template file
 *
 * @package  WordPress
 * @subpackage  medidove
 */
get_header(); ?>

      <section class="page__title-area pt-120">
         <div class="page__title-shape">
            <img class="page-title-shape-5 d-none d-sm-block" src="<?php print get_template_directory_uri(); ?>/assets/img/page-title/page-title-shape-1.png" alt="img">
            <img class="page-title-shape-6" src="<?php print get_template_directory_uri(); ?>/assets/img/page-title/page-title-shape-2.png" alt="img">
            <img class="page-title-shape-7" src="<?php print get_template_directory_uri(); ?>/assets/img/page-title/page-title-shape-4.png" alt="img">
            <img class="page-title-shape-8" src="<?php print get_template_directory_uri(); ?>/assets/img/page-title/page-title-shape-5.png" alt="img">
         </div>
         <div class="container">
            <?php 
            if( have_posts() ):
                while( have_posts() ): the_post();
                    $categories = get_the_terms( get_the_id(), 'event-categories' );
                    $event_details_thumb = function_exists('get_field') ? get_field('event_details_thumb') : ''; 

            ?>
            <div class="row">
               <div class="col-xxl-9 col-xl-8">
                  <div class="page__title-content mb-25 pr-40">
                     
                    <?php foreach ( $categories as $category ) : ?>
                        <span class="page__title-pre purple-bg">
                            <a class="news-tag" href="<?php echo esc_url( get_category_link( $category->term_id)); ?>"><?php echo esc_html($category->name); ?>
                            </a>
                        </span>    
                    <?php endforeach; ?>
                     
                     <h5 class="page__title-3"><?php the_title(); ?></h5>
                  </div>
                  <div class="course__meta-2 d-sm-flex mb-30">
                     <div class="course__teacher-3 d-flex align-items-center mr-70 mb-30">
                        <div class="course__teacher-thumb-3 mr-15">
                           <?php echo get_avatar(get_the_author_meta('ID'), 45) ?>
                        </div>
                        <div class="course__teacher-info-3">
                           <h5>Teacher</h5>
                           <p><a href="<?php print esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) )?>"><?php echo get_the_author_meta('display_name', get_the_author_meta('ID')); ?></a></p>
                        </div>
                     </div>
                     <div class="course__update mr-80 mb-30">
                        <h5>Last Update:</h5>
                        <p>July 24, 2022</p>
                     </div>
                     <div class="course__update mb-30">
                        <h5>Location:</h5>
                        <p>New York, TX 82760, US:</p>
                     </div>
                  </div>
               </div>
            </div>
            <?php 
                endwhile; wp_reset_query();
            endif; 
            ?>
         </div>
      </section>

      <section class="event__area pb-110">
         <div class="container">
            <?php
            global $post ;
            if( have_posts() ):
                while( have_posts() ): the_post();
                    $post_tags = get_the_terms( get_the_id(), 'event-tags' );
                    $department_details_thumb = function_exists('get_field') ? get_field('department_details_thumb') : '';
                    $department_sub_title = function_exists('get_field') ? get_field('department_sub_title') : '';
                    $department_title = function_exists('get_field') ? get_field('department_title') : '';

                    // video
                    $department_video_image = function_exists('get_field') ? get_field('department_video_image') : '';
                    $department_video_url = function_exists('get_field') ? get_field('department_video_url') : '';

                    // department short info
                    $department_bottom_text = function_exists('get_field') ? get_field('department_bottom_text') : '';  

            ?>
            <div class="row">
               <div class="col-xxl-8 col-xl-8 col-lg-8">
                  <div class="events__wrapper">
                     <div class="events__thumb mb-35 w-img">
                        <img src="<?php echo get_the_post_thumbnail_url(); ?>" alt="img">
                     </div>
                     <div class="events__details mb-35">
                        <?php the_content(); ?>
                     </div>

                     <?php if(!empty($post_tags)) : ?>
                     <div class="events__tag">
                        <span><i class="fal fa-tag"></i></span>
                        <?php foreach ( $post_tags as $tag ) : ?>
                           <a href="<?php echo esc_url(get_tag_link($tag->term_id)); ?>">
                                <?php echo $tag->name; ?><span>,</span>
                            </a> 
                        <?php endforeach; ?>    
                     </div>
                    <?php endif; ?>
                  </div>
               </div>
               <div class="col-xxl-4 col-xl-4 col-lg-4">
                  <div class="events__sidebar pl-70">
                     <div class="events__sidebar-widget white-bg mb-20">
                        <div class="events__sidebar-shape">
                           <img class="events-sidebar-img-2" src="<?php print get_template_directory_uri(); ?>/assets/img/events/event-shape-2.png" alt="img">
                           <img class="events-sidebar-img-3" src="<?php print get_template_directory_uri(); ?>/assets/img/events/event-shape-3.png" alt="img">
                        </div>
                        <div class="events__info">
                           <div class="events__info-meta mb-25 d-flex align-items-center justify-content-between">
                              <div class="events__info-price">
                                 <h5>$76.<span>00</span> </h5>
                                 <h5 class="old-price">$142.00</h5>
                              </div>
                              <div class="events__info-discount">
                                 <span>68% OFF</span>
                              </div>
                           </div>
                           <div class="events__info-content mb-35">
                              <ul>
                                 <li class="d-flex align-items-center">
                                    <div class="events__info-icon">
                                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 16 16" style="enable-background:new 0 0 16 16;" xml:space="preserve">
                                          <path class="st0" d="M2,6l6-4.7L14,6v7.3c0,0.7-0.6,1.3-1.3,1.3H3.3c-0.7,0-1.3-0.6-1.3-1.3V6z"/>
                                          <polyline class="st0" points="6,14.7 6,8 10,8 10,14.7 "/>
                                       </svg>
                                    </div>
                                    <div class="events__info-item">
                                       <h5><span>End: </span> July 26, 2022 12:30 am</h5>
                                    </div>
                                 </li>
                                 <li class="d-flex align-items-center">
                                    <div class="events__info-icon">
                                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 16 16" style="enable-background:new 0 0 16 16;" xml:space="preserve">
                                          <path class="st0" d="M2,6l6-4.7L14,6v7.3c0,0.7-0.6,1.3-1.3,1.3H3.3c-0.7,0-1.3-0.6-1.3-1.3V6z"/>
                                          <polyline class="st0" points="6,14.7 6,8 10,8 10,14.7 "/>
                                       </svg>
                                    </div>
                                    <div class="events__info-item">
                                       <h5><span>Time:</span>  10:45 AM-01:30 PM</h5>
                                    </div>
                                 </li>
                                 <li class="d-flex align-items-center">
                                    <div class="events__info-icon">
                                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 16 16" style="enable-background:new 0 0 16 16;" xml:space="preserve">
                                          <path class="st0" d="M2,6l6-4.7L14,6v7.3c0,0.7-0.6,1.3-1.3,1.3H3.3c-0.7,0-1.3-0.6-1.3-1.3V6z"/>
                                          <polyline class="st0" points="6,14.7 6,8 10,8 10,14.7 "/>
                                       </svg>
                                    </div>
                                    <div class="events__info-item">
                                       <h5><span>Venue: </span> New York, TX 82760, US</h5>
                                    </div>
                                 </li>
                              </ul>
                           </div>
                           <div class="events__join-btn">
                              <a href="https://www.devsnews.com/wp/educal/contact/" class="e-btn e-btn-7 w-100">Enroll <i class="far fa-arrow-right"></i></a>
                           </div>
                        </div>
                     </div>
                     <div class="events__sidebar-widget white-bg">
                        <div class="events__sponsor">
                           <h3 class="events__sponsor-title">Sponsors</h3>
                           <div class="events__sponsor-thumb mb-35">
                              <img src="<?php print get_template_directory_uri(); ?>/assets/img/events/sponsor-logo.png" alt="img">
                           </div>
                           <div class="events__sponsor-info">
                              <h3>Thomas R. Toe</h3>
                              <h4>Email: <span>support@educal.com</span></h4>
                              <div class="events__social d-xl-flex align-items-center">
                                 <h4>Share:</h4>
                                 <ul>
                                    <li><a href="#" class="fb" ><i class="social_facebook"></i></a></li>
                                    <li><a href="#" class="tw" ><i class="social_twitter"></i></a></li>
                                    <li><a href="#" class="pin" ><i class="social_pinterest"></i></a></li>
                                 </ul>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <?php 
                endwhile; wp_reset_query();
            endif; 
            ?>
         </div>
      </section>



<?php get_footer();  ?>