<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package epixx
 */

get_header();
?>

<section class="error__area pt-60 pb-100">
   <div class="container">
      <div class="row">
         <div class="col-xl-8 offset-xl-2 col-lg-8 offset-lg-2">

            <?php 
               $epixx_error_404_text = get_theme_mod('epixx_error_404_text', __('404', 'epixx'));
               $epixx_error_title = get_theme_mod('epixx_error_title', __('Page not found', 'epixx'));
               $epixx_error_link_text = get_theme_mod('epixx_error_link_text', __('Back To Home', 'epixx'));
               $epixx_error_desc = get_theme_mod('epixx_error_desc', __('Oops! The page you are looking for does not exist. It might have been moved or deleted.', 'epixx'));
            ?>

           <div class="error__content text-center">
               <div class="error__number">
                   <h1><?php print esc_html($epixx_error_404_text); ?></h1>
               </div>
               <span><?php print esc_html($epixx_error_title); ?></span>
               <h2><?php print esc_html__('Nothing To See Here!', 'epixx'); ?></h2>
               <p><?php print esc_html($epixx_error_desc); ?></p>

               <div class="epixx_error_search mb-50">
                   <?php print get_search_form(); ?>
               </div>
               <div class="error_button">
                  <a href="<?php print esc_url(home_url('/'));?>" class="e_button"><?php print esc_html($epixx_error_link_text);?></a>
               </div>
           </div>

         </div>
      </div>
   </div>
</section>

<?php
get_footer();
