(function ($) {
  ("use strict");
  ////////////////////////////////////////////////////
  // 01. PreLoader Js
  $(window).on('load', function () {
    $("#loading").fadeOut(500);
  });

  // Activate rtl slider
  let rtl_setting = $('body').hasClass("rtl") ? true : false;

  // meanmenu
  $("#mobile-menu").meanmenu({
    meanMenuContainer: ".mobile-menu",
    meanScreenWidth: "991",
  });

    // cart-plus-minus
    $(".cart-plus-minus").append('<div class="qtybutton minus">-</div><div class="qtybutton plus">+</div>');

    $(".cart-plus-minus").on("click", ".qtybutton.plus, .qtybutton.minus", function () {
        // Get current quantity values
        var qty = $(this).closest(".cart-plus-minus").find(".qty");
        console.log( qty.val() );
        var val = parseFloat(qty.val());
        var max = parseFloat(qty.attr("max"));
        var min = parseFloat(qty.attr("min"));
        var step = parseFloat(qty.attr("step"));

        // Change the value if plus or minus
        if ($(this).is(".plus")) {
            if (max && max <= val) {
                qty.val(max);
            }
            else {
                qty.val(val + step).trigger("change");
            }
        }
        else {
            if (min && min >= val) {
                qty.val(min);
            }
            else if (val > 0) {
                qty.val(val - step).trigger("change");
            }
        }
    });

    // menu-last class
    $('.header-nav nav > ul > li').slice(-4).addClass('menu-last');

  // window scroll
  $(window).on("scroll", function () {
    var scroll = $(window).scrollTop();
    if (scroll < 245) {
      $(".header-sticky").removeClass("sticky");
      $('.scroll-to-target').removeClass('open');
    } else {
      $(".header-sticky").addClass("sticky");
      $('.scroll-to-target').addClass('open');
    }
  });


/*=============================================
  =        Scroll Up             =
=============================================*/
if ($('.scroll-to-target').length) {
  $(".scroll-to-target").on('click', function () {
    var target = $(this).attr('data-target');
    // animate
    $('html, body').animate({
      scrollTop: $(target).offset().top
    }, 1000);

  });
}



  // nice select
  $(".sidebar-blog select, .blog__details-wrapper select, .blog__wrapper select, .footer-widget select, .sort-wrapper select, .variations select").niceSelect();

  // mainSlider
  function mainSlider() {

    // Data-background
    $("[data-background]").each(function () {
      $(this).css(
        "background-image",
        "url(" + $(this).attr("data-background") + ")"
      );
    });

    var BasicSlider = $(".slider-active");
    BasicSlider.on("init", function (e, slick) {
      var $firstAnimatingElements = $(".single-slider:first-child").find(
        "[data-animation]"
      );
      doAnimations($firstAnimatingElements);
    });
    BasicSlider.on(
      "beforeChange",
      function (e, slick, currentSlide, nextSlide) {
        var $animatingElements = $(
          '.single-slider[data-slick-index="' + nextSlide + '"]'
        ).find("[data-animation]");
        doAnimations($animatingElements);
      }
    );
    BasicSlider.slick({
      autoplay: false,
      autoplaySpeed: 10000,
      dots: false,
      fade: true,
      arrows: false,
      rtl: rtl_setting,
      responsive: [
        { breakpoint: 767, settings: { dots: false, arrows: false } },
      ],
    });

    function doAnimations(elements) {
      var animationEndEvents =
        "webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend";
      elements.each(function () {
        var $this = $(this);
        var $animationDelay = $this.data("delay");
        var $animationType = "animated " + $this.data("animation");
        $this.css({
          "animation-delay": $animationDelay,
          "-webkit-animation-delay": $animationDelay,
        });
        $this.addClass($animationType).one(animationEndEvents, function () {
          $this.removeClass($animationType);
        });
      });
    }


/*------------------------------------
        Slider
  --------------------------------------*/


    if (jQuery(".slider-active-2").length > 0) {
      let sliderActive1 = ".slider-active-2";
      let sliderInit1 = new Swiper(sliderActive1, {
        // Optional parameters
        slidesPerView: 1,
        slidesPerColumn: 1,
        rtl: rtl_setting,
        paginationClickable: true,
        loop: true,
        effect: "fade",

        autoplay: {
          delay: 5000,
        },

        // If we need pagination
        pagination: {
          el: ".epixx-pagination",
          clickable: true,
        },

        // Navigation arrows
        navigation: {
          nextEl: ".swiper-button-next",
          prevEl: ".swiper-button-prev",
        },

        a11y: false,
      });

      function animated_swiper(selector, init) {
        let animated = function animated() {
          $(selector + " [data-animation]").each(function () {
            let anim = $(this).data("animation");
            let delay = $(this).data("delay");
            let duration = $(this).data("duration");

            $(this)
              .removeClass("anim" + anim)
              .addClass(anim + " animated")
              .css({
                webkitAnimationDelay: delay,
                animationDelay: delay,
                webkitAnimationDuration: duration,
                animationDuration: duration,
              })
              .one(
                "webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend",
                function () {
                  $(this).removeClass(anim + " animated");
                }
              );
          });
        };
        animated();
        // Make animated when slide change
        init.on("slideChange", function () {
          $(sliderActive1 + " [data-animation]").removeClass("animated");
        });
        init.on("slideChange", animated);
      }

      animated_swiper(sliderActive1, sliderInit1);

      if(jQuery(".slider-active-2").data('swipper_autoplay_stop') == '') {
        sliderInit1.autoplay.stop();
      }

    }
}



  /* magnificPopup img view */
  $(".popup-image").magnificPopup({
    type: "image",
    gallery: {
      enabled: true,
    },
  });

  /* magnificPopup video view */
  $(".popup-video").magnificPopup({
    type: "iframe",
  });

  // Data-background
  $("[data-background]").each(function () {
    $(this).css(
      "background-image",
      "url(" + $(this).attr("data-background") + ")"
    );
  });

  $("[data-width]").each(function () {
    $(this).css("width", $(this).attr("data-width"));
  });

  $("[data-bg-color]").each(function () {
    $(this).css("background-color", $(this).attr("data-bg-color"));
  });

  $("[data-top-space]").each(function () {
    $(this).css("padding-top", $(this).attr("data-top-space"));
  });



  // isotop

  // isotop activation
  $(".portfolio_area").imagesLoaded(function () {
    // init Isotope
    var $grid = $(".portfolio_items").isotope({
      itemSelector: ".portfolio_item",
      percentPosition: true,
      masonry: {
        // use outer width of grid-sizer for columnWidth
        columnWidth: 1,
      },
    });

    // filter items on button click
    $(".portfolio_nav").on("click", "button", function () {
      var filterValue = $(this).attr("data-filter");
      $grid.isotope({ filter: filterValue });
    });
  });

  //for menu active class
  $(".portfolio_nav button").on("click", function (event) {
    $(this).siblings(".active").removeClass("active");
    $(this).addClass("active");
    event.preventDefault();
  });

  // scrollToTop
  $.scrollUp({
    scrollName: "scrollUp", // Element ID
    topDistance: "300", // Distance from top before showing element (px)
    topSpeed: 300, // Speed back to top (ms)
    animation: "fade", // Fade, slide, none
    animationInSpeed: 200, // Animation in speed (ms)
    animationOutSpeed: 200, // Animation out speed (ms)
    scrollText: '<i class="icofont icofont-long-arrow-up"></i>', // Text for element
    activeOverlay: false, // Set CSS color to display scrollUp active point, e.g '#00FFFF'
  });

  // WOW active
  new WOW().init();

  //Adding class on visibility

  $.fn.visible = function (partial) {
    var $t = $(this),
      $w = $(window),
      viewTop = $w.scrollTop(),
      viewBottom = viewTop + $w.height(),
      _top = $t.offset().top,
      _bottom = _top + $t.height(),
      compareTop = partial === true ? _bottom : _top,
      compareBottom = partial === true ? _top : _bottom;

    return compareBottom <= viewBottom && compareTop >= viewTop;
  };

  $.fn.visible = function (partial) {
    var $t = $(this),
      $w = $(window),
      viewTop = $w.scrollTop(),
      viewBottom = viewTop + $w.height(),
      _top = $t.offset().top,
      _bottom = _top + $t.height(),
      compareTop = partial === true ? _bottom : _top,
      compareBottom = partial === true ? _top : _bottom;

    return compareBottom <= viewBottom && compareTop >= viewTop;
  };

  $(window).on("scroll", function (event) {
    $(".scale-img-animation-left").each(function (i, el) {
      var el = $(el);
      if (el.visible(true)) {
        el.addClass("img-animation-left");
      } else {
        el.removeClass("img-animation-left");
      }
    });
    $(".scale-img-animation-right").each(function (i, el) {
      var el = $(el);
      if (el.visible(true)) {
        el.addClass("img-animation-right");
      } else {
        el.removeClass("img-animation-right");
      }
    });

    $(".top_right_visible").each(function (i, el) {
      var el = $(el);
      if (el.visible(true)) {
        el.addClass("top_right_visible_animation");
      } else {
        el.removeClass("top_right_visible_animation");
      }
    });

    $(".width_visible").each(function (i, el) {
      var el = $(el);
      if (el.visible(true)) {
        el.addClass("width_visible_animation");
      } else {
        el.removeClass("width_visible_animation");
      }
    });
  });

  // Post Gallery 
    const post_gallery = new Swiper(".post_gallery", {
      navigation: {
        nextEl: ".post_gallery_next",
        prevEl: ".post_gallery_prev",
      },
    });

  //testmonial-slider widget carousel
  function testimonial_active() {
    const testimoinal_active = new Swiper(".testimonial-active", {
      // Optional parameters
      slidesPerView: 1,
      spaceBetween: 30,
      rtl: rtl_setting,
      loop: true,
      autoplay: {
          delay: 5000,
        },

      // If we need pagination
      pagination: {
        el: ".swiper-pagination-product",
      },

      // Navigation arrows
      navigation: {
        nextEl: ".swiper-button-next-product",
        prevEl: ".swiper-button-prev-product",
      },

      // And if we need scrollbar
      scrollbar: {
        el: ".swiper-scrollbar",
      }
    });
  }
  //brand widget carousel
  function brand_active() {
    const swiper2 = new Swiper(".brand-active", {
      // Optional parameters
      slidesPerView: 5,
      rtl: rtl_setting,
      spaceBetween: 0,
      loop: true,
      autoplay: {
          delay: 5000,
        },

      // If we need pagination
      pagination: {
        el: ".swiper-pagination",
      },

      // Navigation arrows
      navigation: {
        nextEl: ".swiper-button-next",
        prevEl: ".swiper-button-prev",
      },

      // And if we need scrollbar
      scrollbar: {
        el: ".swiper-scrollbar",
      },
      breakpoints: {
        0: {
          slidesPerView: 2,
          spaceBetween: 0,
        },
        576: {
          slidesPerView: 3,
          spaceBetween: 0,
        },
        768: {
          slidesPerView: 3,
        },
        1200: {
          slidesPerView: 4,
        },
        1400: {
          slidesPerView: 5,
        },
      },
    });
  }
  //feature-list widget carousel
  function offer_active_2() {
    const offer2 = new Swiper(".offer-active-2", {
      // Optional parameters
      slidesPerView: 2,
      rtl: rtl_setting,
      spaceBetween: 30,
      loop: true,
      autoplay: {
          delay: 5000,
        },

      // If we need pagination
      pagination: {
        el: ".swiper-pagination",
      },

      // Navigation arrows
      navigation: {
        nextEl: ".swiper-button-next-1",
        prevEl: ".swiper-button-prev-1",
      },

      // And if we need scrollbar
      scrollbar: {
        el: ".swiper-scrollbar",
      },
      breakpoints: {
        0: {
          slidesPerView: 1,
        },
        576: {
          slidesPerView: 2,
        },
        768: {
          slidesPerView: 2,
        },
      },
    });
  }


  //woo-product widget carousel
  if(jQuery(".featured-active").data('swipper_autoplay_stop') == '') {
      featured.autoplay.stop();
  }
    
  function featured_active() {
      const featured = new Swiper(".featured-active", {
      // Optional parameters
      slidesPerView: 1,
      rtl: rtl_setting,
      spaceBetween: 0,
      loop: true,
      autoplay: {
          delay: 5000,
        },

      // If we need pagination
      pagination: {
        el: ".swiper-pagination",
      },

      // Navigation arrows
      navigation: {
        nextEl: ".swiper-button-prev2",
        prevEl: ".swiper-button-next2",
      },

      // And if we need scrollbar
      scrollbar: {
        el: ".swiper-scrollbar",
      },
    });

    const accessories = new Swiper(".accessories-active", {
      // Optional parameters
      slidesPerView: 3,
      spaceBetween: 10,
      rtl: rtl_setting,
      loop: true,
      navigation: true,
      autoplay: {
          delay: 5000,
        },

      // If we need pagination
      pagination: {
        el: ".swiper-pagination-category",
      },

      // Navigation arrows
      navigation: {
        nextEl: ".accessories-button-next-1",
        prevEl: ".accessories-button-prev-1",
      },
      observer: true,
      observeParents: true,

      // And if we need scrollbar
      scrollbar: {
        el: ".swiper-scrollbar",
      },
      breakpoints: {
        0: {
          slidesPerView: 1,
          spaceBetween: 0,
        },
        576: {
          slidesPerView: 3,
          spaceBetween: 0,
        },
        768: {
          slidesPerView: 3,
          spaceBetween: 10,
        },
        992: {
          slidesPerView: 1,
        },
        1200: {
          slidesPerView: 3,
        },
        1400: {
          slidesPerView: 3,
        },
      },
    });

    const product = new Swiper(".product-active", {
      // Optional parameters
      slidesPerView: 5,
      rtl: rtl_setting,
      spaceBetween: 30,
      loop: true,
      autoplay: {
          delay: 5000,
        },

      // If we need pagination
      pagination: {
        el: ".swiper-pagination-product",
      },

      // Navigation arrows
      navigation: {
        nextEl: ".swiper-button-next-product",
        prevEl: ".swiper-button-prev-product",
      },

      // And if we need scrollbar
      scrollbar: {
        el: ".swiper-scrollbar",
      },
      breakpoints: {
        0: {
          slidesPerView: 1,
          spaceBetween: 0,
        },
        576: {
          slidesPerView: 2,
          spaceBetween: 0,
        },
        768: {
          slidesPerView: 3,
        },
        1200: {
          slidesPerView: 4,
        },
        1400: {
          slidesPerView: 5,
        },
      },
    });



    if(jQuery(".d-product-active").data('swipper_autoplay_stop') == '') {
        swiper.autoplay.stop();
    }

    const swiper = new Swiper(".d-product-active", {
      // Optional parameters
      slidesPerView: 4,
      rtl: rtl_setting,
      spaceBetween: 30,
      loop: true,
      autoplay: {
          delay: 5000,
        },

      // If we need pagination
      pagination: {
        el: ".epixx-product-pagination",
      },

      // Navigation arrows
      navigation: {
        nextEl: ".epixx-slider-next",
        prevEl: ".epixx-slider-prev",
      },

      // And if we need scrollbar
      scrollbar: {
        el: ".swiper-scrollbar",
      },
      breakpoints: {
        0: {
          slidesPerView: 1,
          spaceBetween: 0,
        },
        576: {
          slidesPerView: 2,
          spaceBetween: 0,
        },
        768: {
          slidesPerView: 3,
        },
        1200: {
          slidesPerView: 3,
        },
        1400: {
          slidesPerView: 4,
        },
      },
    });
  }
  //woo-product-tab widget carousel
  function trending_active() {
    const trending_tab = new Swiper(".trending-active", {
      // Optional parameters
      slidesPerView: 4,
      rtl: rtl_setting,
      spaceBetween: 0,
      loop: true,
      navigation: true,
      autoplay: {
          delay: 5000,
        },

      // If we need pagination
      pagination: {
        el: ".swiper-pagination-category",
      },

      // Navigation arrows
      navigation: {
        nextEl: ".accessories-button-next-1",
        prevEl: ".accessories-button-prev-1",
      },
      observer: true,
      observeParents: true,

      // And if we need scrollbar
      scrollbar: {
        el: ".swiper-scrollbar",
      },
      breakpoints: {
        0: {
          slidesPerView: 1,
          spaceBetween: 0,
        },
        576: {
          slidesPerView: 2,
          spaceBetween: 30,
        },
        768: {
          slidesPerView: 3,
          spaceBetween: 10,
        },
        992: {
          slidesPerView: 3,
          spaceBetween: 30,
        },
        1200: {
          slidesPerView: 3,
          spaceBetween: 30,
        },
        1400: {
          slidesPerView: 4,
          spaceBetween: 30,
        },
      },
    });

    const product_tab = new Swiper(".tab-product-active", {
      // Optional parameters
      slidesPerView: 5,
      rtl: rtl_setting,
      spaceBetween: 0,
      loop: true,
      navigation: true,
      autoplay: {
          delay: 5000,
        },

      // If we need pagination
      pagination: {
        el: ".swiper-pagination-category",
      },

      // Navigation arrows
      navigation: {
        nextEl: ".accessories-button-next-1",
        prevEl: ".accessories-button-prev-1",
      },
      observer: true,
      observeParents: true,

      // And if we need scrollbar
      scrollbar: {
        el: ".swiper-scrollbar",
      },
      breakpoints: {
        0: {
          slidesPerView: 1,
          spaceBetween: 0,
        },
        576: {
          slidesPerView: 2,
          spaceBetween: 30,
        },
        768: {
          slidesPerView: 3,
          spaceBetween: 30,
        },
        992: {
          slidesPerView: 4,
          spaceBetween: 30,
        },
        1200: {
          slidesPerView: 5,
          spaceBetween: 30,
        },
        1400: {
          slidesPerView: 5,
        },
      },
    });

    const category = new Swiper(".c-shop-active", {
      // Optional parameters
      slidesPerView: 6,
      rtl: rtl_setting,
      spaceBetween: 30,
      loop: true,
      navigation: true,
      autoplay: {
          delay: 5000,
        },

      // If we need pagination
      pagination: {
        el: ".swiper-pagination-category",
      },

      // Navigation arrows
      navigation: {
        nextEl: ".swiperc-button-next",
        prevEl: ".swiperc-button-prev",
      },
      observer: true,
      observeParents: true,

      // And if we need scrollbar
      scrollbar: {
        el: ".swiper-scrollbar",
      },
      breakpoints: {
        0: {
          slidesPerView: 1,
          spaceBetween: 0,
        },
        576: {
          slidesPerView: 2,
          spaceBetween: 0,
        },
        768: {
          slidesPerView: 3,
        },
        1200: {
          slidesPerView: 5,
        },
        1400: {
          slidesPerView: 6,
        },
      },
    });

  }
  
  //Elementor view
  $(window).on("elementor/frontend/init", function () {
    elementorFrontend.hooks.addAction(
      "frontend/element_ready/slider.default",mainSlider
    );
    elementorFrontend.hooks.addAction(
      "frontend/element_ready/woo_product.default",featured_active
    );
    elementorFrontend.hooks.addAction(
      "frontend/element_ready/woo_product_tab.default",trending_active
    );
    elementorFrontend.hooks.addAction(
      "frontend/element_ready/featured_list.default",offer_active_2
    );
    elementorFrontend.hooks.addAction(
      "frontend/element_ready/brand.default",brand_active
    );
    elementorFrontend.hooks.addAction(
      "frontend/element_ready/testimonial_slider.default",testimonial_active
    );


  });


  //   related product active
  const related_product = new Swiper(".related-product-active", {
    // Optional parameters
    slidesPerView: 4,
    spaceBetween: 30,
    rtl: rtl_setting,
    loop: true,
    autoplay: {
      delay: 5000,
    },

    // If we need pagination
    pagination: {
      el: ".swiper-pagination-product",
    },

    // Navigation arrows
    navigation: {
      nextEl: ".swiper-button-next-product",
      prevEl: ".swiper-button-prev-product",
    },

    // And if we need scrollbar
    scrollbar: {
      el: ".swiper-scrollbar",
    },
    breakpoints: {
      0: {
        slidesPerView: 1,
        spaceBetween: 0,
      },
      576: {
        slidesPerView: 2,
        spaceBetween: 0,
      },
      768: {
        slidesPerView: 3,
      },
      1200: {
        slidesPerView: 4,
      },
      1400: {
        slidesPerView: 4,
      },
    },
  });


  // header sidebar menu
  $(".sidebar-menu-toggle").on("click", function () {
    $(".side-info").addClass("visible-h-sidebar");
    $(".offcanvas-overlay").addClass("overlay-open");
  });
  $(".side-info-close,.offcanvas-overlay").on("click", function () {
    $(".side-info").removeClass("visible-h-sidebar");
    $(".offcanvas-overlay").removeClass("overlay-open");
  });
  $(".side-info-close").on("click", function () {
    $(".h-sidebar-overlay").removeClass("h-sidebar-visible");
  });

  //range slider activation

  $("#slider-range").slider({
    range: true,

    min: 0,

    max: 500,

    values: [75, 300],

    slide: function (event, ui) {
      $("#amount").val("$" + ui.values[0] + " - $" + ui.values[1]);
    },
  });
  // zoom slider
  $(".zoom-img-hover").elevateZoom({
    constrainType: "height",
    constrainSize: 274,
    zoomType: "lens",
    containLensZoom: true,
    gallery: "gallery_01",
    cursor: "pointer",
    galleryActiveClass: "active",
  });

  $("#amount").val(
    "$" +
    $("#slider-range").slider("values", 0) +
    " - $" +
    $("#slider-range").slider("values", 1)
  );
  ////////////////////////////////////////////////////
  // 23. Show Login Toggle Js
  $("#showlogin").on("click", function () {
    $("#checkout-login").slideToggle(900);
  });

  ////////////////////////////////////////////////////
  // 24. Show Coupon Toggle Js
  $("#showcoupon").on("click", function () {
    $("#checkout_coupon").slideToggle(900);
  });

  ////////////////////////////////////////////////////
  // 25. Create An Account Toggle Js
  $("#cbox").on("click", function () {
    $("#cbox_info").slideToggle(900);
  });

  ////////////////////////////////////////////////////
  // 26. Shipping Box Toggle Js
  $("#ship-box").on("click", function () {
    $("#ship-box-info").slideToggle(1000);
  });
  $(".epix-side-dropdown ul li a,.epix-side-dropdown button").on(
    "click",
    function () {
      $(".epix-side-dropdown ul").slideToggle();
    }
  );

})(jQuery);

