<?php

/**
 * epixx functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package epixx
 */

if ( !function_exists( 'epixx_setup' ) ):
    /**
     * Sets up theme defaults and registers support for various WordPress features.
     *
     * Note that this function is hooked into the after_setup_theme hook, which
     * runs before the init hook. The init hook is too late for some features, such
     * as indicating support for post thumbnails.
     */
    function epixx_setup() {
        /*
         * Make theme available for translation.
         * Translations can be filed in the /languages/ directory.
         * If you're building a theme based on epixx, use a find and replace
         * to change 'epixx' to the name of your theme in all the template files.
         */
        load_theme_textdomain( 'epixx', get_template_directory() . '/languages' );

        // Add default posts and comments RSS feed links to head.
        add_theme_support( 'automatic-feed-links' );

        /*
         * Let WordPress manage the document title.
         * By adding theme support, we declare that this theme does not use a
         * hard-coded <title> tag in the document head, and expect WordPress to
         * provide it for us.
         */
        add_theme_support( 'title-tag' );

        /*
         * Enable support for Post Thumbnails on posts and pages.
         *
         * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
         */
        add_theme_support( 'post-thumbnails' );

        // This theme uses wp_nav_menu() in one location.
        register_nav_menus( [
            'main-menu' => esc_html__( 'Main Menu', 'epixx' ),
            'top-menu' => esc_html__( 'Top Menu', 'epixx' ),
            'category-menu' => esc_html__( 'Category Menu', 'epixx' ),
            'header-search-menu' => esc_html__( 'Search Menu', 'epixx' ),
        ] );

        /*
         * Switch default core markup for search form, comment form, and comments
         * to output valid HTML5.
         */
        add_theme_support( 'html5', [
            'search-form',
            'comment-form',
            'comment-list',
            'gallery',
            'caption',
        ] );

        // Set up the WordPress core custom background feature.
        add_theme_support( 'custom-background', apply_filters( 'epixx_custom_background_args', [
            'default-color' => 'ffffff',
            'default-image' => '',
        ] ) );

        // Add theme support for selective refresh for widgets.
        add_theme_support( 'customize-selective-refresh-widgets' );

        //Enable custom header
        add_theme_support( 'custom-header' );

        /**
         * Add support for core custom logo.
         *
         * @link https://codex.wordpress.org/Theme_Logo
         */
        add_theme_support( 'custom-logo', [
            'height'      => 250,
            'width'       => 250,
            'flex-width'  => true,
            'flex-height' => true,
        ] );

        /**
         * Enable suporrt for Post Formats
         *
         * see: https://codex.wordpress.org/Post_Formats
         */
        add_theme_support( 'post-formats', [
            'image',
            'audio',
            'video',
            'gallery',
            'quote',
        ] );

        // Add support for Block Styles.
        add_theme_support( 'wp-block-styles' );

        // Add support for full and wide align images.
        add_theme_support( 'align-wide' );

        // Add support for editor styles.
        add_theme_support( 'editor-styles' );

        // Add support for responsive embedded content.
        add_theme_support( 'responsive-embeds' );

        // enable woocommerce
        add_theme_support('woocommerce');
        add_theme_support( 'wc-product-gallery-lightbox' );
        add_theme_support( 'wc-product-gallery-slider' );

        remove_theme_support( 'widgets-block-editor' );

        add_image_size( 'epixx-case-details', 1170, 600, [ 'center', 'center' ] );
    }
endif;
add_action( 'after_setup_theme', 'epixx_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function epixx_content_width() {
    // This variable is intended to be overruled from themes.
    // Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
    // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
    $GLOBALS['content_width'] = apply_filters( 'epixx_content_width', 640 );
}
add_action( 'after_setup_theme', 'epixx_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function epixx_widgets_init() {

    $footer_style_2_switch = get_theme_mod( 'footer_style_2_switch', true );
    $footer_style_3_switch = get_theme_mod( 'footer_style_3_switch', true );
    $footer_style_4_switch = get_theme_mod( 'footer_style_4_switch', true );

    /**
     * blog sidebar
     */
    register_sidebar( [
        'name'          => esc_html__( 'Blog Sidebar', 'epixx' ),
        'id'            => 'blog-sidebar',
        'before_widget' => '<div id="%1$s" class="sidebar__widget mb-50 %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<div class="sidebar__widget-title mb-35"><h4>',
        'after_title'   => '</h4></div>',
    ] );


    register_sidebar(array(
        'name' => esc_html__('Product Sidebar', 'epixx'),
        'id' => 'product-sidebar',
        'before_widget' => '<div id="%1$s" class="epix-sidebar-widget mb-40 %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h4 class="epix-s-widget-title">',
        'after_title' => '</h4>',
    ));

    $footer_widgets = get_theme_mod( 'footer_widget_number', 4 );


    // footer default
    for ( $num = 1; $num <= $footer_widgets; $num++ ) {
        register_sidebar( [
            'name'          => sprintf( esc_html__( 'Footer %1$s', 'epixx' ), $num ),
            'id'            => 'footer-' . $num,
            'description'   => sprintf( esc_html__( 'Footer %1$s', 'epixx' ), $num ),
            'before_widget' => '<div id="%1$s" class="footer-widget space_num-'. $num .' mb-40 %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h4 class="epix-footer-title">',
            'after_title'   => '</h4>',
        ] );
    }

    // footer 2
    if ( $footer_style_2_switch ) {
        for ( $num = 1; $num <= $footer_widgets+1; $num++ ) {

            register_sidebar( [
                'name'          => sprintf( esc_html__( 'Footer Style 2 : %1$s', 'epixx' ), $num ),
                'id'            => 'footer-2-' . $num,
                'description'   => sprintf( esc_html__( 'Footer Style 2 : %1$s', 'epixx' ), $num ),
                'before_widget' => '<div id="%1$s" class="footer-widget mb-40 %2$s">',
                'after_widget'  => '</div>',
                'before_title'  => '<h4 class="epix-footer-title">',
                'after_title'   => '</h4>',
            ] );
        }
    }    

    // footer 3
    if ( $footer_style_3_switch ) {
        for ( $num = 1; $num <= $footer_widgets+1; $num++ ) {
            register_sidebar( [
                'name'          => sprintf( esc_html__( 'Footer Style 3 : %1$s', 'epixx' ), $num ),
                'id'            => 'footer-3-' . $num,
                'description'   => sprintf( esc_html__( 'Footer Style 3 : %1$s', 'epixx' ), $num ),
                'before_widget' => '<div id="%1$s" class="footer-widget mb-40 %2$s">',
                'after_widget'  => '</div>',
                'before_title'  => '<h4 class="epix-footer-title">',
                'after_title'   => '</h4>',
            ] );
        }
    }

    // footer 4
    if ( $footer_style_4_switch ) {
        for ( $num = 1; $num <= $footer_widgets+2; $num++ ) {
            register_sidebar( [
                'name'          => sprintf( esc_html__( 'Footer Style 4 : %1$s', 'epixx' ), $num ),
                'id'            => 'footer-4-' . $num,
                'description'   => sprintf( esc_html__( 'Footer Style 4 : %1$s', 'epixx' ), $num ),
                'before_widget' => '<div id="%1$s" class="footer-widget mb-40 %2$s">',
                'after_widget'  => '</div>',
                'before_title'  => '<h4 class="epix-footer-title">',
                'after_title'   => '</h4>',
            ] );
        }
    }


}
add_action( 'widgets_init', 'epixx_widgets_init' );

/**
 * Enqueue scripts and styles.
 */

define( 'EPIXX_THEME_DIR', get_template_directory() );
define( 'EPIXX_THEME_URI', get_template_directory_uri() );
define( 'EPIXX_THEME_CSS_DIR', EPIXX_THEME_URI . '/assets/css/' );
define( 'EPIXX_THEME_JS_DIR', EPIXX_THEME_URI . '/assets/js/' );
define( 'EPIXX_THEME_INC', EPIXX_THEME_DIR . '/inc/' );

/**
 * epixx_scripts description
 * @return [type] [description]
 */
function epixx_scripts() {

    /**
     * all css files
     */

    wp_enqueue_style( 'epixx-fonts', epixx_fonts_url(), [], null );

    if( is_rtl() ){
        wp_enqueue_style( 'bootstrap-rtl', EPIXX_THEME_CSS_DIR.'bootstrap.rtl.min.css', array() );
    }else{
        wp_enqueue_style( 'bootstrap', EPIXX_THEME_CSS_DIR . 'bootstrap.min.css', [] );
    }
    
    wp_enqueue_style( 'fontawesome', EPIXX_THEME_CSS_DIR . 'fontawesome-all.min.css', [] );
    wp_enqueue_style( 'animate', EPIXX_THEME_CSS_DIR . 'animate.min.css', [] );
    wp_enqueue_style( 'magnific-popup', EPIXX_THEME_CSS_DIR . 'magnific-popup.css', [] );
    wp_enqueue_style( 'nice-select', EPIXX_THEME_CSS_DIR . 'nice-select.css', [] );
    wp_enqueue_style( 'pe-icon-7-stroke', EPIXX_THEME_CSS_DIR . 'pe-icon-7-stroke.css', [] );
    wp_enqueue_style( 'slick', EPIXX_THEME_CSS_DIR . 'slick.css', [] );
    wp_enqueue_style( 'meanmenu', EPIXX_THEME_CSS_DIR . 'meanmenu.css', [] );
    wp_enqueue_style( 'swipper', EPIXX_THEME_CSS_DIR . 'swipper.css', [] );
    wp_enqueue_style( 'epixx-core', EPIXX_THEME_CSS_DIR . 'epixx-core.css', [], time(), 'all' );
    wp_enqueue_style( 'epixx-custom', EPIXX_THEME_CSS_DIR . 'epixx-custom.css', [] );
    wp_enqueue_style( 'epixx-unit', EPIXX_THEME_CSS_DIR . 'epixx-unit.css', [], time(), 'all' );
    wp_enqueue_style( 'epixx-style', get_stylesheet_uri() );
    wp_enqueue_style( 'epixx-responsive', EPIXX_THEME_CSS_DIR . 'responsive.css', [] );

    // all js
    wp_enqueue_script( 'bootstrap-bundle', EPIXX_THEME_JS_DIR . 'bootstrap.bundle.min.js', [ 'jquery' ], '', true );
    wp_enqueue_script( 'isotope-pkgd', EPIXX_THEME_JS_DIR . 'isotope.pkgd.min.js', [ 'imagesloaded' ], false, true );
    wp_enqueue_script( 'slick', EPIXX_THEME_JS_DIR . 'slick.min.js', [ 'jquery' ], false, true );
    wp_enqueue_script( 'swipper-js', EPIXX_THEME_JS_DIR . 'swipper-bundle.min.js', [ 'jquery' ], false, true );
    wp_enqueue_script( 'jquery-meanmenu', EPIXX_THEME_JS_DIR . 'jquery.meanmenu.min.js', [ 'jquery' ], false, true );
    wp_enqueue_script( 'elevatezoom', EPIXX_THEME_JS_DIR . 'jquery.elevatezoom.js', [ 'jquery' ], '', true );
    wp_enqueue_script( 'wow', EPIXX_THEME_JS_DIR . 'wow.min.js', [ 'jquery' ], false, true );
    wp_enqueue_script( 'nice-select', EPIXX_THEME_JS_DIR . 'nice-select.js', [ 'jquery' ], '', true );
        wp_enqueue_script('countdown', EPIXX_THEME_JS_DIR . 'countdown.min.js', array('jquery'), false, true);
    wp_enqueue_script( 'jquery-scrollup', EPIXX_THEME_JS_DIR . 'jquery.scrollUp.min.js', [ 'jquery' ], '', true );
    wp_enqueue_script( 'countdown', EPIXX_THEME_JS_DIR . 'countdown.min.js', [ 'jquery' ], false, true );
    wp_enqueue_script( 'jquery-ui-slider-range', EPIXX_THEME_JS_DIR . 'jquery-ui-slider-range.js', [ 'jquery' ], false, true );
    wp_enqueue_script( 'jquery-magnific-popup', EPIXX_THEME_JS_DIR . 'jquery.magnific-popup.min.js', [ 'jquery' ], false, true );
    wp_enqueue_script( 'mouse-wheel', EPIXX_THEME_JS_DIR . 'mouse-wheel.min.js', [ 'jquery' ], '', true );
    wp_enqueue_script( 'epixx-main', EPIXX_THEME_JS_DIR . 'main.js', [ 'jquery' ], time(), true );

    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }
}
add_action( 'wp_enqueue_scripts', 'epixx_scripts' );

/*
Register Fonts
 */
function epixx_fonts_url() {
    $font_url = '';

    /*
    Translators: If there are characters in your language that are not supported
    by chosen font(s), translate this to 'off'. Do not translate into your own language.
     */
    if ( 'off' !== _x( 'on', 'Google font: on or off', 'epixx' ) ) {
        $font_url = 'https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&family=Jost:wght@300;400;500;600;700;800;900&display=swap';
    }
    return $font_url;
}

// wp_body_open
if ( !function_exists( 'wp_body_open' ) ) {
    function wp_body_open() {
        do_action( 'wp_body_open' );
    }
}

/**
 * Implement the Custom Header feature.
 */
require EPIXX_THEME_INC . 'custom-header.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require EPIXX_THEME_INC . 'template-functions.php';


/**
 * Custom template helper function for this theme.
 */
require EPIXX_THEME_INC . 'template-helper.php';

/**
 * initialize kirki customizer class.
 */
include_once EPIXX_THEME_INC . 'kirki-customizer.php';
include_once EPIXX_THEME_INC . 'class-epixx-kirki.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
    require EPIXX_THEME_INC . 'jetpack.php';
}


// Woo Check
if (!defined('EPIXX_WOOCOMMERCE_ACTIVED')) {
    define('EPIXX_WOOCOMMERCE_ACTIVED', in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins'))));
}

define('EPIXX_WISHLIST_ACTIVED', in_array('yith-woocommerce-wishlist/init.php', apply_filters('active_plugins', get_option('active_plugins'))));

define('EPIXX_QUICK_VIEW_ACTIVED', in_array('yith-woocommerce-quick-view/init.php', apply_filters('active_plugins', get_option('active_plugins'))));

if (EPIXX_WOOCOMMERCE_ACTIVED) {
    require_once EPIXX_THEME_INC . 'epixx-woocommerce.php';
}

/**
 * include epixx functions file
 */
require_once EPIXX_THEME_INC . 'class-breadcrumb.php';
require_once EPIXX_THEME_INC . 'class-navwalker.php';
require_once EPIXX_THEME_INC . 'class-tgm-plugin-activation.php';
require_once EPIXX_THEME_INC . 'add_plugin.php';

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function epixx_pingback_header() {
    if ( is_singular() && pings_open() ) {
        printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
    }
}
add_action( 'wp_head', 'epixx_pingback_header' );

/**
 *
 * comment section
 *
 */
add_filter( 'comment_form_default_fields', 'epixx_comment_form_default_fields_func' );

function epixx_comment_form_default_fields_func( $default ) {

    $default['author'] = '<div class="row">
    <div class="col-xl-6 col-md-6">
    	<div class="post-input">
        	<input type="text" name="author" placeholder="' . esc_attr__( 'Your Name', 'epixx' ) . '">
        </div>
    </div>';
    $default['email'] = '<div class="col-xl-6 col-md-6">
		<div class="post-input">
        <input type="text" name="email" placeholder="' . esc_attr__( 'Your Email', 'epixx' ) . '">
    	</div>
    </div>';
    // $default['url'] = '';
    $defaults['comment_field'] = '';

    $default['url'] = '<div class="col-xl-12">
		<div class="post-input">
        <input type="text" name="url" placeholder="' . esc_attr__( 'Website', 'epixx' ) . '">
    	</div>
    </div>';
    return $default;
}

add_action( 'comment_form_top', 'epixx_add_comments_textarea' );
function epixx_add_comments_textarea() {
    if ( !is_user_logged_in() ) {
        echo '<div class="row"><div class="col-xl-12"><div class="post-input"><textarea id="comment" name="comment" cols="60" rows="6" placeholder="' . esc_attr__( 'Write your comment here...', 'epixx' ) . '" aria-required="true"></textarea></div></div></div>';
    }
}

add_filter( 'comment_form_defaults', 'epixx_comment_form_defaults_func' );

function epixx_comment_form_defaults_func( $info ) {
    if ( !is_user_logged_in() ) {
        $info['comment_field'] = '';
        $info['submit_field'] = '%1$s %2$s</div>';
    } else {
        $info['comment_field'] = '<div class="post-input"><textarea id="comment" name="comment" cols="30" rows="10" placeholder="' . esc_attr__( 'Comment *', 'epixx' ) . '"></textarea>';
        $info['submit_field'] = '%1$s %2$s</div>';
    }

    $info['submit_button'] = '<div class="col-xl-12"><button class="e-btn" type="submit">' . esc_html__( 'Post Comment', 'epixx' ) . ' </button></div>';

    $info['title_reply_before'] = '<div class="post-comments-title">
                                        <h2>';
    $info['title_reply_after'] = '</h2></div>';
    $info['comment_notes_before'] = '';

    return $info;
}

if ( !function_exists( 'epixx_comment' ) ) {
    function epixx_comment( $comment, $args, $depth ) {
        $GLOBAL['comment'] = $comment;
        extract( $args, EXTR_SKIP );
        $args['reply_text'] = 'Reply <i class="fal fa-reply"></i>';
        $replayClass = 'comment-depth-' . esc_attr( $depth );
        ?>
			<li id="comment-<?php comment_ID();?>">
				<div class="comments-box">
					<div class="comments-avatar">
						<?php print get_avatar( $comment, 102, null, null, [ 'class' => [] ] );?>
					</div>
					<div class="comments-text">
						<div class="avatar-name">
							<h5><?php print get_comment_author_link();?></h5>
							<span><?php comment_time( get_option( 'date_format' ) );?></span>
						</div>
						<?php comment_text();?>
						<?php comment_reply_link( array_merge( $args, [ 'depth' => $depth, 'max_depth' => $args['max_depth'] ] ) );?>
					</div>
				</div>
		<?php
}
}

/**
 * shortcode supports for removing extra p, spance etc
 *
 */
add_filter( 'the_content', 'epixx_shortcode_extra_content_remove' );
/**
 * Filters the content to remove any extra paragraph or break tags
 * caused by shortcodes.
 *
 * @since 1.0.0
 *
 * @param string $content  String of HTML content.
 * @return string $content Amended string of HTML content.
 */
function epixx_shortcode_extra_content_remove( $content ) {

    $array = [
        '<p>['    => '[',
        ']</p>'   => ']',
        ']<br />' => ']',
    ];
    return strtr( $content, $array );

}

// epixx_search_filter_form
if ( !function_exists( 'epixx_search_filter_form' ) ) {
    function epixx_search_filter_form( $form ) {

        $form = sprintf(
            '<div class="sidebar__widget-px"><div class="search-px"><form class="sidebar-search-form" action="%s" method="get">
      	<input type="text" value="%s" required name="s" placeholder="%s">
      	<button type="submit"> <i class="far fa-search"></i>  </button>
		</form></div></div>',
            esc_url( home_url( '/' ) ),
            esc_attr( get_search_query() ),
            esc_html__( 'Search', 'epixx' )
        );

        return $form;
    }
    add_filter( 'get_search_form', 'epixx_search_filter_form' );
}

add_action( 'admin_enqueue_scripts', 'epixx_admin_custom_scripts' );

function epixx_admin_custom_scripts() {
    wp_enqueue_media();
    wp_enqueue_style( 'customizer-style', get_template_directory_uri() . '/inc/css/customizer-style.css',array());
    wp_register_script( 'epixx-admin-custom', get_template_directory_uri() . '/inc/js/admin_custom.js', [ 'jquery' ], '', true );
    wp_enqueue_script( 'epixx-admin-custom' );
}
