<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package epixx
 */
?>

<!doctype html>
<html <?php language_attributes();?>>
<head>
	<meta charset="<?php bloginfo( 'charset' );?>">
    <?php if ( is_singular() && pings_open( get_queried_object() ) ): ?>
    <?php endif;?>
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<?php wp_head();?>
</head>

<body <?php body_class();?>>

    <?php
        $epixx_preloader = get_theme_mod( 'epixx_preloader', true );
        $epixx_backtotop = get_theme_mod( 'epixx_backtotop', true );


    ?>

    <?php if ( !empty( $epixx_preloader ) ): ?>
    <div id="loading">
      <div id="loading-center">
        <div id="loading-center-absolute">
          <div class="object" id="first_object"></div>
          <div class="object" id="second_object"></div>
          <div class="object" id="third_object"></div>
        </div>
      </div>
    </div>
    <?php endif;?>

    <?php if ( !empty( $epixx_backtotop ) ): ?>
    <button class="scroll-top scroll-to-target" data-target="html">
        <i class="fas fa-angle-up"></i>
    </button>
    <?php endif;?>

    <?php wp_body_open();?>

    <!-- header start -->
    <?php do_action( 'epixx_header_style' );?>
    <!-- header end -->
    
    <!-- wrapper-box start -->
    <?php do_action( 'epixx_before_main_content' );?>






