<?php
/**
 * [epixx_remove_hook description]
 * @return [type] [description]
 */
function epixx_remove_hook() {
	
	remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );
	remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
	remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );
	add_action( 'epixx_before_shop_loop_item_thumb_link', 'woocommerce_template_loop_product_link_open', 10 );
	remove_action( 'woocommerce_sidebar', 'woocommerce_get_sidebar', 10 );
	add_action( 'woocommerce_sidebar', 'epixx_woocommerce_get_sidebar', 10 );

	add_action( 'woocommerce_mid_shop_loop_item_title', 'woocommerce_template_loop_product_link_close', 5 );
	add_action( 'woocommerce_before_shop_loop_item_title', 'epixx_product_cart_button', 10 );

	remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10 );
	add_action( 'epixx_woocommerce_after_shop_loop_item_title', 'epixx_woo_rating', 10 );
	add_action( 'woocommerce_after_shop_loop_item_title', 'epixx_woocommerce_template_loop_price', 10 );

	add_action( 'epixx_woocommerce_after_shop_loop_item', 'epixx_list_product_cart_button_only', 20 );
	add_action( 'epixx_woocommerce_after_shop_loop_item', 'woocommerce_template_single_excerpt', 10 );

}

epixx_remove_hook();

add_filter( 'woocommerce_show_page_title', function () {
	return false;
} );


/**
 * Single Product
 */

if ( ! function_exists( 'epixx_quick_view_images' ) ) {

	/**
	 * Output the product image before the single product summary.
	 */
	function epixx_quick_view_images() { ?>
        <div class="bdevs-quick-view-images">
			<?php wc_get_template( 'single-product/product-image.php' );
			?>
        </div>
		<?php
	}
}


/**
 * [epixx_product_title description]
 * @return [type] [description]
 */
function epixx_product_title() {
	echo '<h6><a href="' . get_the_permalink() . '">' . get_the_title() . '</a></h6>';
}

/**
 * [epixx_product_cart_button description]
 * @return [type] [description]
 */
function epixx_product_cart_button() {
	global $product;
	$class      = 'product_type_' . $product->get_type() . ' add_to_cart_button ' . ( $product->supports( 'ajax_add_to_cart' ) ? 'ajax_add_to_cart' : '' );
	$attributes = array(
		'data-product_id'  => $product->get_id(),
		'data-product_sku' => $product->get_sku(),
		'aria-label'       => $product->add_to_cart_description(),
		'rel'              => 'nofollow',
	);
	print '<div class="epix-action">';
	print epixx_quick_view_button( $product->get_id() );
	print epixx_vc_yith_wishlist();
	print '<a ' . http_build_query( $attributes, ' ', ' ' ) . ' class="' . $class . ' p-cart a_un" href="' . $product->add_to_cart_url() . '"><i class="fal fa-shopping-cart"></i></a>';

	print '</div>';
}


/**
 * [epixx_list_product_cart_button description]
 * @return [type] [description]
 */
function epixx_list_product_cart_button() {
	global $product;
	$class      = 'product_type_' . $product->get_type() . ' add_to_cart_button ' . ( $product->supports( 'ajax_add_to_cart' ) ? 'ajax_add_to_cart' : '' );
	$attributes = array(
		'data-product_id'  => $product->get_id(),
		'data-product_sku' => $product->get_sku(),
		'aria-label'       => $product->add_to_cart_description(),
		'rel'              => 'nofollow',
	);
	print '<div class="product-action">';
	print '<a ' . http_build_query( $attributes, ' ', ' ' ) . ' class="' . $class . '" href="' . $product->add_to_cart_url() . '"><i class="fal fa-cart-arrow-down"></i></a>';
	print epixx_quick_view_button( $product->get_id() );
	print epixx_vc_yith_wishlist();
	print '</div>';
}

/**
 * [epixx_list_product_cart_button_only description]
 * @return [type] [description]
 */
function epixx_list_product_cart_button_only() {
	global $product;
	$class      = 'product_type_' . $product->get_type() . ' add_to_cart_button ' . ( $product->supports( 'ajax_add_to_cart' ) ? 'ajax_add_to_cart' : '' );
	$attributes = array(
		'data-product_id'  => $product->get_id(),
		'data-product_sku' => $product->get_sku(),
		'aria-label'       => $product->add_to_cart_description(),
		'rel'              => 'nofollow',
	);
	print '<div class="epixx_cart_list_button">';
	print '<a ' . http_build_query( $attributes, ' ', ' ' ) . ' class="epix-btn-1 epix_cart_only ' . $class . '" href="' . $product->add_to_cart_url() . '"><span>Add To Cart</span></a>';
	print epixx_vc_yith_wishlist();
	print epixx_quick_view_button( $product->get_id() );
	print '</div>';

}

/**
 * [epixx_woo_rating description]
 * @return [type] [description]
 */


function epixx_woo_rating() {
	global $product;
	$rating = $product->get_average_rating();
	$review = 'Rating ' . $rating . ' out of 5';
	$html   = '';
	$html   .= '<div class="details-rating rating" title="' . $review . '">';
	for ( $i = 0; $i <= 4; $i ++ ) {
		if ( $i < floor( $rating ) ) {
			$html .= '<i class="fas fa-star"></i>';
		} else {
			$html .= '<i class="fal fa-star"></i>';
		}
	}
	$html .= '<span>( ' . $rating . ' out of 5 )</span>';
	$html .= '</div>';
	print epixx_woo_rating_html( $html );
}

function epixx_woo_rating_html( $html ) {
	return $html;
}



/**
 * [epixx_woo_rating description]
 * @return [type] [description]
 */
function epixx_woo_shop_rating() {
	global $product;
	$rating = $product->get_average_rating();
	$review = esc_html( 'Rating ' . $rating . ' out of 5' );
	ob_start(); ?>
    <div class="rating mb-10" title="<?php print esc_attr( $review ); ?>">
		<?php
		for ( $i = 0; $i <= 4; $i ++ ) {
			if ( $i < floor( $rating ) ) { ?>
                <i class="fas fa-star"></i>
				<?php
			} else { ?>
                <i class="fal fa-star"></i>
				<?php
			}
		}
		?>
    </div>
	<?php
	return ob_get_clean();
}

function epixx_get_price() {
	ob_start(); ?>
    <span class="price"><?php print epixx_get_price_html(); ?></span>
	<?php
	return ob_get_clean();
}

function epixx_get_price_html() {
	global $product;

	return $product->get_price_html();
}

/**
 * [epixx_comment_rating description]
 *
 * @param  [type] $rating [description]
 *
 * @return [type]         [description]
 */
function epixx_comment_rating( $rating ) {
	$review = 'Rating ' . $rating . ' out of 5';
	$html   = '';
	$html   .= '<div class="rating" title="' . $review . '">';
	for ( $i = 0; $i <= 4; $i ++ ) {
		if ( $i < floor( $rating ) ) {
			$html .= '<i class="fas fa-star"></i>';
		} else {
			$html .= '<i class="far fa-star"></i>';
		}
	}
	$html .= '</div>';

	return $html;
}


add_filter( 'add_to_cart_fragments', 'epixx_woocommerce_header_add_to_cart_fragment' );

/**
 * [epixx_woocommerce_header_add_to_cart_fragment description]
 *
 * @param  [type] $fragments [description]
 *
 * @return [type]            [description]
 */
function epixx_woocommerce_header_add_to_cart_fragment( $fragments ) {
	global $woocommerce;
	ob_start();
	?>
    <a class="cp-minicart" href="<?php echo wc_get_cart_url(); ?>"><i class="fas fa-shopping-cart"></i><span
                id="epixx-cart"
                class="mini-cart-items"><?php print WC()->cart->get_cart_contents_count(); ?></span></a>
	<?php
	$fragments['a.cp-minicart'] = ob_get_clean();

	return $fragments;
}

function epixx_vc_yith_wishlist() {

	global $product;

	$cssclass = 'wishlist-rd';
	$mar      = 'tanzim-mar-top';

	$id   = $product->get_id();
	$type = $product->get_type();
	$link = get_template_directory_uri();
	$img    = '<img src="' . esc_url( $link ) . '/assets/img/icon/wpspin_light.gif" class="ajax-loading tanzim_wi_loder" alt="' . esc_attr( 'loading' ) . '" width="16" height="16" style="visibility:hidden">';
	$markup = '';

	if ( EPIXX_WISHLIST_ACTIVED ) {

		$markup .= '<div class="yith-wcwl-add-to-wishlist ' . $mar . ' add-to-wishlist-' . $id . '">';
		$markup .= '<div class="yith-wcwl-add-button wishlist show" style="display:block">';
		$markup .= '<a href="' . $link . '/shop/?add_to_wishlist=' . $id . '" rel="nofollow" data-product-id="' . $id . '" data-product-type="' . $type . '" class="add_to_wishlist p-cart a_un2 ' . $cssclass . '">';
		$markup .= '<i class="fal fa-heart"></i></a>';
		$markup .= $img;
		$markup .= '</div>';
		$markup .= '<div class="yith-wcwl-wishlistaddedbrowse wishlist hide" style="display:none;">';
		$markup .= '<a href="' . $link . '/wishlist/view/" rel="nofollow" class=" ' . $cssclass . '"><i class="fal fa-heart"></i></a>';
		$markup .= $img;
		$markup .= '</div>';
		$markup .= '<div class="yith-wcwl-wishlistexistsbrowse wishlist  hide" style="display:none">';
		$markup .= '<a href="' . $link . '/wishlist/view/" rel="nofollow" class=" ' . $cssclass . '"><i class="fal fa-heart"></i></a>';
		$markup .= $img;
		$markup .= '</div>';
		$markup .= '<div style="clear:both"></div>';
		$markup .= '<div class="yith-wcwl-wishlistaddresponse"></div>';
		$markup .= '</div>';

	}

	return $markup;
}

add_filter( 'woocommerce_product_additional_information_heading', 'epixx_tab_heading' );
add_filter( 'woocommerce_product_description_heading', 'epixx_tab_heading' );


/**
 * [epixx_tab_heading description]
 *
 * @param  [type] $heading [description]
 *
 * @return [type]          [description]
 */
function epixx_tab_heading( $heading ) {
	return '';
}

/**
 * [epixx_woo_pagination description]
 *
 * @param  [type] $pagination [description]
 *
 * @return [type]             [description]
 */
function epixx_woo_pagination( $pagination ) {
	$pagi = '';
	if ( $pagination != '' ) {
		$pagi .= '<ul class="pagination justify-content-start">';
		foreach ( $pagination as $key => $pg ) {
			$pagi .= '<li class="page-item">' . $pg . '</li>';
		}
		$pagi .= '</ul>';
	}

	return $pagi;
}

function epixx_woocommerce_get_sidebar() {
	dynamic_sidebar( 'product-sidebar' );
}
                                                         

function epixx_woocommerce_template_loop_price() {
	print '<div class="epixx_price">';
	echo epixx_get_price();
	print '</div>';    
}

function epixx_woocommerce_template_single_price() {
	print '<div class="price mt-15 mb-20">';
	print epixx_get_price_html();
	print '</div>';
}

if ( ! function_exists( 'epixx_header_add_to_cart_fragment' ) ) {
	function epixx_header_add_to_cart_fragment( $fragments ) {
		ob_start();
		?>
        <span class="cart__count" id="epixx-cart-item">
			<?php echo esc_html( WC()->cart->cart_contents_count ); ?>
		</span>
		<?php
		$fragments['#epixx-cart-item'] = ob_get_clean();

		return $fragments;
	}
}
add_filter( 'woocommerce_add_to_cart_fragments', 'epixx_header_add_to_cart_fragment' );

if ( ! function_exists( 'epixx_header_add_to_cart_price' ) ) {
	function epixx_header_add_to_cart_price( $fragments ) {
		ob_start();
		?>
        <span class="cart__amount" id="epixx-total-price">
			<?php echo WC()->cart->get_cart_total(); ?>
		</span>
		<?php
		$fragments['#epixx-total-price'] = ob_get_clean();

		return $fragments;
	}
}
add_filter( 'woocommerce_add_to_cart_fragments', 'epixx_header_add_to_cart_price' );


function epixx_product_tab() {
	ob_start();
	?>
    <div class="ch-left mb-20">
        <ul class="nav shop-tabs" id="myTab" role="tablist">
            <li class="nav-item">
                <a class="nav-link active" id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home"
                   aria-selected="true"><i class="fas fa-th"></i></a>
            </li>
            <li class="nav-item">
                <a class="nav-link" id="profile-tab" data-toggle="tab" href="#profile" role="tab"
                   aria-controls="profile" aria-selected="false"><i class="fas fa-list-ul"></i></a>
            </li>
        </ul>
    </div>
    </div> <!-- pro-filter parent end -->
	<?php
	print ob_get_clean();
}

function epixx_quick_view_button( $product_id ) {
	if ( EPIXX_QUICK_VIEW_ACTIVED ) {
		$product = wc_get_product( $product_id );
		$button  = '';
		if ( $product_id ) {

			$button = '<a href="#" class="button yith-wcqv-button p-cart product-popup-toggle a_un3 " data-product_id="' . esc_attr( $product_id ) . '" data-toggle="tooltip" data-placement="top" title="Quick View"><i class="fal fa-eye"></i></a>';
			$button = apply_filters( 'yith_add_quick_view_button_html', $button, '', $product );
		}

		return $button;
	}
}



function epixx_product_compare_button( $product_id ) {
	if ( EPIXX_COMPARE_ACTIVED ) {
		$product = wc_get_product( $product_id );
		$button  = '';
		if ( $product_id ) {
			$url_args = array(
				'action' => 'yith-woocompare-add-product',
				'id'     => $product_id
			);
			$button   = sprintf( '<a href="%1$s" class="compare button" data-product_id="%2$s" rel="nofollow"><i class="fal fa-exchange"></i></a>',
				get_page_link() . '?action=yith-woocompare-add-product&amp;id=' . esc_attr( $product_id ),
				esc_attr( $product_id )
			);
		}

		return $button;
	}
}

add_filter('woocommerce_add_to_cart_fragments', function ($fragments) {
    ob_start();
    ?>
    <div class="header-mini-cart">
        <?php woocommerce_mini_cart(); ?>
    </div>
    <?php $fragments['.header-mini-cart'] = ob_get_clean();
    return $fragments;
});


add_filter( 'woocommerce_get_image_size_gallery_thumbnail', function( $size ) {
    return array(
        'width' => 200,
        'height' => 200,
        'crop' => 0,
    );
} );