<?php
/**
 * epixx customizer
 *
 * @package epixx
 */

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Added Panels & Sections
 */
function epixx_customizer_panels_sections( $wp_customize ) {

    //Add panel
    $wp_customize->add_panel( 'epixx_customizer', [
        'priority' => 10,
        'title'    => esc_html__( 'epixx Customizer', 'epixx' ),
    ] );

    /**
     * Customizer Section
     */
    $wp_customize->add_section( 'header_top_setting', [
        'title'       => esc_html__( 'Header Topbar Setting', 'epixx' ),
        'description' => '',
        'priority'    => 10,
        'capability'  => 'edit_theme_options',
        'panel'       => 'epixx_customizer',
    ] );

    $wp_customize->add_section( 'header_social', [
        'title'       => esc_html__( 'Header Social', 'epixx' ),
        'description' => '',
        'priority'    => 11,
        'capability'  => 'edit_theme_options',
        'panel'       => 'epixx_customizer',
    ] );

    $wp_customize->add_section( 'section_header_logo', [
        'title'       => esc_html__( 'Header Setting', 'epixx' ),
        'description' => '',
        'priority'    => 12,
        'capability'  => 'edit_theme_options',
        'panel'       => 'epixx_customizer',
    ] );

    $wp_customize->add_section( 'blog_setting', [
        'title'       => esc_html__( 'Blog Setting', 'epixx' ),
        'description' => '',
        'priority'    => 13,
        'capability'  => 'edit_theme_options',
        'panel'       => 'epixx_customizer',
    ] );

    $wp_customize->add_section( 'header_side_setting', [
        'title'       => esc_html__( 'Side Info', 'epixx' ),
        'description' => '',
        'priority'    => 14,
        'capability'  => 'edit_theme_options',
        'panel'       => 'epixx_customizer',
    ] );

    $wp_customize->add_section( 'breadcrumb_setting', [
        'title'       => esc_html__( 'Breadcrumb Setting', 'epixx' ),
        'description' => '',
        'priority'    => 15,
        'capability'  => 'edit_theme_options',
        'panel'       => 'epixx_customizer',
    ] );

    $wp_customize->add_section( 'blog_setting', [
        'title'       => esc_html__( 'Blog Setting', 'epixx' ),
        'description' => '',
        'priority'    => 16,
        'capability'  => 'edit_theme_options',
        'panel'       => 'epixx_customizer',
    ] );

    $wp_customize->add_section( 'footer_setting', [
        'title'       => esc_html__( 'Footer Settings', 'epixx' ),
        'description' => '',
        'priority'    => 16,
        'capability'  => 'edit_theme_options',
        'panel'       => 'epixx_customizer',
    ] );

    $wp_customize->add_section( 'color_setting', [
        'title'       => esc_html__( 'Color Setting', 'epixx' ),
        'description' => '',
        'priority'    => 17,
        'capability'  => 'edit_theme_options',
        'panel'       => 'epixx_customizer',
    ] );

    $wp_customize->add_section( '404_page', [
        'title'       => esc_html__( '404 Page', 'epixx' ),
        'description' => '',
        'priority'    => 18,
        'capability'  => 'edit_theme_options',
        'panel'       => 'epixx_customizer',
    ] );

    $wp_customize->add_section( 'typo_setting', [
        'title'       => esc_html__( 'Typography Setting', 'epixx' ),
        'description' => '',
        'priority'    => 18,
        'capability'  => 'edit_theme_options',
        'panel'       => 'epixx_customizer',
    ] );

}

add_action( 'customize_register', 'epixx_customizer_panels_sections' );

function _header_top_fields( $fields ) {
    $fields[] = [
        'type'     => 'switch',
        'settings' => 'epixx_topbar_switch',
        'label'    => esc_html__( 'Topbar Swicher', 'epixx' ),
        'section'  => 'header_top_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'epixx' ),
            'off' => esc_html__( 'Disable', 'epixx' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'epixx_preloader',
        'label'    => esc_html__( 'Preloader On/Off', 'epixx' ),
        'section'  => 'header_top_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'epixx' ),
            'off' => esc_html__( 'Disable', 'epixx' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'epixx_backtotop',
        'label'    => esc_html__( 'BackToTop On/Off', 'epixx' ),
        'section'  => 'header_top_setting',
        'default'  => 1,
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'epixx' ),
            'off' => esc_html__( 'Disable', 'epixx' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'epixx_header_contract_switch',
        'label'    => esc_html__( 'Contract Swicher', 'epixx' ),
        'section'  => 'header_top_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'epixx' ),
            'off' => esc_html__( 'Disable', 'epixx' ),
        ],

    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_header_top_phone',
        'label'    => esc_html__( 'Phone Number', 'epixx' ),
        'section'  => 'header_top_setting',
        'default'  => esc_html__( '18000 344 585', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'epixx_header_contract_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_header_top_phone_url',
        'label'    => esc_html__( 'Phone Number URL', 'epixx' ),
        'section'  => 'header_top_setting',
        'default'  => esc_html__( '18000344585', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'epixx_header_contract_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'epixx_header_social_switch',
        'label'    => esc_html__( 'Header Social Swicher', 'epixx' ),
        'section'  => 'header_social',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'epixx' ),
            'off' => esc_html__( 'Disable', 'epixx' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'epixx_header_lang',
        'label'    => esc_html__( 'Show Language', 'epixx' ),
        'section'  => 'header_top_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'epixx' ),
            'off' => esc_html__( 'Disable', 'epixx' ),
        ],
        'active_callback' => [
            [
                'setting'  => 'epixx_topbar_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'epixx_search',
        'label'    => esc_html__( 'Search On/Off', 'epixx' ),
        'section'  => 'header_top_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'epixx' ),
            'off' => esc_html__( 'Disable', 'epixx' ),
        ],
    ];

    $fields[] = array(
        'type' => 'switch',
        'settings' => 'epixx_login_reg_switch',
        'label' => esc_html__('Show Login/Register', 'epixx'),
        'section' => 'header_top_setting',
        'default' => '0',
        'priority' => 10,
        'choices' => [
            'on' => esc_html__('Enable', 'epixx'),
            'off' => esc_html__('Disable', 'epixx'),
        ],
    );

    $fields[] = array(
        'type' => 'switch',
        'settings' => 'epixx_trackorder_switch',
        'label' => esc_html__('Show Track', 'epixx'),
        'section' => 'header_top_setting',
        'default' => '0',
        'priority' => 10,
        'choices' => [
            'on' => esc_html__('Enable', 'epixx'),
            'off' => esc_html__('Disable', 'epixx'),
        ],
    );

    $fields[] = array(
        'type' => 'text',
        'settings' => 'epixx_track_link',
        'label' => esc_html__('Track Link', 'epixx'),
        'section' => 'header_top_setting',
        'default' => esc_html__('/wp/epixx/contact/', 'epixx'),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'epixx_trackorder_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    );


    $fields[] = array(
        'type' => 'switch',
        'settings' => 'epixx_whishlist_switch',
        'label' => esc_html__('Show Whishlist', 'epixx'),
        'section' => 'header_top_setting',
        'default' => '0',
        'priority' => 10,
        'choices' => [
            'on' => esc_html__('Enable', 'epixx'),
            'off' => esc_html__('Disable', 'epixx'),
        ],
    );

    $fields[] = array(
        'type' => 'text',
        'settings' => 'epixx_wishlist_link',
        'label' => esc_html__('Wishlist Link', 'epixx'),
        'section' => 'header_top_setting',
        'default' => esc_html__('/wp/epixx/wishlist/', 'epixx'),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'epixx_whishlist_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    );

    $fields[] = array(
        'type' => 'switch',
        'settings' => 'epixx_cart_switch',
        'label' => esc_html__('Show Cart', 'epixx'),
        'section' => 'header_top_setting',
        'default' => '0',
        'priority' => 10,
        'choices' => [
            'on' => esc_html__('Enable', 'epixx'),
            'off' => esc_html__('Disable', 'epixx'),
        ],
    );


    $fields[] = [
        'type'     => 'switch',
        'settings' => 'epixx_header_right',
        'label'    => esc_html__( 'Header Right On/Off', 'epixx' ),
        'section'  => 'header_top_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'epixx' ),
            'off' => esc_html__( 'Disable', 'epixx' ),
        ],
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'epixx_worldwide_img',
        'label'       => esc_html__( 'Worldwide image', 'epixx' ),
        'description' => esc_html__( 'Upload Icon Image', 'epixx' ),
        'section'     => 'header_top_setting',
        'default'     => get_template_directory_uri() . '/assets/img/icon/world.png',
        'active_callback' => [
            [
                'setting'  => 'epixx_header_right',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_worldwide_text',
        'label'    => esc_html__( 'Worldwide text', 'epixx' ),
        'section'  => 'header_top_setting',
        'default'  => esc_html__( 'World Wide', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'epixx_header_right',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_freeshipping_text',
        'label'    => esc_html__( 'Free Shipping text', 'epixx' ),
        'section'  => 'header_top_setting',
        'default'  => esc_html__( 'Free Shipping', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'epixx_header_right',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'link',
        'settings' => 'epixx_worldwide_link',
        'label'    => esc_html__( 'Worldwide URL', 'epixx' ),
        'section'  => 'header_top_setting',
        'default'  => esc_html__( '#', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'epixx_header_right',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'epixx_support_img',
        'label'       => esc_html__( 'Support image', 'epixx' ),
        'description' => esc_html__( 'Upload Icon Image', 'epixx' ),
        'section'     => 'header_top_setting',
        'default'     => get_template_directory_uri() . '/assets/img/icon/world.png',
        'active_callback' => [
            [
                'setting'  => 'epixx_header_right',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];


    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_support_text',
        'label'    => esc_html__( 'Support Text', 'epixx' ),
        'section'  => 'header_top_setting',
        'default'  => esc_html__( '24 Support', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'epixx_header_right',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_phoneright_text',
        'label'    => esc_html__( 'Phone Number', 'epixx' ),
        'section'  => 'header_top_setting',
        'default'  => esc_html__( '+1800 453 856', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'epixx_header_right',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'link',
        'settings' => 'epixx_phoneright_url',
        'label'    => esc_html__( 'Phone URL', 'epixx' ),
        'section'  => 'header_top_setting',
        'default'  => esc_html__( '+1800453856', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'epixx_header_right',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];


    return $fields;

}
add_filter( 'kirki/fields', '_header_top_fields' );

/*
Header Social 
 */
function _header_social_fields( $fields ) {
    // header section social
    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_topbar_fb_url',
        'label'    => esc_html__( 'Facebook Url', 'epixx' ),
        'section'  => 'header_social',
        'default'  => esc_html__( '#', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'epixx_header_social_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],

    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_topbar_twitter_url',
        'label'    => esc_html__( 'Twitter Url', 'epixx' ),
        'section'  => 'header_social',
        'default'  => esc_html__( '#', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'epixx_header_social_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_topbar_linkedin_url',
        'label'    => esc_html__( 'Linkedin Url', 'epixx' ),
        'section'  => 'header_social',
        'default'  => esc_html__( '#', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'epixx_header_social_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_topbar_instagram_url',
        'label'    => esc_html__( 'Instagram Url', 'epixx' ),
        'section'  => 'header_social',
        'default'  => esc_html__( '#', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'epixx_header_social_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_topbar_pinterest_url',
        'label'    => esc_html__( 'Pinterest Url', 'epixx' ),
        'section'  => 'header_social',
        'default'  => esc_html__( '#', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'epixx_header_social_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_topbar_whatsapp_url',
        'label'    => esc_html__( 'Whatsapp Url', 'epixx' ),
        'section'  => 'header_social',
        'default'  => esc_html__( '#', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'epixx_header_social_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];


    return $fields;
}
add_filter( 'kirki/fields', '_header_social_fields' );

/*
Header Settings
 */
function _header_header_fields( $fields ) {

    $fields[] = [
        'type'        => 'radio-image',
        'settings'    => 'choose_default_header',
        'label'       => esc_html__( 'Choose Header Style', 'epixx' ),
        'section'     => 'section_header_logo',
        'default'     => 'header-style-1',
        'placeholder' => esc_html__( 'Select an option...', 'epixx' ),
        'priority'    => 10,
        'choices'     => [
            'header-style-1' => get_template_directory_uri() . '/inc/img/header/header-1.png',
            'header-style-2' => get_template_directory_uri() . '/inc/img/header/header-2.png',
            'header-style-3' => get_template_directory_uri() . '/inc/img/header/header-3.png',
            'header-style-4' => get_template_directory_uri() . '/inc/img/header/header-4.png',
        ],
    ];
  
    $fields[] = [
        'type'        => 'image',
        'settings'    => 'logo',
        'label'       => esc_html__( 'Header Logo', 'epixx' ),
        'description' => esc_html__( 'Upload Your Logo.', 'epixx' ),
        'section'     => 'section_header_logo',
        'default'     => get_template_directory_uri() . '/assets/img/logo/logo.png',
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'seconday_logo',
        'label'       => esc_html__( 'Header Secondary Logo', 'epixx' ),
        'description' => esc_html__( 'Header Logo Black', 'epixx' ),
        'section'     => 'section_header_logo',
        'default'     => get_template_directory_uri() . '/assets/img/logo/logo-white.png',
    ];

    $fields[] = [
        'type'        => 'slider',
        'settings'    => 'epixx_logo_size',
        'label'       => esc_html__( 'Header Logo Size', 'epixx' ),
        'description' => esc_html__( 'Header Logo Size', 'epixx' ),
        'section'     => 'section_header_logo',
        'default' => '120px',
        'choices'     => [
            'min'  => 100,
            'max'  => 400,
            'step' => 4,
        ],
    ];


    return $fields;
}
add_filter( 'kirki/fields', '_header_header_fields' );

/*
Header Side Info
 */
function _header_side_fields( $fields ) {
    // side info settings
    $fields[] = [
        'type'     => 'switch',
        'settings' => 'epixx_side_hide',
        'label'    => esc_html__( 'Side Info On/Off', 'epixx' ),
        'section'  => 'header_side_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'epixx' ),
            'off' => esc_html__( 'Disable', 'epixx' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'epixx_sideinfo_content_switch',
        'label'    => esc_html__( 'Side Information On/Off', 'epixx' ),
        'section'  => 'header_side_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'epixx' ),
            'off' => esc_html__( 'Disable', 'epixx' ),
        ],
    ];
    $fields[] = [
        'type'        => 'image',
        'settings'    => 'epixx_side_logo',
        'label'       => esc_html__( 'Logo Side', 'epixx' ),
        'description' => esc_html__( 'Logo Side', 'epixx' ),
        'section'     => 'header_side_setting',
        'default'     => get_template_directory_uri() . '/assets/img/logo/logo-black.png',
    ];

    // contact
    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_contact_title',
        'label'    => esc_html__( 'Contact Title', 'epixx' ),
        'section'  => 'header_side_setting',
        'default'  => esc_html__( 'Contact Info', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'epixx_sideinfo_content_switch',
                'operator' => '==',
                'value'    => true,
            ]
        ],
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_extra_address',
        'label'    => esc_html__( 'Office Address', 'epixx' ),
        'section'  => 'header_side_setting',
        'default'  => esc_html__( '123/A, Miranda City Tower, NYC', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'epixx_sideinfo_content_switch',
                'operator' => '==',
                'value'    => true,
            ]
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_extra_phone_number',
        'label'    => esc_html__( 'Contract Number', 'epixx' ),
        'section'  => 'header_side_setting',
        'default'  => esc_html__( '+876 864 764 764', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'epixx_sideinfo_content_switch',
                'operator' => '==',
                'value'    => true,
            ]
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_extra_phone_url',
        'label'    => esc_html__( 'Contract URL', 'epixx' ),
        'section'  => 'header_side_setting',
        'default'  => esc_html__( '+876864764764', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'epixx_sideinfo_content_switch',
                'operator' => '==',
                'value'    => true,
            ]
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_extra_email',
        'label'    => esc_html__( 'Email Address', 'epixx' ),
        'section'  => 'header_side_setting',
        'default'  => esc_html__( 'admin@gmail.com', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'epixx_sideinfo_content_switch',
                'operator' => '==',
                'value'    => true,
            ]
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'epixx_side_social_switch',
        'label'    => esc_html__( 'Side Social On/Off', 'epixx' ),
        'section'  => 'header_side_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'epixx' ),
            'off' => esc_html__( 'Disable', 'epixx' ),
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_side_fb_url',
        'label'    => esc_html__( 'Facebook URL', 'epixx' ),
        'section'  => 'header_side_setting',
        'default'  => esc_html__( '#', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'epixx_side_social_switch',
                'operator' => '==',
                'value'    => true,
            ]
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_side_twitter_url',
        'label'    => esc_html__( 'Twitter URL', 'epixx' ),
        'section'  => 'header_side_setting',
        'default'  => esc_html__( '#', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'epixx_side_social_switch',
                'operator' => '==',
                'value'    => true,
            ]
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_side_instagram_url',
        'label'    => esc_html__( 'Instagram URL', 'epixx' ),
        'section'  => 'header_side_setting',
        'default'  => esc_html__( '#', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'epixx_side_social_switch',
                'operator' => '==',
                'value'    => true,
            ]
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_side_linkedin_url',
        'label'    => esc_html__( 'Linkedin URL', 'epixx' ),
        'section'  => 'header_side_setting',
        'default'  => esc_html__( '#', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'epixx_side_social_switch',
                'operator' => '==',
                'value'    => true,
            ]
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_side_youtube_url',
        'label'    => esc_html__( 'Youtube URL', 'epixx' ),
        'section'  => 'header_side_setting',
        'default'  => esc_html__( '#', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'epixx_side_social_switch',
                'operator' => '==',
                'value'    => true,
            ]
        ],
    ];


    return $fields;
}
add_filter( 'kirki/fields', '_header_side_fields' );

/*
_header_page_title_fields
 */
function _header_page_title_fields( $fields ) {
    // Breadcrumb Setting

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'breadcrumb_bg_img',
        'label'       => esc_html__( 'Breadcrumb Background Image', 'epixx' ),
        'description' => esc_html__( 'Breadcrumb Background Image', 'epixx' ),
        'section'     => 'breadcrumb_setting',
        'default'     => get_template_directory_uri() . '/assets/img/page-title/page-title.jpg',
    ];
    $fields[] = [
        'type'        => 'color',
        'settings'    => 'epixx_breadcrumb_bg_color',
        'label'       => __( 'Breadcrumb BG Color', 'epixx' ),
        'description' => esc_html__( 'This is a Breadcrumb bg color control.', 'epixx' ),
        'section'     => 'breadcrumb_setting',
        'default'     => '#F6F9FC',
        'priority'    => 10,
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_header_page_title_fields' );

/*
Header Social
 */
function _header_blog_fields( $fields ) {
// Blog Setting
    $fields[] = [
        'type'     => 'switch',
        'settings' => 'epixx_blog_btn_switch',
        'label'    => esc_html__( 'Blog BTN On/Off', 'epixx' ),
        'section'  => 'blog_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'epixx' ),
            'off' => esc_html__( 'Disable', 'epixx' ),
        ],
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_blog_btn',
        'label'    => esc_html__( 'Blog Button text', 'epixx' ),
        'section'  => 'blog_setting',
        'default'  => esc_html__( 'Read More', 'epixx' ),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_blog_btn_rtl',
        'label'    => esc_html__( 'Blog Button text rtl', 'epixx' ),
        'section'  => 'blog_setting',
        'default'  => esc_html__( 'Read More', 'epixx' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'breadcrumb_blog_title',
        'label'    => esc_html__( 'Blog Title', 'epixx' ),
        'section'  => 'blog_setting',
        'default'  => esc_html__( 'Blog', 'epixx' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'breadcrumb_blog_title_details',
        'label'    => esc_html__( 'Blog Details Title', 'epixx' ),
        'section'  => 'blog_setting',
        'default'  => esc_html__( 'Blog Details', 'epixx' ),
        'priority' => 10,
    ];
    return $fields;
}
add_filter( 'kirki/fields', '_header_blog_fields' );

/*
Footer
 */
function _header_footer_fields( $fields ) {
    // Footer Setting
    $fields[] = [
        'type'        => 'radio-image',
        'settings'    => 'choose_default_footer',
        'label'       => esc_html__( 'Choose Footer Style', 'epixx' ),
        'section'     => 'footer_setting',
        'default'     => 'footer-style-1',
        'placeholder' => esc_html__( 'Select an option...', 'epixx' ),
        'priority'    => 10,
        'multiple'    => 1,
        'choices'     => [
            'footer-style-1' => get_template_directory_uri() . '/inc/img/footer/footer-1.png',
            'footer-style-2' => get_template_directory_uri() . '/inc/img/footer/footer-2.png',
            'footer-style-3' => get_template_directory_uri() . '/inc/img/footer/footer-3.png',
            'footer-style-4' => get_template_directory_uri() . '/inc/img/footer/footer-4.png',
        ],
    ];

    $fields[] = [
        'type'        => 'select',
        'settings'    => 'footer_widget_number',
        'label'       => esc_html__( 'Widget Number', 'epixx' ),
        'section'     => 'footer_setting',
        'default'     => '5',
        'placeholder' => esc_html__( 'Select an option...', 'epixx' ),
        'priority'    => 10,
        'multiple'    => 1,
        'choices'     => [
            '5' => esc_html__( 'Widget Number 5', 'epixx' ),
            '4' => esc_html__( 'Widget Number 4', 'epixx' ),
            '3' => esc_html__( 'Widget Number 3', 'epixx' ),
            '2' => esc_html__( 'Widget Number 2', 'epixx' ),
        ],
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'epixx_footer_logo',
        'label'       => esc_html__( 'Footer Logo', 'epixx' ),
        'description' => esc_html__( 'Upload Your Logo.', 'epixx' ),
        'section'     => 'footer_setting',
        'default'     => get_template_directory_uri() . '/assets/img/logo/logo-white.png',
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'epixx_footer_bg',
        'label'       => esc_html__( 'Footer Background Image.', 'epixx' ),
        'description' => esc_html__( 'Footer Background Image.', 'epixx' ),
        'section'     => 'footer_setting',
    ];

    $fields[] = [
        'type'        => 'color',
        'settings'    => 'epixx_footer_bg_color',
        'label'       => __( 'Footer BG Color', 'epixx' ),
        'description' => esc_html__( 'This is a Footer bg color control.', 'epixx' ),
        'section'     => 'footer_setting',
        'default'     => '#0f0f0f',
        'priority'    => 10,
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'footer_style_2_switch',
        'label'    => esc_html__( 'Footer Style 2 On/Off', 'epixx' ),
        'section'  => 'footer_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'epixx' ),
            'off' => esc_html__( 'Disable', 'epixx' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'footer_style_3_switch',
        'label'    => esc_html__( 'Footer Style 3 On/Off', 'epixx' ),
        'section'  => 'footer_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'epixx' ),
            'off' => esc_html__( 'Disable', 'epixx' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'footer_style_4_switch',
        'label'    => esc_html__( 'Footer Style 4 On/Off', 'epixx' ),
        'section'  => 'footer_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'epixx' ),
            'off' => esc_html__( 'Disable', 'epixx' ),
        ],
    ];


    $fields[] = [
        'type'     => 'switch',
        'settings' => 'footer_style_4_top_switch',
        'label'    => esc_html__( 'Footer Style 4 Top On/Off', 'epixx' ),
        'section'  => 'footer_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'epixx' ),
            'off' => esc_html__( 'Disable', 'epixx' ),
        ],
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'epixx_footer_cards',
        'label'       => esc_html__( 'Footer cards', 'epixx' ),
        'description' => esc_html__( 'Upload cards', 'epixx' ),
        'section'     => 'footer_setting',
        'default'     => get_template_directory_uri() . '/assets/img/icon/payment.png',
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_footer_cell_number',
        'label'    => esc_html__( 'Footer Cell number', 'epixx' ),
        'section'  => 'footer_setting',
        'default'  => esc_html__( '(+08) 1562 4278 80', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'footer_style_4_top_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],

    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_footer_cell_url',
        'label'    => esc_html__( 'Footer Cell url', 'epixx' ),
        'section'  => 'footer_setting',
        'default'  => esc_html__( '(+08)1562427880', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'footer_style_4_top_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],

    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_footer_office_hour',
        'label'    => esc_html__( 'Office Running Hour', 'epixx' ),
        'section'  => 'footer_setting',
        'default'  => esc_html__( 'Mon - Fri: 8:00 - 21:00 Sat - Sun: 9:00 - 18:00', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'footer_style_4_top_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],

    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_footer_send_button',
        'label'    => esc_html__( 'Button Text', 'epixx' ),
        'section'  => 'footer_setting',
        'default'  => esc_html__( 'SEND MESSAGE', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'footer_style_4_top_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],

    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_footer_send_button_url',
        'label'    => esc_html__( 'Button Text URL', 'epixx' ),
        'section'  => 'footer_setting',
        'default'  => esc_html__( '#', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'footer_style_4_top_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],

    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_footer_live_button',
        'label'    => esc_html__( 'Button Text', 'epixx' ),
        'section'  => 'footer_setting',
        'default'  => esc_html__( 'LIVE CHAT', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'footer_style_4_top_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],

    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_footer_live_button_url',
        'label'    => esc_html__( 'Button Text URL', 'epixx' ),
        'section'  => 'footer_setting',
        'default'  => esc_html__( '#', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'footer_style_4_top_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],

    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'footer_social_switch',
        'label'    => esc_html__( 'Footer Social On/Off', 'epixx' ),
        'section'  => 'footer_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'epixx' ),
            'off' => esc_html__( 'Disable', 'epixx' ),
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_footer_fb_url',
        'label'    => esc_html__( 'Facebook Url', 'epixx' ),
        'section'  => 'footer_setting',
        'default'  => esc_html__( '#', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'footer_social_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],

    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_footer_twitter_url',
        'label'    => esc_html__( 'Twitter Url', 'epixx' ),
        'section'  => 'footer_setting',
        'default'  => esc_html__( '#', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'footer_social_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],

    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_footer_instagram_url',
        'label'    => esc_html__( 'Instagram Url', 'epixx' ),
        'section'  => 'footer_setting',
        'default'  => esc_html__( '#', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'footer_social_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],

    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_footer_linkedin_url',
        'label'    => esc_html__( 'Linkedin Url', 'epixx' ),
        'section'  => 'footer_setting',
        'default'  => esc_html__( '#', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'footer_social_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],

    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_footer_youtube_url',
        'label'    => esc_html__( 'Youtube Url', 'epixx' ),
        'section'  => 'footer_setting',
        'default'  => esc_html__( '#', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'footer_social_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],

    ];


    $fields[] = [
        'type'     => 'switch',
        'settings' => 'footer_copyright_switch',
        'label'    => esc_html__( 'Footer Copyright On/Off', 'epixx' ),
        'section'  => 'footer_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'epixx' ),
            'off' => esc_html__( 'Disable', 'epixx' ),
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_copyright',
        'label'    => esc_html__( 'Copy Right', 'epixx' ),
        'section'  => 'footer_setting',
        'default'  => esc_html__( 'Copyright &copy; 2022 Bdevs. All Rights Reserved', 'epixx' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'footer_copyright_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];
    return $fields;
}
add_filter( 'kirki/fields', '_header_footer_fields' );

// color
function epixx_color_fields( $fields ) {
    // Color Settings
    $fields[] = [
        'type'        => 'color',
        'settings'    => 'epixx_color_option',
        'label'       => __( 'Theme Color', 'epixx' ),
        'description' => esc_html__( 'This is a Theme color control.', 'epixx' ),
        'section'     => 'color_setting',
        'default'     => '#007eff',
        'priority'    => 10,
    ];
    $fields[] = [
        'type'        => 'color',
        'settings'    => 'epixx_color_option_border',
        'label'       => __( 'Header Border Color', 'epixx' ),
        'description' => esc_html__( 'This is a Border color control.', 'epixx' ),
        'section'     => 'color_setting',
        'default'     => '#3398ff',
        'priority'    => 10,
    ];

    return $fields;
}
add_filter( 'kirki/fields', 'epixx_color_fields' );

// 404
function epixx_404_fields( $fields ) {
    // 404 settings
    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_error_404_text',
        'label'    => esc_html__( '400 Text', 'epixx' ),
        'section'  => '404_page',
        'default'  => esc_html__( '404', 'epixx' ),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_error_title',
        'label'    => esc_html__( 'Not Found Title', 'epixx' ),
        'section'  => '404_page',
        'default'  => esc_html__( 'Page not found', 'epixx' ),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'textarea',
        'settings' => 'epixx_error_desc',
        'label'    => esc_html__( '404 Description Text', 'epixx' ),
        'section'  => '404_page',
        'default'  => esc_html__( 'Oops! The page you are looking for does not exist. It might have been moved or deleted', 'epixx' ),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'epixx_error_link_text',
        'label'    => esc_html__( '404 Link Text', 'epixx' ),
        'section'  => '404_page',
        'default'  => esc_html__( 'Back To Home', 'epixx' ),
        'priority' => 10,
    ];
    return $fields;

}
add_filter( 'kirki/fields', 'epixx_404_fields' );

/**
 * Added Fields
 */

function epixx_typo_fields( $fields ) {
    // typography settings
    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_body_setting',
        'label'       => esc_html__( 'Body Font', 'epixx' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => 'Inter',
            'variant'        => 'regular',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'body',
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_h_setting',
        'label'       => esc_html__( 'Heading Fonts', 'epixx' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => 'Inter',
            'variant'        => 'bold',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'h1,h2,h3,h4,h5,h6',
            ],
        ],
    ];
    return $fields;
}

add_filter( 'kirki/fields', 'epixx_typo_fields' );

/**
 * This is a short hand function for getting setting value from customizer
 *
 * @param string $name
 *
 * @return bool|string
 */
function EPIXX_THEME_option( $name ) {
    $value = '';
    if ( class_exists( 'epixx' ) ) {
        $value = Kirki::get_option( epixx_get_theme(), $name );
    }

    return apply_filters( 'EPIXX_THEME_option', $value, $name );
}

/**
 * Get config ID
 *
 * @return string
 */
function epixx_get_theme() {
    return 'epixx';
}