<?php
/**
 * Custom template tags for this theme
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package epixx
 */

/**
 *
 * epixx header
 */

function epixx_check_header() {
    $epixx_header_style = function_exists( 'get_field' ) ? get_field( 'header_style' ) : NULL;
    $epixx_default_header_style = get_theme_mod( 'choose_default_header', 'header-style-1' );

    if ( $epixx_header_style == 'header-style-1' ) {
        epixx_header_style_1();
    } 
    elseif ( $epixx_header_style == 'header-style-2' ) {
        epixx_header_style_2();
    } 
    elseif ( $epixx_header_style == 'header-style-3' ) {
        epixx_header_style_3();
    } 
    elseif ( $epixx_header_style == 'header-style-4' ) {
        epixx_header_style_4();
    } 
    else {

        /** default header style **/
        if ( $epixx_default_header_style == 'header-style-2' ) {
            epixx_header_style_2();
        } 
        elseif ( $epixx_default_header_style == 'header-style-3' ) {
            epixx_header_style_3();
        }
        elseif ( $epixx_default_header_style == 'header-style-4' ) {
            epixx_header_style_4();
        }
        else {
            epixx_header_style_1();
        }
    }

}
add_action( 'epixx_header_style', 'epixx_check_header', 10 );


// Header deafult
function epixx_header_style_1() {

    $epixx_button_text = get_theme_mod( 'epixx_button_text', __( 'Try For Free', 'epixx' ) );
    $epixx_button_link = get_theme_mod( 'epixx_button_link', __( '#', 'epixx' ) );

    $epixx_topbar_switch = get_theme_mod( 'epixx_topbar_switch', false );
    $epixx_header_lang = get_theme_mod( 'epixx_header_lang', false );

    $epixx_header_contract_switch = get_theme_mod( 'epixx_header_contract_switch', false );
    $epixx_header_top_phone = get_theme_mod( 'epixx_header_top_phone', __( '18000 344 585', 'epixx' ) );
    $epixx_header_top_phone_url = get_theme_mod( 'epixx_header_top_phone_url', __('18000344585', 'epixx') );
    
    $epixx_login_reg_switch = get_theme_mod( 'epixx_login_reg_switch', false );
    $epixx_trackorder_switch = get_theme_mod( 'epixx_trackorder_switch', false );
    $epixx_track_link = get_theme_mod( 'epixx_track_link', __('/wp/epixx/contact/', 'epixx') );
    

    $epixx_whishlist_switch = get_theme_mod( 'epixx_whishlist_switch', false );
    $epixx_wishlist_link = get_theme_mod( 'epixx_wishlist_link', __('/wp/epixx/wishlist/', 'epixx') );

    $epixx_cart_switch = get_theme_mod( 'epixx_cart_switch', false );

    $epixx_header_right = get_theme_mod( 'epixx_header_right', false );

    $epixx_worldwide_img = get_theme_mod( 'epixx_worldwide_img', __(get_template_directory_uri() . '/assets/img/icon/world.png', 'epixx') );
    $epixx_worldwide_text = get_theme_mod( 'epixx_worldwide_text', __('World Wide', 'epixx') );
    $epixx_freeshipping_text = get_theme_mod( 'epixx_freeshipping_text', __('Free Shipping', 'epixx') );
    $epixx_worldwide_link = get_theme_mod( 'epixx_worldwide_link', __('#', 'epixx') );

    $epixx_support_img = get_theme_mod( 'epixx_support_img', __(get_template_directory_uri() . '/assets/img/icon/world.png', 'epixx') );
    $epixx_support_text = get_theme_mod( 'epixx_support_text', __('24 Support', 'epixx') );
    $epixx_phoneright_text = get_theme_mod( 'epixx_phoneright_text', __('+1800 453 856', 'epixx') );
    $epixx_phoneright_url = get_theme_mod( 'epixx_phoneright_url', __('+1800453856', 'epixx') );


    $epixx_search = get_theme_mod( 'epixx_search', false );
    $epixx_menu_col = $epixx_header_right ? 'col-lg-8 text-center' : 'col-lg-10 text-end';
    $epixx_header_right = $epixx_header_right ? 'col-lg-2' : 'd-none';

    if ( rtl_enable() ) {
        $btn_text = get_theme_mod( 'epixx_button_text_rtl', __( 'Get A Quote', 'epixx' ) );
    } else {
        $btn_text = get_theme_mod( 'epixx_button_text', __( 'Get A Quote', 'epixx' ) );
    }

    $btn_link = get_theme_mod( 'epixx_button_link', __( '#', 'epixx' ) );

    ?>

    <!-- header area start -->
    <header class="header-area d-none d-lg-block">
        <!-- /. header top 2 -->
        <div class="header-bottom header-bottom-2 p-rel header_extended_default">
            <div class="container p-rel">
                <div class="row align-items-center">
                    <div class="col-lg-2">
                        <div class="logo-2">
                            <?php epixx_header_logo(); ?>
                        </div>
                    </div>
                    <div class="<?php print esc_attr($epixx_menu_col); ?>">
                        <div class="header-nav">
                            <nav id="mobile-menu" class="white-list">
                                <?php epixx_header_menu(); ?>
                            </nav>
                        </div>
                    </div>
                    <div class="<?php print esc_attr($epixx_header_right); ?>">
                        <div class="header-right-2 text-end">

                          <ul>

                            <?php if (!empty($epixx_whishlist_switch) && EPIXX_WISHLIST_ACTIVED): ?>
                             <li class="epix-action-single epix-action-single-2">
                            <a href="<?php print esc_url($epixx_wishlist_link); ?>">
                             <span class="icon">
                                <i class="fal fa-heart"></i>
                                <span><?php echo yith_wcwl_count_all_products(); ?></span>
                             </span></a>
                            </li>
                            <?php endif; ?>

                            <?php if (EPIXX_WOOCOMMERCE_ACTIVED && !empty($epixx_cart_switch)): ?>
                             <li class="epixx_shop_cart header-shop-cart epix-action-single epix-action-single-2">
                            <a href="javascript:void()" class="header-cart-3">
                               <span class="icon">
                                  <i class="fal fa-shopping-bag"></i>
                                  <span class="icon_count"><?php echo esc_html(WC()->cart->cart_contents_count); ?></span>
                               </span>
                            </a>
                             <?php print epixx_shopping_cart(); ?>
                            </li>
                            <?php endif; ?>
                             
                            </ul>


                        </div>
                        <!-- /. header right -->
                    </div>
                    
                </div>
            </div>
        </div>
        <!-- /. header bottom -->
    </header>
    <!-- header area end -->
    <div class="mobile-header d-lg-none">
        <div class="container">
            <div class="row">
                <div class="col-6">
                    <div class="logo">
                        <?php epixx_header_logo(); ?>
                    </div>
                </div>
                <div class="col-6">
                    <div class="bar-icon text-end">
                        <button class="toggle-nav-menu sidebar-menu-toggle">
                            <i class="fal fa-bars"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- /. mobile header -->

    
   <!-- side info start -->

   <?php epixx_side_info(); ?>
   <!-- side info end -->     
   <div class="offcanvas-overlay"></div>
   <!-- sidebar area end -->

<?php
}


/**
 * header style 2
 */
 function epixx_header_style_2() {

    $epixx_button_text = get_theme_mod( 'epixx_button_text', __( 'Try For Free', 'epixx' ) );
    $epixx_button_link = get_theme_mod( 'epixx_button_link', __( '#', 'epixx' ) );

    $epixx_topbar_switch = get_theme_mod( 'epixx_topbar_switch', false );
    $epixx_header_lang = get_theme_mod( 'epixx_header_lang', false );

    $epixx_header_contract_switch = get_theme_mod( 'epixx_header_contract_switch', false );
    $epixx_header_top_phone = get_theme_mod( 'epixx_header_top_phone', __( '18000 344 585', 'epixx' ) );
    $epixx_header_top_phone_url = get_theme_mod( 'epixx_header_top_phone_url', __('18000344585', 'epixx') );
    
    $epixx_login_reg_switch = get_theme_mod( 'epixx_login_reg_switch', false );
    $epixx_trackorder_switch = get_theme_mod( 'epixx_trackorder_switch', false );
    $epixx_track_link = get_theme_mod( 'epixx_track_link', __('/wp/epixx/contact/', 'epixx') );

    $epixx_whishlist_switch = get_theme_mod( 'epixx_whishlist_switch', false );
    $epixx_wishlist_link = get_theme_mod( 'epixx_wishlist_link', __('/wp/epixx/wishlist/', 'epixx') );

    $epixx_cart_switch = get_theme_mod( 'epixx_cart_switch', false );

    $epixx_header_right = get_theme_mod( 'epixx_header_right', false );

    $epixx_worldwide_img = get_theme_mod( 'epixx_worldwide_img', __(get_template_directory_uri() . '/assets/img/icon/world.png', 'epixx') );
    $epixx_worldwide_text = get_theme_mod( 'epixx_worldwide_text', __('World Wide', 'epixx') );
    $epixx_freeshipping_text = get_theme_mod( 'epixx_freeshipping_text', __('Free Shipping', 'epixx') );
    $epixx_worldwide_link = get_theme_mod( 'epixx_worldwide_link', __('#', 'epixx') );

    $epixx_support_img = get_theme_mod( 'epixx_support_img', __(get_template_directory_uri() . '/assets/img/icon/world.png', 'epixx') );
    $epixx_support_text = get_theme_mod( 'epixx_support_text', __('24 Support', 'epixx') );
    $epixx_phoneright_text = get_theme_mod( 'epixx_phoneright_text', __('+1800 453 856', 'epixx') );
    $epixx_phoneright_url = get_theme_mod( 'epixx_phoneright_url', __('+1800453856', 'epixx') );


    $epixx_search = get_theme_mod( 'epixx_search', false );

    $epixx_menu_col = $epixx_header_right ? 'col-lg-9' : 'col-lg-12 text-center';
    $epixx_header_right = $epixx_header_right ? 'col-lg-3' : 'd-none';

    if ( rtl_enable() ) {
        $btn_text = get_theme_mod( 'epixx_button_text_rtl', __( 'Get A Quote', 'epixx' ) );
    } else {
        $btn_text = get_theme_mod( 'epixx_button_text', __( 'Get A Quote', 'epixx' ) );
    }

    $btn_link = get_theme_mod( 'epixx_button_link', __( '#', 'epixx' ) );

    ?>

    <!-- header area start -->
    <header>
        <div class="header-area bg-black-2 d-none d-lg-block">
            <?php if( !empty($epixx_topbar_switch) ) : ?>
            <div class="header-top-2">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-xxl-3 col-lg-3">
                            <div class="header-left-2">
                                <div class="logo-2">
                                    <?php epixx_header_logo(); ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-xxl-9 col-lg-9">
                            <div class="header-right-2 text-end">
                                <div class="epix-header-list-2 d-inline-block">
                                    <ul>
                                       <?php if( !empty($epixx_header_contract_switch) ) : ?>
                                        <li>
                                          <?php if( !empty( $epixx_header_top_phone ) ) : ?>
                                          <a href="tel:<?php print esc_url($epixx_header_top_phone_url); ?>"><i class="fal fa-headphones-alt"></i> <strong><?php print esc_html( $epixx_header_top_phone ); ?></strong></a>
                                          <?php endif; ?>
                                       </li>
                                       <?php endif; ?>

                                       <?php if (!empty($epixx_login_reg_switch) && EPIXX_WOOCOMMERCE_ACTIVED): ?>
                                       <li class="epixx_account">
                                       <?php if (is_user_logged_in()): ?>
                                          <a href="<?php echo get_permalink(wc_get_page_id('myaccount')); ?>"><i class="fal fa-user"></i> <?php print esc_html__('My Account', 'epixx'); ?></a>
                                       <?php else: ?>
                                          <a href="<?php echo wp_logout_url(get_permalink(wc_get_page_id('myaccount'))) ?>"><i class="fal fa-user"></i> <?php print esc_html__('Login/Register', 'epixx'); ?></a>
                                       <?php endif; ?>
                                       </li>
                                       <?php endif; ?>

                                       <?php if( !empty($epixx_trackorder_switch) ) : ?>
                                        <li><a href="<?php print esc_url($epixx_track_link); ?>"><?php print esc_html__('Track Order', 'epixx'); ?></a></li>
                                       <?php endif; ?>

                                    </ul>
                                </div>
                                <div class="epix-header-form-2 d-inline-block ml-30">
                                    <form action="<?php echo home_url( '/' ); ?>">
                                       <input type="hidden" name="post_type" value="product">
                                        <input type="search" 
                                        placeholder="<?php print esc_attr__('Search anything here..', 'epixx'); ?>"
                                        name="s"
                                        value="<?php print esc_attr(get_search_query()); ?>">
                                        <button type="submit"><i class="fal fa-search"></i></button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            <!-- /. header top 2 -->
            <div class="header-bottom header-bottom-2 p-rel">
                <div class="container p-rel">
                    <div class="row align-items-center">
                        <div class="<?php print esc_attr($epixx_menu_col); ?>">
                            <div class="header-nav">
                                <nav id="mobile-menu" class="white-list">
                                    <?php epixx_header_menu(); ?>
                                </nav>
                            </div>
                        </div>
                        <div class="<?php print esc_attr($epixx_header_right); ?>">
                            <div class="header-right-2 text-end">

                              <ul>

                                <?php if (!empty($epixx_whishlist_switch) && EPIXX_WISHLIST_ACTIVED): ?>
                                 <li class="epix-action-single epix-action-single-2">
                                <a href="<?php print esc_url($epixx_wishlist_link); ?>">
                                 <span class="icon">
                                    <i class="fal fa-heart"></i>
                                    <span><?php echo yith_wcwl_count_all_products(); ?></span>
                                 </span></a>
                                </li>
                                <?php endif; ?>

                                <?php if (EPIXX_WOOCOMMERCE_ACTIVED && !empty($epixx_cart_switch)): ?>
                                 <li class="epixx_shop_cart header-shop-cart epix-action-single epix-action-single-2">
                                <a href="javascript:void()" class="header-cart-3">
                                   <span class="icon">
                                      <i class="fal fa-shopping-bag"></i>
                                      <span class="icon_count"><?php echo esc_html(WC()->cart->cart_contents_count); ?></span>
                                   </span>
                                </a>
                                 <?php print epixx_shopping_cart(); ?>
                                </li>
                                <?php endif; ?>
                                 
                                </ul>


                            </div>
                            <!-- /. header right -->
                        </div>
                    </div>
                </div>
            </div>
            <!-- /. header bottom -->
        </div>

        <div class="mobile-header d-lg-none">
            <div class="container">
                <div class="row">
                    <div class="col-6">
                        <div class="logo">
                            <?php epixx_mobile_logo(); ?>
                            
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="bar-icon text-end">
                            <button class="toggle-nav-menu sidebar-menu-toggle">
                                <i class="fal fa-bars"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- /. mobile header -->
    </header>
    <!-- header area end -->
    
   <!-- side info start -->    
   <?php epixx_side_info(); ?>
   <!-- side info end -->     
   <div class="offcanvas-overlay"></div>
   <!-- sidebar area end -->

<?php
}

/**
 * header style 3
 */
 function epixx_header_style_3() {

    $epixx_button_text = get_theme_mod( 'epixx_button_text', __( 'Try For Free', 'epixx' ) );
    $epixx_button_link = get_theme_mod( 'epixx_button_link', __( '#', 'epixx' ) );

    $epixx_topbar_switch = get_theme_mod( 'epixx_topbar_switch', false );
    $epixx_header_lang = get_theme_mod( 'epixx_header_lang', false );

    $epixx_header_contract_switch = get_theme_mod( 'epixx_header_contract_switch', false );
    $epixx_header_top_phone = get_theme_mod( 'epixx_header_top_phone', __( '18000 344 585', 'epixx' ) );
    $epixx_header_top_phone_url = get_theme_mod( 'epixx_header_top_phone_url', __('18000344585', 'epixx') );
    
    $epixx_login_reg_switch = get_theme_mod( 'epixx_login_reg_switch', false );
    $epixx_trackorder_switch = get_theme_mod( 'epixx_trackorder_switch', false );
    $epixx_track_link = get_theme_mod( 'epixx_track_link', __('/wp/epixx/contact/', 'epixx') );

    $epixx_whishlist_switch = get_theme_mod( 'epixx_whishlist_switch', false );
    $epixx_wishlist_link = get_theme_mod( 'epixx_wishlist_link', __('/wp/epixx/wishlist/', 'epixx') );

    $epixx_cart_switch = get_theme_mod( 'epixx_cart_switch', false );

    $epixx_header_right = get_theme_mod( 'epixx_header_right', false );

    $epixx_worldwide_img = get_theme_mod( 'epixx_worldwide_img', __(get_template_directory_uri() . '/assets/img/icon/world.png', 'epixx') );
    $epixx_worldwide_text = get_theme_mod( 'epixx_worldwide_text', __('World Wide', 'epixx') );
    $epixx_freeshipping_text = get_theme_mod( 'epixx_freeshipping_text', __('Free Shipping', 'epixx') );
    $epixx_worldwide_link = get_theme_mod( 'epixx_worldwide_link', __('#', 'epixx') );

    $epixx_support_img = get_theme_mod( 'epixx_support_img', __(get_template_directory_uri() . '/assets/img/icon/world.png', 'epixx') );
    $epixx_support_text = get_theme_mod( 'epixx_support_text', __('24 Support', 'epixx') );
    $epixx_phoneright_text = get_theme_mod( 'epixx_phoneright_text', __('+1800 453 856', 'epixx') );
    $epixx_phoneright_url = get_theme_mod( 'epixx_phoneright_url', __('+1800453856', 'epixx') );


    $epixx_search = get_theme_mod( 'epixx_search', false );

    $epixx_header_social_switch = get_theme_mod( 'epixx_header_social_switch', false );
    $epixx_topbar_fb_url = get_theme_mod( 'epixx_topbar_fb_url', __('#', 'epixx') );
    $epixx_topbar_twitter_url = get_theme_mod( 'epixx_topbar_twitter_url', __('#', 'epixx') );
    $epixx_topbar_linkedin_url = get_theme_mod( 'epixx_topbar_linkedin_url', __('#', 'epixx') );
    $epixx_topbar_instagram_url = get_theme_mod( 'epixx_topbar_instagram_url', __('#', 'epixx') );
    $epixx_topbar_pinterest_url = get_theme_mod( 'epixx_topbar_pinterest_url', __('#', 'epixx') );
    $epixx_topbar_whatsapp_url = get_theme_mod( 'epixx_topbar_whatsapp_url', __('#', 'epixx') );

    $epixx_menu_col = $epixx_header_right ? 'col-lg-9' : 'col-lg-12 text-center';
    $epixx_header_right = $epixx_header_right ? 'col-lg-3' : 'd-none';

    if ( rtl_enable() ) {
        $btn_text = get_theme_mod( 'epixx_button_text_rtl', __( 'Get A Quote', 'epixx' ) );
    } else {
        $btn_text = get_theme_mod( 'epixx_button_text', __( 'Get A Quote', 'epixx' ) );
    }

    $btn_link = get_theme_mod( 'epixx_button_link', __( '#', 'epixx' ) );

    ?>

    <!-- header area start -->
    <header>
        <div class="header-area theme-bg header-1 d-none d-lg-block">
          <div class="header-top">
            <div class="container">
              <div class="row align-items-center">
                <div class="col-xxl-6 col-xl-6 col-lg-6">
                  <div class="header-nav epix-top-menu">
                    <nav id="mobile-menu">
                        <?php epixx_header_top_menu(); ?>
                    </nav>
                  </div>
                  <!-- /. header left -->
                </div>
                <div class="col-xxl-6 col-xl-6 col-lg-6">
                  <div class="text-end">
                    <div class="epix-t-right">
                      <div class="ht-actions">
                        <?php if (!empty($epixx_login_reg_switch) && EPIXX_WOOCOMMERCE_ACTIVED): ?>
                            <?php if (is_user_logged_in()): ?>
                              <a href="<?php echo get_permalink(wc_get_page_id('myaccount')); ?>"><i class="fal fa-user"></i> <?php print esc_html__('My Account', 'epixx'); ?></a>
                           <?php else: ?>
                              <a href="<?php echo wp_logout_url(get_permalink(wc_get_page_id('myaccount'))) ?>"><i class="fal fa-user"></i> <?php print esc_html__('Login/Register', 'epixx'); ?></a>
                           <?php endif; ?>
                        <?php endif; ?>

                        <?php if( !empty($epixx_trackorder_switch) ) : ?>
                            <a href="<?php print esc_url($epixx_track_link); ?>"><?php print esc_html__('Track Order', 'epixx'); ?></a>
                        <?php endif; ?>

                      </div>

                      <?php if( !empty($epixx_header_social_switch) ) : ?>
                      <div class="epix-ht-social">
                        <?php if( !empty($epixx_topbar_fb_url) ) : ?>
                        <a href="<?php print esc_url($epixx_topbar_fb_url); ?>"><i class="fab fa-facebook-f"></i></a>
                        <?php endif; ?>
                        <?php if( !empty($epixx_topbar_twitter_url) ) : ?>
                        <a href="<?php print esc_url($epixx_topbar_twitter_url); ?>"><i class="fab fa-twitter"></i></a>
                        <?php endif; ?>
                        <?php if( !empty($epixx_topbar_instagram_url) ) : ?>
                        <a href="<?php print esc_url($epixx_topbar_instagram_url); ?>"><i class="fab fa-instagram"></i></a>
                        <?php endif; ?>
                        <?php if( !empty($epixx_topbar_pinterest_url) ) : ?>
                        <a href="<?php print esc_url($epixx_topbar_pinterest_url); ?>"><i class="fab fa-pinterest"></i></a>
                        <?php endif; ?>
                        <?php if( !empty($epixx_topbar_whatsapp_url) ) : ?>
                        <a href="<?php print esc_url($epixx_topbar_whatsapp_url); ?>"><i class="fab fa-whatsapp"></i></a>
                        <?php endif; ?>
                      </div>
                      <?php endif; ?>

                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="header-middle">
            <div class="container">
              <div class="row align-items-center">
                <div class="col-xxl-2 col-xl-2 col-lg-3">
                  <div class="epix-header-logo">
                    <?php epixx_header_logo(); ?>
                  </div>
                </div>
                <div class="col-xxl-8 col-xl-8 col-lg-6">
                  <div class="epix-header-flex">

                    <div class="epix-side-dropdown d-none d-xl-block">
                      <button class="epix-side-btn epix-side-btn-1">
                        <span class="bars"></span><span class="text"><?php print esc_html__('All Categories', 'epixx'); ?></span><i class="fal fa-angle-down"></i>
                      </button>
                      <?php if (EPIXX_WOOCOMMERCE_ACTIVED): ?>
                      <?php $terms = (!empty(get_terms('product_cat'))) ? get_terms('product_cat') : ''; ?>
                      <ul>
                        <?php foreach( $terms as $term ) : ?>
                        <li><a href="<?php print get_term_link($term->term_id); ?>"><?php print esc_html( $term->name ); ?></a></li>
                        <?php endforeach; ?>
                      </ul>
                      <?php endif; ?>
                    </div>

                    <div class="epix-header-form epix-header-form-1">

                      <form action="<?php echo home_url( '/' ); ?>" method="GET">
                        <input type="hidden" name="post_type" value="product">
                        <input type="search" 
                        placeholder="<?php print esc_attr__('Search anything here..', 'epixx'); ?>" 
                        name="s"
                        value="<?php print esc_attr(get_search_query()); ?>">
                        <button type="submit">
                          <i class="fal fa-search"></i>
                        </button>
                      </form>

                    </div>
                  </div>
                </div>
                <div class="col-xxl-2 col-xl-2 col-lg-3">

                  <div class="epix-header-actions">
                    <?php if (!empty($epixx_whishlist_switch) && EPIXX_WISHLIST_ACTIVED): ?>
                    <div class="epix-action-single">
                      <a href="<?php print esc_url($epixx_wishlist_link); ?>">
                        <div class="icon">
                          <i class="fal fa-heart"></i>
                          <span><?php echo yith_wcwl_count_all_products(); ?></span>
                        </div>
                        <div class="content">
                          <span><?php print esc_html__('Wishlist', 'epixx'); ?></span>
                        </div>
                      </a>
                    </div>
                    <?php endif; ?>
                    <?php if (EPIXX_WOOCOMMERCE_ACTIVED && !empty($epixx_cart_switch)): ?>
                    <div class="epix-action-single epixx_shop_cart header-shop-cart">
                      <a href="javascript:void()">
                        <div class="icon">
                          <i class="fal fa-shopping-cart"></i>
                          <span><?php echo esc_html(WC()->cart->cart_contents_count); ?></span>
                        </div>
                        <div class="content">
                          <span> <?php print esc_html__('Cart', 'epixx'); ?></span>
                        </div>
                      </a>
                      <?php print epixx_shopping_cart(); ?>
                    </div>
                    <?php endif; ?>
                  </div>


                </div>
              </div>
            </div>
          </div>
          <div class="header-bottom p-rel">
            <div class="container p-rel">
              <div class="row align-items-center">
                <div class="<?php print esc_attr($epixx_menu_col); ?>">
                  <div class="header-nav">
                    <nav>
                        <?php epixx_header_menu(); ?>
                    </nav>
                  </div>
                </div>
                <div class="<?php print esc_attr($epixx_header_right); ?>">
                  <div class="header-right text-end">
                    <?php if( !empty($epixx_header_contract_switch) ) : ?>
                    <div class="header-contact">
                      <?php if( !empty($epixx_header_top_phone) ) : ?>
                      <a href="tel:<?php print esc_url($epixx_header_top_phone_url); ?>"><i class="fal fa-headphones"></i> <?php print esc_html($epixx_header_top_phone); ?></a>
                      <?php endif; ?>
                    </div>
                    <?php endif; ?>

                    <?php if( !empty( $epixx_header_lang ) ) : ?>
                    <div class="select-boxes">
                      <?php print epixx_header_lang_defualt(); ?>
                    </div>
                    <?php endif; ?>

                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!-- /. pc header -->
        <div class="mobile-header d-lg-none">
          <div class="container">
            <div class="row">
              <div class="col-6">
                <div class="logo">
                  <?php epixx_mobile_logo(); ?>
                </div>
              </div>
              <div class="col-6">
                <div class="bar-icon text-end">
                  <button class="toggle-nav-menu sidebar-menu-toggle">
                    <i class="fal fa-bars"></i>
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!-- /. mobile header -->
   </header>
    <!-- header area end -->
    


   <!-- side info start -->    
   <?php epixx_side_info(); ?>
   <!-- side info end -->     
   <div class="offcanvas-overlay"></div>
   <!-- sidebar area end -->

<?php
}


// Header style 4
function epixx_header_style_4() {

    $epixx_button_text = get_theme_mod( 'epixx_button_text', __( 'Try For Free', 'epixx' ) );
    $epixx_button_link = get_theme_mod( 'epixx_button_link', __( '#', 'epixx' ) );

    $epixx_topbar_switch = get_theme_mod( 'epixx_topbar_switch', false );
    $epixx_header_lang = get_theme_mod( 'epixx_header_lang', false );

    $epixx_header_contract_switch = get_theme_mod( 'epixx_header_contract_switch', false );
    $epixx_header_top_phone = get_theme_mod( 'epixx_header_top_phone', __( '18000 344 585', 'epixx' ) );
    $epixx_header_top_phone_url = get_theme_mod( 'epixx_header_top_phone_url', __('18000344585', 'epixx') );
    
    $epixx_login_reg_switch = get_theme_mod( 'epixx_login_reg_switch', false );
    $epixx_trackorder_switch = get_theme_mod( 'epixx_trackorder_switch', false );
    $epixx_track_link = get_theme_mod( 'epixx_track_link', __('/wp/epixx/contact/', 'epixx') );

    $epixx_whishlist_switch = get_theme_mod( 'epixx_whishlist_switch', false );
    $epixx_wishlist_link = get_theme_mod( 'epixx_wishlist_link', __('/wp/epixx/wishlist/', 'epixx') );

    $epixx_cart_switch = get_theme_mod( 'epixx_cart_switch', false );

    $epixx_header_right = get_theme_mod( 'epixx_header_right', false );

    $epixx_worldwide_img = get_theme_mod( 'epixx_worldwide_img', __(get_template_directory_uri() . '/assets/img/icon/world.png', 'epixx') );
    $epixx_worldwide_text = get_theme_mod( 'epixx_worldwide_text', __('World Wide', 'epixx') );
    $epixx_freeshipping_text = get_theme_mod( 'epixx_freeshipping_text', __('Free Shipping', 'epixx') );
    $epixx_worldwide_link = get_theme_mod( 'epixx_worldwide_link', __('#', 'epixx') );

    $epixx_support_img = get_theme_mod( 'epixx_support_img', __(get_template_directory_uri() . '/assets/img/icon/world.png', 'epixx') );
    $epixx_support_text = get_theme_mod( 'epixx_support_text', __('24 Support', 'epixx') );
    $epixx_phoneright_text = get_theme_mod( 'epixx_phoneright_text', __('+1800 453 856', 'epixx') );
    $epixx_phoneright_url = get_theme_mod( 'epixx_phoneright_url', __('+1800453856', 'epixx') );


    $epixx_search = get_theme_mod( 'epixx_search', false );
    $epixx_menu_col = $epixx_header_right ? 'col-xxl-5 col-xl-5 d-none d-xl-block' : 'col-xxl-9 col-xl-9 col-lg-9 d-none d-lg-block text-right';
    $epixx_menu_right = $epixx_header_right ? '' : 'text-end';

    if ( rtl_enable() ) {
        $btn_text = get_theme_mod( 'epixx_button_text_rtl', __( 'Get A Quote', 'epixx' ) );
    } else {
        $btn_text = get_theme_mod( 'epixx_button_text', __( 'Get A Quote', 'epixx' ) );
    }

    $btn_link = get_theme_mod( 'epixx_button_link', __( '#', 'epixx' ) );

    ?>

    <!-- header area start -->
    <header class="header-area d-none d-lg-block">
         <?php if( !empty($epixx_topbar_switch) ) : ?>
        <div class="header-top-3">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-xxl-4 col-lg-4">
                        <?php if( !empty($epixx_header_contract_switch) ) : ?>
                        <div class="top-left-3 d-inline-block">
                            <div class="header-contact-3">
                              <?php if( !empty( $epixx_header_top_phone ) ) : ?>
                                <a href="tel:<?php print esc_url($epixx_header_top_phone_url); ?>"><i class="fal fa-headphones-alt"></i> <?php print esc_html($epixx_header_top_phone); ?></a>
                              <?php endif; ?>
                            </div>
                        </div>
                        <?php endif; ?>

                        <?php if( !empty( $epixx_header_lang ) ) : ?>
                           <?php print epixx_header_lang_defualt(); ?>
                        <?php endif; ?>

                    </div>
                    <div class="col-xl-8  col-lg-8">
                        <div class="header-right-3 text-end">
                            <div class="h-top-list-3 d-inline-block">
                              <ul>
                              <?php if (!empty($epixx_login_reg_switch) && EPIXX_WOOCOMMERCE_ACTIVED): ?>
                                 <li class="epixx_account">
                                 <?php if (is_user_logged_in()): ?>
                                    <a href="<?php echo get_permalink(wc_get_page_id('myaccount')); ?>"><i class="fal fa-user"></i><?php print esc_html__('My Account', 'epixx'); ?></a>
                                 <?php else: ?>
                                    <a href="<?php echo wp_logout_url(get_permalink(wc_get_page_id('myaccount'))) ?>"><i class="fal fa-user"></i><?php print esc_html__('Login/Register', 'epixx'); ?></a>
                                 <?php endif; ?>
                                 </li>
                              <?php endif; ?>


                                <?php if (!empty($epixx_whishlist_switch) && EPIXX_WISHLIST_ACTIVED): ?>
                                 <li class="epixx_whishlist">
                                <a href="<?php print esc_url($epixx_wishlist_link); ?>"><i class="fal fa-heart"></i><?php print esc_html__('Wishlist', 'epixx'); ?></a>
                                </li>
                                <?php endif; ?>

                                <?php if (EPIXX_WOOCOMMERCE_ACTIVED && !empty($epixx_cart_switch)): ?>
                                 <li class="epixx_shop_cart header-shop-cart">
                                <a href="javascript:void()" class="header-cart-3"><i class="fal fa-shopping-bag"></i><?php echo esc_html(WC()->cart->cart_contents_count); ?> <?php print esc_html__('/', 'epixx'); ?> <?php echo WC()->cart->get_cart_total(); ?></a>
                                 <?php print epixx_shopping_cart(); ?>
                                </li>
                                <?php endif; ?>
                                 
                                </ul>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
      <?php endif; ?>
        <!-- ./ header top 3 -->
        <div class="header-main-3 p-rel">
            <div class="container p-rel">
                <div class="header-wrap-3">
                    <div class="logo">
                        <?php epixx_header_logo(); ?>
                    </div>
                    <div class="header-form-3">
                        <form action="<?php echo home_url( '/' ); ?>" method="get">
                           <input type="hidden" name="post_type" value="product">
                            <input type="search" 
                            placeholder="<?php print esc_attr__('Search anything here..', 'epixx'); ?>"
                            name="s"
                            value="<?php print esc_attr(get_search_query()); ?>">
                            <button type="submit"><i class="fal fa-search"></i></button>
                        </form>

                    </div>
                    <div class="header-nav header-nav-3">
                        <nav id="mobile-menu">
                            <?php epixx_header_menu();?>
                        </nav>
                    </div>
                    <?php if( !empty($epixx_header_right) ) : ?>
                    <div class="header-action-3 d-none d-xxl-block">
                        <div class="single-item mr-30">
                            <div class="single-action-3">
                              <?php if( !empty($epixx_worldwide_img) ) : ?>
                                <div class="thumb">
                                    <img src="<?php print esc_url($epixx_worldwide_img); ?>" alt="<?php print esc_attr__('icon-img', 'epixx'); ?>">
                                </div>
                             <?php endif; ?>
                                <div class="content">
                                    <?php if( !empty($epixx_worldwide_text) ) : ?>
                                    <a href="<?php print esc_url($epixx_worldwide_link); ?>"><?php print esc_html($epixx_worldwide_text); ?></a>
                                    <?php endif; ?>
                                    <?php if( !empty($epixx_freeshipping_text) ) : ?>
                                    <a href="<?php print esc_url($epixx_worldwide_link); ?>"><span><?php print esc_html($epixx_freeshipping_text); ?></span></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="single-item">
                            <div class="single-action-3">
                              <?php if( !empty($epixx_support_img) ) : ?>
                                <div class="thumb">
                                    <img src="<?php print esc_url($epixx_support_img); ?>" alt="<?php print esc_attr__('icon-img', 'epixx'); ?>">
                                </div>
                             <?php endif; ?>
                                <div class="content">
                                    <?php if( !empty($epixx_support_text) ) : ?>
                                    <a href="tel:<?php print esc_url($epixx_phoneright_url); ?>"><?php print esc_html($epixx_support_text); ?></a>
                                    <?php endif; ?>
                                    <?php if( !empty($epixx_phoneright_text) ) : ?>
                                    <a href="tel:<?php print esc_url($epixx_phoneright_url); ?>"><span><?php print esc_html($epixx_phoneright_text); ?></span></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <!-- /. main header 3 -->
    </header>
    <!-- header area end -->
    <div class="mobile-header d-lg-none">
        <div class="container">
            <div class="row">
                <div class="col-6">
                    <div class="logo">
                        <?php epixx_header_logo(); ?>
                    </div>
                </div>
                <div class="col-6">
                    <div class="bar-icon text-end">
                        <button class="toggle-nav-menu sidebar-menu-toggle">
                            <i class="fal fa-bars"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- /. mobile header -->

    
   <!-- side info start -->

   <?php epixx_side_info(); ?>
   <!-- side info end -->     
   <div class="offcanvas-overlay"></div>
   <!-- sidebar area end -->

<?php
}


// epixx_side_info
function epixx_side_info() {

    $epixx_side_hide = get_theme_mod( 'epixx_side_hide', false );
    $epixx_side_logo = get_theme_mod( 'epixx_side_logo', get_template_directory_uri() . '/assets/img/logo/logo.png' );
    $epixx_login_text = get_theme_mod( 'epixx_login_text', __( 'Login', 'epixx' ) );

    $epixx_whishlist_switch = get_theme_mod( 'epixx_whishlist_switch', false );
    $epixx_wishlist_link = get_theme_mod( 'epixx_wishlist_link', __('/wp/epixx/wishlist/', 'epixx') );

    $epixx_cart_switch = get_theme_mod( 'epixx_cart_switch', false );

    $epixx_sideinfo_content_switch = get_theme_mod( 'epixx_sideinfo_content_switch', false );
    $epixx_contact_title = get_theme_mod( 'epixx_contact_title', __( 'Contact Info', 'epixx' ) );
    $epixx_extra_address = get_theme_mod( 'epixx_extra_address', __( '123/A, Miranda City Tower, NYC', 'epixx' ) );
    $epixx_extra_phone_number = get_theme_mod( 'epixx_extra_phone_number', __( '+876 864 764 764', 'epixx' ) );
    $epixx_extra_phone_url = get_theme_mod( 'epixx_extra_phone_url', __( '+876864764764', 'epixx' ) );
    $epixx_extra_email = get_theme_mod( 'epixx_extra_email', __( 'admin@gmail.com', 'epixx' ) );

    $epixx_side_social_switch = get_theme_mod( 'epixx_side_social_switch', false );
    $epixx_side_fb_url = get_theme_mod( 'epixx_side_fb_url', __('#', 'epixx') );
    $epixx_side_twitter_url = get_theme_mod( 'epixx_side_twitter_url', __('#', 'epixx') );
    $epixx_side_instagram_url = get_theme_mod( 'epixx_side_instagram_url', __('#', 'epixx') );
    $epixx_side_linkedin_url = get_theme_mod( 'epixx_side_linkedin_url', __('#', 'epixx') );
    $epixx_side_youtube_url = get_theme_mod( 'epixx_side_youtube_url', __('#', 'epixx') );

    ?>


   <div class="fix">
       <div class="side-info d-lg-none">
           <button class="side-info-close"><i class="fal fa-times"></i></button>

           <div class="side__logo mb-25">
               <a href="<?php print esc_url( home_url( '/' ) ); ?>"><img src="<?php print esc_url($epixx_side_logo); ?>" alt="<?php print esc_attr__('side-logo', 'epixx'); ?>" /></a>
           </div>

            <div class="epix-header-form-2 epix_side_search mb-20">
                <form action="<?php echo home_url( '/' ); ?>">
                   <input type="hidden" name="post_type" value="product">
                    <input type="search" 
                    placeholder="<?php print esc_attr__('Search anything here..', 'epixx'); ?>"
                    name="s"
                    value="<?php print esc_attr(get_search_query()); ?>">
                    <button type="submit"><i class="fal fa-search"></i></button>
                </form>
            </div>

           <div class="mobile-menu"></div>

            <div class="epixx_sideinfo_action mt-30">
              <ul>

                <?php if (!empty($epixx_whishlist_switch) && EPIXX_WISHLIST_ACTIVED): ?>
                 <li class="epix-action-single epix-action-single-2">
                <a href="<?php print esc_url($epixx_wishlist_link); ?>">
                 <span class="icon">
                    <i class="fal fa-heart"></i>
                    <span><?php echo yith_wcwl_count_all_products(); ?></span>
                 </span></a>
                </li>
                <?php endif; ?>

                <?php if (EPIXX_WOOCOMMERCE_ACTIVED && !empty($epixx_cart_switch)): ?>
                 <li class="epix-action-single epix-action-single-2">
                <a href="<?php print esc_url(wc_get_cart_url()); ?>" class="header-cart-3">
                   <span class="icon">
                      <i class="fal fa-shopping-bag"></i>
                      <span class="icon_count"><?php echo esc_html(WC()->cart->cart_contents_count); ?></span>
                   </span>
                </a>
                </li>
                <?php endif; ?>
                 
                </ul>
          </div>

           <div class="contact-infos mt-30 mb-30">
               <div class="contact-list mb-30">
                  <?php if( !empty($epixx_sideinfo_content_switch) ) : ?>
                  <?php if( !empty($epixx_contact_title) ) : ?>
                   <h4><?php print esc_html( $epixx_contact_title ); ?></h4>
                  <?php endif; ?>
                   <ul class="p-0">
                        <?php if( !empty($epixx_extra_address) ) : ?>
                       <li><i class="fal fa-map"></i><?php print esc_html( $epixx_extra_address ); ?></li>
                        <?php endif; ?>
                        <?php if( !empty($epixx_extra_phone_number) ) : ?>
                       <li><i class="fal fa-phone-alt"></i><a href="tel:<?php print esc_url($epixx_extra_phone_url); ?>"><?php print esc_html($epixx_extra_phone_number); ?></a></li>
                       <?php endif; ?>
                       <?php if( !empty($epixx_extra_email) ) : ?>
                       <li><i class="fal fa-envelope-open"></i><a href="mailto:<?php print esc_url($epixx_extra_email); ?>"><?php print esc_html( $epixx_extra_email ); ?></a></li>  
                       <?php endif; ?>
                   </ul>
                  <?php endif; ?>

                  <?php if( !empty($epixx_side_social_switch) ) : ?>
                   <div class="sidebar__menu--social">
                        <?php if( !empty($epixx_side_fb_url) ) : ?>
                       <a href="<?php print esc_html($epixx_side_fb_url); ?>" target="_blank"><i class="fab fa-facebook-f"></i></a>
                        <?php endif; ?>
                        <?php if( !empty($epixx_side_twitter_url) ) : ?>
                       <a href="<?php print esc_html($epixx_side_twitter_url); ?>" target="_blank"><i class="fab fa-twitter"></i></a>
                       <?php endif; ?>
                       <?php if( !empty($epixx_side_instagram_url) ) : ?>
                       <a href="<?php print esc_html($epixx_side_instagram_url); ?>" target="_blank"><i class="fab fa-instagram"></i></a>
                       <?php endif; ?>
                       <?php if( !empty($epixx_side_linkedin_url) ) : ?>
                       <a href="<?php print esc_html($epixx_side_linkedin_url); ?>" target="_blank"><i class="fab fa-linkedin"></i></a>
                       <?php endif; ?>
                       <?php if( !empty($epixx_side_youtube_url) ) : ?>
                       <a href="<?php print esc_html($epixx_side_youtube_url); ?>" target="_blank"><i class="fab fa-youtube"></i></a>
                       <?php endif; ?>
                   </div>
                <?php endif; ?>

               </div>
           </div>
       </div>
   </div>

   <!-- sidebar area end -->  

<?php }



/**
 * [epixx_header_lang description]
 * @return [type] [description]
 */
function epixx_header_lang_defualt() {
    $epixx_header_lang = get_theme_mod( 'epixx_header_lang', false );
    if ( $epixx_header_lang ): ?>

   <div class="select-default select-default-3">
      <button><?php print esc_html__( 'EN', 'epixx' );?> <i class="fal fa-angle-down"></i></button>
      <?php do_action( 'epixx_language' );?>
   </div>

    <?php endif;?>
<?php
}

/**
 * [epixx_language_list description]
 * @return [type] [description]
 */
function _epixx_language( $mar ) {
    return $mar;
}
function epixx_language_list() {

    $mar = '';
    $languages = apply_filters( 'wpml_active_languages', NULL, 'orderby=id&order=desc' );
    if ( !empty( $languages ) ) {
        $mar = '<ul>';
        foreach ( $languages as $lan ) {
            $active = $lan['active'] == 1 ? 'active' : '';
            $mar .= '<li class="' . $active . '"><a href="' . $lan['url'] . '">' . $lan['translated_name'] . '</a></li>';
        }
        $mar .= '</ul>';
    } else {
        //remove this code when send themeforest reviewer team
        $mar .= '<ul>';
        $mar .= '<li><a href="#">' . esc_html__( 'USA', 'epixx' ) . '</a></li>';
        $mar .= '<li><a href="#">' . esc_html__( 'UK', 'epixx' ) . '</a></li>';
        $mar .= '<li><a href="#">' . esc_html__( 'CA', 'epixx' ) . '</a></li>';
        $mar .= '<li><a href="#">' . esc_html__( 'AU', 'epixx' ) . '</a></li>';
        $mar .= ' </ul>';
    }
    print _epixx_language( $mar );
}
add_action( 'epixx_language', 'epixx_language_list' );

// favicon logo
function epixx_favicon_logo_func() {
        $epixx_favicon = get_template_directory_uri() . '/assets/img/favicon.png';
        $epixx_favicon_url = get_theme_mod( 'favicon_url', $epixx_favicon );
    ?>

    <link rel="shortcut icon" type="image/x-icon" href="<?php print esc_url( $epixx_favicon_url );?>">

    <?php
}
add_action( 'wp_head', 'epixx_favicon_logo_func' );

// header logo
function epixx_header_logo() {
    ?>
    <?php
        $epixx_logo_on = function_exists( 'get_field' ) ? get_field( 'is_enable_sec_logo' ) : NULL;
        $epixx_logo = get_template_directory_uri() . '/assets/img/logo/logo.png';
        $epixx_logo_black = get_template_directory_uri() . '/assets/img/logo/logo-white.png';

        $epixx_customizer_logo = get_theme_mod( 'logo', $epixx_logo );
        $epixx_secondary_logo = get_theme_mod( 'seconday_logo', $epixx_logo_black );

       $epixx_page_logo = function_exists('get_field') ? get_field('header_page_logo') : '';
       $epixx_site_logo = !empty($epixx_page_logo['url']) ? $epixx_page_logo['url'] : $epixx_customizer_logo;
    ?>

        <?php
            if ( has_custom_logo() ) {
                the_custom_logo();
            } else {
                if ( !empty( $epixx_logo_on ) ) {
                    ?>
                        <a class="standard-logo" href="<?php print esc_url( home_url( '/' ) );?>">
                            <img src="<?php print esc_url( $epixx_secondary_logo );?>" alt="<?php print esc_attr__( 'logo', 'epixx' );?>" />
                        </a>
                    <?php
                } else {
                    ?>
                        <a class="standard-logo" href="<?php print esc_url( home_url( '/' ) );?>">
                            <img src="<?php print esc_url( $epixx_site_logo );?>" alt="<?php print esc_attr__( 'logo', 'epixx' );?>" />
                        </a>
                    <?php
                }
            }
        ?>
    <?php
}

// header logo
function epixx_header_sticky_logo() {?>
    <?php
        $epixx_logo_black = get_template_directory_uri() . '/assets/img/logo/logo-black.png';
        $epixx_secondary_logo = get_theme_mod( 'seconday_logo', $epixx_logo_black );
    ?>
      <a class="sticky-logo" href="<?php print esc_url( home_url( '/' ) );?>">
          <img src="<?php print esc_url( $epixx_secondary_logo );?>" alt="<?php print esc_attr__( 'logo', 'epixx' );?>" />
      </a>
    <?php
}

function epixx_mobile_logo() {
    // side info
    $epixx_mobile_logo_hide = get_theme_mod( 'epixx_mobile_logo_hide', false );

    $epixx_site_logo = get_theme_mod( 'logo', get_template_directory_uri() . '/assets/img/logo/logo.png' );

    ?>

    <?php if ( !empty( $epixx_site_logo ) ): ?>
    <div class="side__logo">
        <a class="sideinfo-logo" href="<?php print esc_url( home_url( '/' ) );?>">
            <img src="<?php print esc_url( $epixx_site_logo );?>" alt="<?php print esc_attr__( 'logo', 'epixx' );?>" />
        </a>
    </div>
    <?php endif;?>



<?php }

/**
 * [epixx_header_social_profiles description]
 * @return [type] [description]
 */
function epixx_header_social_profiles() {
    $epixx_topbar_fb_url = get_theme_mod( 'epixx_topbar_fb_url', __( '#', 'epixx' ) );
    $epixx_topbar_twitter_url = get_theme_mod( 'epixx_topbar_twitter_url', __( '#', 'epixx' ) );
    $epixx_topbar_instagram_url = get_theme_mod( 'epixx_topbar_instagram_url', __( '#', 'epixx' ) );
    $epixx_topbar_linkedin_url = get_theme_mod( 'epixx_topbar_linkedin_url', __( '#', 'epixx' ) );
    $epixx_topbar_youtube_url = get_theme_mod( 'epixx_topbar_youtube_url', __( '#', 'epixx' ) );
    ?>
        <ul>
        <?php if ( !empty( $epixx_topbar_fb_url ) ): ?>
          <li><a href="<?php print esc_url( $epixx_topbar_fb_url );?>"><span><i class="fab fa-facebook-f"></i></span></a></li>
        <?php endif;?>

        <?php if ( !empty( $epixx_topbar_twitter_url ) ): ?>
            <li><a href="<?php print esc_url( $epixx_topbar_twitter_url );?>"><span><i class="fab fa-twitter"></i></span></a></li>
        <?php endif;?>

        <?php if ( !empty( $epixx_topbar_instagram_url ) ): ?>
            <li><a href="<?php print esc_url( $epixx_topbar_instagram_url );?>"><span><i class="fab fa-instagram"></i></span></a></li>
        <?php endif;?>

        <?php if ( !empty( $epixx_topbar_linkedin_url ) ): ?>
            <li><a href="<?php print esc_url( $epixx_topbar_linkedin_url );?>"><span><i class="fab fa-linkedin"></i></span></a></li>
        <?php endif;?>

        <?php if ( !empty( $epixx_topbar_youtube_url ) ): ?>
            <li><a href="<?php print esc_url( $epixx_topbar_youtube_url );?>"><span><i class="fab fa-youtube"></i></span></a></li>
        <?php endif;?>
        </ul>

<?php
}

function epixx_footer_social_profiles() {
    $epixx_footer_fb_url = get_theme_mod( 'epixx_footer_fb_url', __( '#', 'epixx' ) );
    $epixx_footer_twitter_url = get_theme_mod( 'epixx_footer_twitter_url', __( '#', 'epixx' ) );
    $epixx_footer_instagram_url = get_theme_mod( 'epixx_footer_instagram_url', __( '#', 'epixx' ) );
    $epixx_footer_linkedin_url = get_theme_mod( 'epixx_footer_linkedin_url', __( '#', 'epixx' ) );
    $epixx_footer_youtube_url = get_theme_mod( 'epixx_footer_youtube_url', __( '#', 'epixx' ) );
    ?>

    <?php if ( !empty( $epixx_footer_fb_url ) ): ?>
    <a href="<?php print esc_url( $epixx_footer_fb_url );?>"><i class="fab fa-facebook-f"></i></a>
    <?php endif;?>
    <?php if ( !empty( $epixx_footer_twitter_url ) ): ?>
    <a href="<?php print esc_url( $epixx_footer_twitter_url );?>"><i class="fab fa-twitter"></i></a>
    <?php endif; ?>
    <?php if ( !empty( $epixx_footer_instagram_url ) ): ?>
    <a href="<?php print esc_url( $epixx_footer_instagram_url );?>"><i class="fab fa-instagram"></i></a>
    <?php endif; ?>
    <?php if ( !empty( $epixx_footer_linkedin_url ) ): ?>
    <a href="<?php print esc_url( $epixx_footer_linkedin_url );?>"><i class="fab fa-linkedin"></i></a>
    <?php endif; ?>
    <?php if ( !empty( $epixx_footer_youtube_url ) ): ?>
    <a href="<?php print esc_url( $epixx_footer_youtube_url );?>"><i class="fab fa-youtube"></i></a>
    <?php endif; ?>
            
<?php
}

/**
 * [epixx_header_menu description]
 * @return [type] [description]
 */
function epixx_header_menu() {
    ?>
    <?php
        wp_nav_menu( [
            'theme_location' => 'main-menu',
            'menu_class'     => '',
            'container'      => '',
            'fallback_cb'    => 'epixx_Navwalker_Class::fallback',
            'walker'         => new epixx_Navwalker_Class,
        ] );
    ?>
    <?php
}

/**
 * [epixx_header_top_menu description]
 * @return [type] [description]
 */
function epixx_header_top_menu() {
    ?>
    <?php
        wp_nav_menu( [
            'theme_location' => 'top-menu',
            'menu_class'     => '',
            'container'      => '',
            'fallback_cb'    => 'epixx_Navwalker_Class::fallback',
            'walker'         => new epixx_Navwalker_Class,
        ] );
    ?>
    <?php
}

/**
 * [epixx_header_menu description]
 * @return [type] [description]
 */
function epixx_mobile_menu() {
    ?>
    <?php
        $epixx_menu = wp_nav_menu( [
            'theme_location' => 'main-menu',
            'menu_class'     => '',
            'container'      => '',
            'menu_id'        => 'mobile-menu-active',
            'echo'           => false,
        ] );

    $epixx_menu = str_replace( "menu-item-has-children", "menu-item-has-children has-children", $epixx_menu );
        echo wp_kses_post( $epixx_menu );
    ?>
    <?php
}

/**
 * [epixx_search_menu description]
 * @return [type] [description]
 */
function epixx_header_search_menu() {
    ?>
    <?php
        wp_nav_menu( [
            'theme_location' => 'header-search-menu',
            'menu_class'     => '',
            'container'      => '',
            'fallback_cb'    => 'epixx_Navwalker_Class::fallback',
            'walker'         => new epixx_Navwalker_Class,
        ] );
    ?>
    <?php
}

/**
 * [epixx_footer_menu description]
 * @return [type] [description]
 */
function epixx_footer_menu() {
    wp_nav_menu( [
        'theme_location' => 'footer-menu',
        'menu_class'     => 'm-0',
        'container'      => '',
        'fallback_cb'    => 'epixx_Navwalker_Class::fallback',
        'walker'         => new epixx_Navwalker_Class,
    ] );
}


/**
 * [epixx_category_menu description]
 * @return [type] [description]
 */
function epixx_category_menu() {
    wp_nav_menu( [
        'theme_location' => 'category-menu',
        'menu_class'     => 'cat-submenu m-0',
        'container'      => '',
        'fallback_cb'    => 'epixx_Navwalker_Class::fallback',
        'walker'         => new epixx_Navwalker_Class,
    ] );
}

/**
 *
 * epixx footer
 */
add_action( 'epixx_footer_style', 'epixx_check_footer', 10 );

function epixx_check_footer() {
    $epixx_footer_style = function_exists( 'get_field' ) ? get_field( 'footer_style' ) : NULL;
    $epixx_default_footer_style = get_theme_mod( 'choose_default_footer', 'footer-style-1' );

    if ( $epixx_footer_style == 'footer-style-1' ) {
        epixx_footer_style_1();
    } elseif ( $epixx_footer_style == 'footer-style-2' ) {
        epixx_footer_style_2();
    } elseif ( $epixx_footer_style == 'footer-style-3' ) {
        epixx_footer_style_3();
    } elseif ( $epixx_footer_style == 'footer-style-4' ) {
        epixx_footer_style_4();
    } else {

        /** default footer style **/
        if ( $epixx_default_footer_style == 'footer-style-2' ) {
            epixx_footer_style_2();
        } elseif ( $epixx_default_footer_style == 'footer-style-3' ) {
            epixx_footer_style_3();
        } elseif ( $epixx_default_footer_style == 'footer-style-4' ) {
            epixx_footer_style_4();
        } else {
            epixx_footer_style_1();
        }

    }
}

/**
 * footer  style_defaut
 */
function epixx_footer_style_1() {

    $footer_bg_img = get_theme_mod( 'epixx_footer_bg' );
    $epixx_footer_logo = get_theme_mod( 'epixx_footer_logo', __(get_template_directory_uri() . '/assets/img/logo/logo-white.png', 'epixx') );
    $epixx_copyright_center = $epixx_footer_logo ? 'col-lg-4 offset-lg-4 col-md-6 text-right' : 'col-lg-12 text-center';
    $epixx_footer_bg_url_from_page = function_exists( 'get_field' ) ? get_field( 'epixx_footer_bg' ) : '';
    $epixx_footer_bg_color_from_page = function_exists( 'get_field' ) ? get_field( 'epixx_footer_bg_color' ) : '';
    $footer_bg_color = get_theme_mod( 'epixx_footer_bg_color' );

    // bg image
    $bg_img = !empty( $epixx_footer_bg_url_from_page['url'] ) ? $epixx_footer_bg_url_from_page['url'] : $footer_bg_img;

    // bg color
    $bg_color = !empty( $epixx_footer_bg_color_from_page ) ? $epixx_footer_bg_color_from_page : $footer_bg_color;


    // footer_columns
    $footer_columns = 0;
    $footer_widgets = get_theme_mod( 'footer_widget_number', 4 );

    for ( $num = 1; $num <= $footer_widgets; $num++ ) {
        if ( is_active_sidebar( 'footer-' . $num ) ) {
            $footer_columns++;
        }
    }

    switch ( $footer_columns ) {
    case '1':
        $footer_class[1] = 'col-lg-12';
        break;
    case '2':
        $footer_class[1] = 'col-lg-6 col-md-6';
        $footer_class[2] = 'col-lg-6 col-md-6';
        break;
    case '3':
        $footer_class[1] = 'col-xl-4 col-lg-6 col-md-5';
        $footer_class[2] = 'col-xl-4 col-lg-6 col-md-7';
        $footer_class[3] = 'col-xl-4 col-lg-6';
        break;
    case '4':
        $footer_class[1] = 'col-lg-3 col-md-6 col-sm-6';
        $footer_class[2] = 'col-lg-3 col-md-6 col-sm-6';
        $footer_class[3] = 'col-lg-3 col-md-6 col-sm-6';
        $footer_class[4] = 'col-lg-3 col-md-6 col-sm-6';
        break;
    default:
        $footer_class = 'col-xl-3 col-lg-3 col-md-6';
        break;
    }

    ?>

    <!-- footer area start --> 

   <footer>
    <div class="footer-area footer-1 footer-default bg-black" data-bg-color="<?php print esc_attr( $bg_color );?>" data-background="<?php print esc_url( $bg_img );?>">
      <?php if ( is_active_sidebar('footer-1') OR is_active_sidebar('footer-2') OR is_active_sidebar('footer-3') OR is_active_sidebar('footer-4') ): ?>
         <div class="footer-main pb-60 pt-100">
            <div class="container">
               <div class="row">
                <?php
                    if ( $footer_columns < 5 ) {
                    print '<div class="col-lg-3 col-sm-6">';
                    dynamic_sidebar( 'footer-1' );
                    print '</div>';

                    print '<div class="col-lg-3 col-sm-6">';
                    dynamic_sidebar( 'footer-2' );
                    print '</div>';

                    print '<div class="col-lg-3 col-sm-6">';
                    dynamic_sidebar( 'footer-3' );
                    print '</div>';

                    print '<div class="col-lg-3 col-sm-6">';
                    dynamic_sidebar( 'footer-4' );
                    print '</div>';
                    } else {
                        for ( $num = 1; $num <= $footer_columns; $num++ ) {
                            if ( !is_active_sidebar( 'footer-' . $num ) ) {
                                continue;
                            }
                            print '<div class="' . esc_attr( $footer_class[$num] ) . '">';
                            dynamic_sidebar( 'footer-' . $num );
                            print '</div>';
                        }
                    }
                ?>
               </div>
            </div>
         </div>
         <?php endif; ?>

         <div class="footer-copyright">
            <div class="container">
               <div class="row">
                  <div class="col-xxl-12 text-center">
                        <p><?php print epixx_copyright_text(); ?></p>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </footer>
<?php
}

/**
 * footer  style 2
 */
function epixx_footer_style_2() {
    $footer_bg_img = get_theme_mod( 'epixx_footer_bg' );
    $epixx_footer_logo = get_theme_mod( 'epixx_footer_logo', __(get_template_directory_uri() . '/assets/img/logo/logo-white.png', 'epixx') );
    $epixx_copyright_center = $epixx_footer_logo ? 'col-lg-4 offset-lg-4 col-md-6 text-right' : 'col-lg-12 text-center';
    $epixx_footer_bg_url_from_page = function_exists( 'get_field' ) ? get_field( 'epixx_footer_bg' ) : '';
    $epixx_footer_bg_color_from_page = function_exists( 'get_field' ) ? get_field( 'epixx_footer_bg_color' ) : '';
    $footer_bg_color = get_theme_mod( 'epixx_footer_bg_color' );
    $footer_copyright_switch = get_theme_mod( 'footer_copyright_switch', false );


    // bg image
    $bg_img = !empty( $epixx_footer_bg_url_from_page['url'] ) ? $epixx_footer_bg_url_from_page['url'] : $footer_bg_img;

    // bg color
    $bg_color = !empty( $epixx_footer_bg_color_from_page ) ? $epixx_footer_bg_color_from_page : $footer_bg_color;


    $footer_columns = 0;
    $footer_widgets = get_theme_mod( 'footer_widget_number', 4 );

    for ( $num = 1; $num <= $footer_widgets; $num++ ) {
        if ( is_active_sidebar( 'footer-2-' . $num ) ) {
            $footer_columns++;
        }
    }

    switch ( $footer_columns ) {
    case '1':
        $footer_class[1] = 'col-lg-12';
        break;
    case '2':
        $footer_class[1] = 'col-lg-6 col-md-6';
        $footer_class[2] = 'col-lg-6 col-md-6';
        break;
    case '3':
        $footer_class[1] = 'col-xl-4 col-lg-6 col-md-5';
        $footer_class[2] = 'col-xl-4 col-lg-6 col-md-7';
        $footer_class[3] = 'col-xl-4 col-lg-6';
        break;
    case '4':
        $footer_class[1] = 'col-xxl-3 col-xl-3 col-lg-3 col-md-4 col-sm-6';
        $footer_class[2] = 'col-xxl-2 col-xl-2 col-lg-2 col-md-4 col-sm-6';
        $footer_class[3] = 'col-xxl-3 col-xl-2 col-lg-2 col-md-4 col-sm-6';
        $footer_class[4] = 'col-xxl-2 col-xl-2 col-lg-2 col-md-4 col-sm-6';
        break;
    case '5':
        $footer_class[1] = 'col-xxl-3 col-xl-3 col-lg-3 col-md-4 col-sm-6';
        $footer_class[2] = 'col-xxl-2 col-xl-2 col-lg-2 col-md-4 col-sm-6 footer__pl-70';
        $footer_class[3] = 'col-xxl-3 col-xl-2 col-lg-2 col-md-4 col-sm-6 footer__pl-90';
        $footer_class[4] = 'col-xxl-2 col-xl-2 col-lg-2 col-md-4 col-sm-6';
        $footer_class[5] = 'col-xxl-2 col-xl-3 col-lg-3 col-md-4 col-sm-6';
        break;
    default:
        $footer_class = 'col-xl-3 col-lg-3 col-md-6';
        break;
    }

    ?>

    <!-- footer area start -->

  <footer class="footer-area footer-1 bg-black" data-bg-color="<?php print esc_attr( $bg_color );?>" data-background="<?php print esc_url( $bg_img );?>">

    <?php if ( is_active_sidebar( 'footer-2-1' ) OR is_active_sidebar( 'footer-2-2' ) OR is_active_sidebar( 'footer-2-3' ) OR is_active_sidebar( 'footer-2-4' ) OR is_active_sidebar( 'footer-2-5' ) ) : ?>
    <div class="footer-main pb-60 pt-95">
      <div class="container">
        <div class="row">

          <div class="col-xxl-3 col-xl-3 footer-col-1 col-sm-6 col-md-8 col-lg-8">
            <?php dynamic_sidebar( 'footer-2-1' ); ?>
          </div>
          <!-- /. footer about widget -->
          <div class="col-xxl-6 col-xl-6  footer-col-2">
            <div class="row">
              <div class="col-xxl-4 col-sm-6 col-md-4 col-lg-4 col-xl-4">
                <?php dynamic_sidebar( 'footer-2-2' ); ?>
              </div>
              <div class="col-xxl-4 col-sm-6 col-md-4  col-lg-4  col-xl-4">
                <?php dynamic_sidebar( 'footer-2-3' ); ?>
              </div>
              <div class="col-xxl-4 col-sm-6 col-md-4  col-lg-4  col-xl-4">
                <?php dynamic_sidebar( 'footer-2-4' ); ?>
              </div>
            </div>
          </div>
          <!-- /. footer menu widget -->
          <div class="col-xxl-3 col-xl-3 footer-col-3 col-sm-6 col-md-4 col-lg-4 order-first order-xl-last">
            <?php dynamic_sidebar( 'footer-2-5' ); ?>
          </div>

        </div>

      </div>
    </div>
    <?php endif; ?>

    <div class="footer-copyright text-center">
      <div class="container">
        <p><?php print epixx_copyright_text(); ?></p>
      </div>
    </div>

  </footer>





<?php
}

/**
 * footer  style 3
 */
function epixx_footer_style_3() {

    $footer_bg_img = get_theme_mod( 'epixx_footer_bg' );
    $epixx_footer_logo = get_theme_mod( 'epixx_footer_logo', __(get_template_directory_uri() . '/assets/img/logo/logo-white.png', 'epixx') );
    $epixx_copyright_center = $epixx_footer_logo ? 'col-lg-4 offset-lg-4 col-md-6 text-right' : 'col-lg-12 text-center';
    $epixx_footer_bg_url_from_page = function_exists( 'get_field' ) ? get_field( 'epixx_footer_bg' ) : '';
    $epixx_footer_bg_color_from_page = function_exists( 'get_field' ) ? get_field( 'epixx_footer_bg_color' ) : '';
    $footer_bg_color = get_theme_mod( 'epixx_footer_bg_color' );
    $epixx_footer_cards = get_theme_mod( 'epixx_footer_cards', __( get_template_directory_uri() . '/assets/img/icon/payment.png', 'epixx') );
    $footer_copyright_switch = get_theme_mod( 'footer_copyright_switch', false );

    // bg image
    $bg_img = !empty( $epixx_footer_bg_url_from_page['url'] ) ? $epixx_footer_bg_url_from_page['url'] : $footer_bg_img;

    // bg color
    $bg_color = !empty( $epixx_footer_bg_color_from_page ) ? $epixx_footer_bg_color_from_page : $footer_bg_color;

    // footer_columns
    $footer_columns = 0;
    $footer_widgets = get_theme_mod( 'footer_widget_number', 4 );

    for ( $num = 1; $num <= $footer_widgets; $num++ ) {
        if ( is_active_sidebar( 'footer-3-' . $num ) ) {
            $footer_columns++;
        }
    }

    switch ( $footer_columns ) {
    case '1':
        $footer_class[1] = 'col-lg-12';
        break;
    case '2':
        $footer_class[1] = 'col-lg-6 col-md-6';
        $footer_class[2] = 'col-lg-6 col-md-6';
        break;
    case '3':
        $footer_class[1] = 'col-xl-4 col-lg-6 col-md-5';
        $footer_class[2] = 'col-xl-4 col-lg-6 col-md-7';
        $footer_class[3] = 'col-xl-4 col-lg-6';
        break;
    case '4':
        $footer_class[1] = 'col-xxl-3 col-xl-3 col-lg-3 col-md-4 col-sm-6';
        $footer_class[2] = 'col-xxl-2 col-xl-2 col-lg-2 col-md-4 col-sm-6 footer__pl-70';
        $footer_class[3] = 'col-xxl-3 col-xl-2 col-lg-2 col-md-4 col-sm-6 footer__pl-90';
        $footer_class[4] = 'col-xxl-2 col-xl-3 col-lg-3 col-md-4 col-sm-6';
        break;
    case '5':
        $footer_class[1] = 'col-xxl-3 col-xl-3 col-lg-3 col-md-4 col-sm-6';
        $footer_class[2] = 'col-xxl-2 col-xl-2 col-lg-2 col-md-4 col-sm-6 footer__pl-70';
        $footer_class[3] = 'col-xxl-3 col-xl-2 col-lg-2 col-md-4 col-sm-6 footer__pl-90';
        $footer_class[4] = 'col-xxl-2 col-xl-2 col-lg-2 col-md-4 col-sm-6';
        $footer_class[5] = 'col-xxl-2 col-xl-3 col-lg-3 col-md-4 col-sm-6';
        break;
    default:
        $footer_class = 'col-xl-3 col-lg-3 col-md-6';
        break;
    }

    ?>

    <?php if ( is_active_sidebar('footer-3-1') OR is_active_sidebar('footer-3-2') OR is_active_sidebar('footer-3-3') OR is_active_sidebar('footer-3-4') OR is_active_sidebar('footer-3-5') ): ?>
    <footer class="footer-area footer-area-3 bg-black-2 footer-3 pt-105 pb-65" data-bg-color="<?php print esc_attr( $bg_color );?>" data-background="<?php print esc_url( $bg_img ); ?>">
        <div class="container">
            <div class="row">
                <div class="col-xxl-3 col-lg-4 footer-address-col order-0">
                    <?php dynamic_sidebar( 'footer-3-1' ); ?>

                </div>
                <div class="col-xxl-9 col-lg-8">
                    <div class="row pl-65 footer-space-3">
                        <div class="col-xxl col-sm-6 col-md-3 col-lg-3">
                            <?php dynamic_sidebar( 'footer-3-2' ); ?>
                        </div>
                        <div class="col-xxl col-sm-6 col-md-3 col-lg-3">
                            <?php dynamic_sidebar( 'footer-3-3' ); ?>
                        </div>
                        <div class="col-xxl col-sm-6 col-md-3 col-lg-3">
                            <div class="footer-widget mb-30">
                                <?php dynamic_sidebar( 'footer-3-4' ); ?>
                            </div>
                        </div>
                        <div class="col-xxl col-sm-6 col-md-3 col-lg-3">
                            <?php dynamic_sidebar( 'footer-3-5' ); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <?php endif; ?>

    <div class="footer-copyright-2 bg-black-2-i" data-bg-color="<?php print esc_attr( $bg_color );?>">
        <div class="container">
            <div class="row">
                <div class="col-xxl-3 col-lg-3 col-md-4 mb-lg-0">
                    <?php if( !empty($epixx_footer_cards) ) : ?>
                        <img src="<?php print esc_url($epixx_footer_cards); ?>" alt="<?php print esc_attr__( 'card-img', 'epixx' );?>">
                    <?php endif; ?>
                </div>
                <div class="col-xxl-9 col-lg-9 col-md-8 text-lg-end">
                    <div class="text-md-end">
                        <p><?php print epixx_copyright_text(); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php
}

/**
 * footer  style 4
 */
function epixx_footer_style_4() {

    $footer_bg_img = get_theme_mod( 'epixx_footer_bg' );
    $epixx_footer_logo = get_theme_mod( 'epixx_footer_logo', __( get_template_directory_uri() . '/assets/img/logo/logo-white.png', 'epixx') );
    $epixx_copyright_center = $epixx_footer_logo ? 'col-lg-4 offset-lg-4 col-md-6 text-right' : 'col-lg-12 text-center';
    $epixx_footer_bg_url_from_page = function_exists( 'get_field' ) ? get_field( 'epixx_footer_bg' ) : '';
    $epixx_footer_bg_color_from_page = function_exists( 'get_field' ) ? get_field( 'epixx_footer_bg_color' ) : '';
    $footer_bg_color = get_theme_mod( 'epixx_footer_bg_color' );
    $epixx_footer_cards = get_theme_mod( 'epixx_footer_cards', __( get_template_directory_uri() . '/assets/img/icon/payment.png', 'epixx') );
    $footer_copyright_switch = get_theme_mod( 'footer_copyright_switch', false );
    $footer_social_switch = get_theme_mod( 'footer_social_switch', false );
    $footer_style_4_top_switch = get_theme_mod( 'footer_style_4_top_switch', false );
    $epixx_footer_cell_number = get_theme_mod( 'epixx_footer_cell_number', __('(+08) 1562 4278 80', 'epixx') );
    $epixx_footer_cell_url = get_theme_mod( 'epixx_footer_cell_url', __('(+08)1562427880', 'epixx') );
    $epixx_footer_office_hour = get_theme_mod( 'epixx_footer_office_hour', __('Mon - Fri: 8:00 - 21:00 Sat - Sun: 9:00 - 18:00', 'epixx') );

    $epixx_footer_send_button = get_theme_mod( 'epixx_footer_send_button', __('SEND MESSAGE', 'epixx') );
    $epixx_footer_send_button_url = get_theme_mod( 'epixx_footer_send_button_url', __('#', 'epixx') );
    $epixx_footer_live_button = get_theme_mod( 'epixx_footer_live_button', __('LIVE CHAT', 'epixx') );
    $epixx_footer_live_button_url = get_theme_mod( 'epixx_footer_live_button_url', __('#', 'epixx') );

    // bg image
    $bg_img = !empty( $epixx_footer_bg_url_from_page['url'] ) ? $epixx_footer_bg_url_from_page['url'] : $footer_bg_img;

    // bg color
    $bg_color = !empty( $epixx_footer_bg_color_from_page ) ? $epixx_footer_bg_color_from_page : $footer_bg_color;

    // footer_columns
    $footer_columns = 0;
    $footer_widgets = get_theme_mod( 'footer_widget_number', 4 );

    for ( $num = 1; $num <= $footer_widgets; $num++ ) {
        if ( is_active_sidebar( 'footer-4-' . $num ) ) {
            $footer_columns++;
        }
    }

    switch ( $footer_columns ) {
    case '1':
        $footer_class[1] = 'col-lg-12';
        break;
    case '2':
        $footer_class[1] = 'col-lg-6 col-md-6';
        $footer_class[2] = 'col-lg-6 col-md-6';
        break;
    case '3':
        $footer_class[1] = 'col-xl-4 col-lg-6 col-md-5';
        $footer_class[2] = 'col-xl-4 col-lg-6 col-md-7';
        $footer_class[3] = 'col-xl-4 col-lg-6';
        break;
    case '4':
        $footer_class[1] = 'col-xxl-3 col-xl-3 col-lg-3 col-md-4 col-sm-6';
        $footer_class[2] = 'col-xxl-2 col-xl-2 col-lg-2 col-md-4 col-sm-6 footer__pl-70';
        $footer_class[3] = 'col-xxl-3 col-xl-2 col-lg-2 col-md-4 col-sm-6 footer__pl-90';
        $footer_class[4] = 'col-xxl-2 col-xl-3 col-lg-3 col-md-4 col-sm-6';
        break;
    case '5':
        $footer_class[1] = 'col-xxl-3 col-xl-3 col-lg-3 col-md-4 col-sm-6';
        $footer_class[2] = 'col-xxl-2 col-xl-2 col-lg-2 col-md-4 col-sm-6 footer__pl-70';
        $footer_class[3] = 'col-xxl-3 col-xl-2 col-lg-2 col-md-4 col-sm-6 footer__pl-90';
        $footer_class[4] = 'col-xxl-2 col-xl-2 col-lg-2 col-md-4 col-sm-6';
        $footer_class[5] = 'col-xxl-2 col-xl-3 col-lg-3 col-md-4 col-sm-6';
        break;
    default:
        $footer_class = 'col-xl-3 col-lg-3 col-md-6';
        break;
    }

    ?>


    <footer class="footer-area footer-1 bg-black pt-100" data-bg-color="<?php print esc_attr( $bg_color );?>" data-background="<?php print esc_url( $bg_img );?>">
        <div class="container">
            <?php if( !empty($footer_style_4_top_switch) ) : ?>
            <div class="row f-row-space align-items-center pb-85">
                <div class="col-xxl-9">
                    <div class="epix-f-left mb-30 mb-xxl-0">

                        <div class="wrap">
                            <div class="f-logo">
                                <a href="<?php print esc_url( home_url( '/' ) ); ?>"><img src="<?php print esc_url($epixx_footer_logo); ?>" alt="<?php print esc_attr__( 'footer-logo', 'epixx' );?>"></a>
                            </div>
                            <div class="f-contact mr-40">
                                <h6><?php print esc_html__('Need help? Call us:', 'epixx'); ?> <a href="tel:<?php print esc_url($epixx_footer_cell_url); ?>"><?php print esc_html($epixx_footer_cell_number); ?></a></h6>
                                <p><?php print esc_html($epixx_footer_office_hour); ?></p>
                            </div>
                            <div class="f-action">
                                <?php if( !empty($epixx_footer_send_button) ) : ?>
                                <a href="<?php print esc_url($epixx_footer_send_button_url); ?>" class="epix-f-btn"><?php print esc_html($epixx_footer_send_button); ?></a>
                                <?php endif; ?>
                                <?php if( !empty($epixx_footer_live_button) ) : ?>
                                <a href="<?php print esc_url($epixx_footer_live_button_url); ?>" class="epix-f-btn"><?php print esc_html($epixx_footer_live_button); ?></a>
                                <?php endif; ?>

                            </div>
                        </div>
                    </div>
                </div>
                <?php if( !empty($footer_social_switch) ) : ?>
                <div class="col-xxl-3">
                    <div class="epix-f-social text-xxl-end">
                        <?php epixx_footer_social_profiles(); ?>
                    </div>
                </div>
                <?php endif; ?>
            </div>
            <?php endif; ?>

            <?php if ( is_active_sidebar('footer-4-1') OR is_active_sidebar('footer-4-2') OR is_active_sidebar('footer-4-3') OR is_active_sidebar('footer-4-4') OR is_active_sidebar('footer-4-5') OR is_active_sidebar('footer-4-6') ): ?>
            <div class="row pb-70">
                <div class="col-xxl col-12 col-sm-6 col-md-4 col-lg-3">
                    <?php dynamic_sidebar( 'footer-4-1' ); ?>
                </div>
                <div class="col-xxl col-12 col-sm-6 col-md-4 col-lg-3">
                    <?php dynamic_sidebar( 'footer-4-2' ); ?>
                </div>
                <div class="col-xxl col-12 col-sm-6 col-md-4 col-lg-3">
                    <?php dynamic_sidebar( 'footer-4-3' ); ?>
                </div>
                <div class="col-xxl col-12 col-sm-6 col-md-4 col-lg-3">
                    <?php dynamic_sidebar( 'footer-4-4' ); ?>
                </div>
                <div class="col-xxl col-12 col-sm-6 col-md-4 col-lg-3">
                    <?php dynamic_sidebar( 'footer-4-5' ); ?>
                </div>
                <div class="col-xxl col-12 col-sm-6 col-md-4 col-lg-3">
                    <?php dynamic_sidebar( 'footer-4-6' ); ?>
                </div>
            </div>
            <?php endif; ?>

        </div>
    </footer>

    <div class="footer-copyright-2 bg-black-2-i" data-bg-color="<?php print esc_attr( $bg_color );?>">
        <div class="container">
            <div class="row">
                <div class="col-xxl-3 col-lg-3 col-md-4 mb-lg-0">
                    <?php if( !empty($epixx_footer_cards) ) : ?>
                        <img src="<?php print esc_url($epixx_footer_cards); ?>" alt="<?php print esc_attr__( 'card-img', 'epixx' );?>">
                    <?php endif; ?>
                </div>
                <div class="col-xxl-9 col-lg-9 col-md-8 text-lg-end">
                    <div class="text-md-end">
                        <p><?php print epixx_copyright_text(); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php
}

// epixx_copyright_text
function epixx_copyright_text() {
    if ( rtl_enable() ) {
        print get_theme_mod( 'epixx_copyright_rtl', esc_html__( '© 2022 epixx, All Rights Reserved. Design By Bdevs', 'epixx' ) );
    } else {
        print get_theme_mod( 'epixx_copyright', esc_html__( '© 2022 epixx, All Rights Reserved. Design By Bdevs', 'epixx' ) );
    }
}

/**
 * [epixx_breadcrumb_func description]
 * @return [type] [description]
 */
function epixx_breadcrumb_func() {

    $breadcrumb_class = '';
    $breadcrumb_show = 1;

    $hide_bg_img = function_exists('get_field') ? get_field('hide_breadcrumb_background_image') : '';

    if ( is_front_page() && is_home() ) {

        $title = get_theme_mod( 'breadcrumb_blog_title', __( 'Blog', 'epixx' ) );
        $breadcrumb_class = 'home_front_page';
    } 
    elseif ( is_front_page() ) {

        $title = get_theme_mod( 'breadcrumb_blog_title', __( 'Blog', 'epixx' ) );
        $breadcrumb_show = 0;

    } 
    elseif ( is_home() && function_exists('tutor') ) {
         if ( get_option( 'page_for_posts' ) ) {

            $user_name = sanitize_text_field(get_query_var('tutor_student_username'));
            $get_user = tutor_utils()->get_user_by_login($user_name);
   
            if ( $get_user == NULL ) {
               $title = get_the_title( get_option( 'page_for_posts' ) );
               $id = get_option( 'page_for_posts' );
            }
            else {
               $title = ucwords($get_user->user_login);
            }
            
        }
        
    } 
    elseif ( is_single() && 'post' == get_post_type() ) {

        if ( rtl_enable() ) {
            $title =  get_the_title();
        } else {
            $title = get_the_title();
        }

    } 
    elseif ( is_single() && 'product' == get_post_type() ) {
        $title = get_theme_mod( 'breadcrumb_product_details', __( 'Shop', 'epixx' ) );
    } 
    elseif ( is_single() && 'bdevs-services' == get_post_type() ) {
        $title = get_the_title();

    } 
    elseif ( is_single() && 'courses' == get_post_type() ) {
      $title = esc_html__( 'Course Details', 'epixx' );
    } 
    elseif ( is_single() && 'bdevs-event' == get_post_type() ) {
      $title = esc_html__( 'Event Details', 'epixx' );
    } 
    elseif ( is_single() && 'bdevs-cases' == get_post_type() ) {
        if ( rtl_enable() ) {
            $title =  get_the_title();
        } else {
            $title = get_the_title();
        }
    } 
    elseif ( is_search() ) {

        $title = esc_html__( 'Search Results for : ', 'epixx' ) . get_search_query();
    } 
    elseif ( is_404() ) {
        $title = esc_html__( 'Page not Found', 'epixx' );
    } 
    elseif ( function_exists( 'is_woocommerce' ) && is_woocommerce() ) {
        $title = get_theme_mod( 'breadcrumb_shop', __( 'Shop', 'epixx' ) );
    } 
    elseif ( is_archive() ) {

        $title = get_the_archive_title();
    } 
    else {

        $title = get_the_title();
    }
 



    $_id = get_the_ID();

    if ( is_single() && 'product_cat' == get_post_type() ) { 
        $_id = $post->ID;
    } 
    elseif ( function_exists("is_shop") AND is_shop()  ) { 
        $_id = wc_get_page_id('shop');
    } 
    elseif ( is_home() && get_option( 'page_for_posts' ) ) {
        $_id = get_option( 'page_for_posts' );
    }

    $is_breadcrumb = function_exists( 'get_field' ) ? get_field( 'is_it_invisible_breadcrumb', $_id ) : '';

    if ( empty( $is_breadcrumb ) && $breadcrumb_show == 1 ) {

        $bg_img_from_page = function_exists('get_field') ? get_field('breadcrumb_background_image',$_id) : '';
        $hide_bg_img = function_exists('get_field') ? get_field('hide_breadcrumb_background_image',$_id) : '';

        // get_theme_mod
        $bg_img_url = get_template_directory_uri() . '/assets/img/page-title/page-title.jpg';
        $bg_img = get_theme_mod( 'breadcrumb_bg_img' );
        $epixx_breadcrumb_bg_color = get_theme_mod( 'epixx_breadcrumb_bg_color', __('#F6F9FC', 'epixx') );
        

        if ( $hide_bg_img ) {
            $bg_img = '';
        } else {
            $bg_img = !empty( $bg_img_from_page ) ? $bg_img_from_page['url'] : $bg_img;
        }?>

         <!-- page title area start -->

        <div class="epix-breadcrumb-area <?php print esc_attr( $breadcrumb_class );?>" data-background="<?php print esc_attr($bg_img);?>" data-bg-color="<?php print esc_attr($epixx_breadcrumb_bg_color); ?>">
            <div class="container">
                <h4 class="epix-breadcrumb-title mb-0"><?php echo wp_kses_post( $title ); ?></h4>
                <div class="epix-breadcrumb">
                    <?php epixx_breadcrumb_callback();?>
                </div>
            </div>
        </div>
         <!-- page title area end -->
        <?php
}
}
add_action( 'epixx_before_main_content', 'epixx_breadcrumb_func' );

function epixx_breadcrumb_callback() {
    $args = [
        'show_browse'   => false,
        'post_taxonomy' => ['product' => 'product_cat'],
    ];
    $breadcrumb = new epixx_Breadcrumb_Class( $args );

    return $breadcrumb->trail();
}


// epixx_shopping_cart
function epixx_shopping_cart()
{
    ob_start();
    ?>
    <div class="header-shopping-cart-details">
        <div class="header-mini-cart"></div>
    </div>
    <?php
    return ob_get_clean();
}

// epixx_search_form
function epixx_search_form() {
    ?>
     <div class="search-wrapper p-relative transition-3 d-none">
         <div class="search-form transition-3">
             <form method="get" action="<?php print esc_url( home_url( '/' ) );?>" >
                 <input type="search" name="s" value="<?php print esc_attr( get_search_query() )?>" placeholder="<?php print esc_attr__( 'Enter Your Keyword', 'epixx' );?>" >
                 <button type="submit" class="search-btn"><i class="far fa-search"></i></button>
             </form>
             <a href="javascript:void(0);" class="search-close"><i class="far fa-times"></i></a>
         </div>
     </div>
   <?php
}

add_action( 'epixx_before_main_content', 'epixx_search_form' );


/**
 *
 * pagination
 */
if ( !function_exists( 'epixx_pagination' ) ) {

    function _epixx_pagi_callback( $pagination ) {
        return $pagination;
    }

    //page navegation
    function epixx_pagination( $prev, $next, $pages, $args ) {
        global $wp_query, $wp_rewrite;
        $menu = '';
        $wp_query->query_vars['paged'] > 1 ? $current = $wp_query->query_vars['paged'] : $current = 1;

        if ( $pages == '' ) {
            global $wp_query;
            $pages = $wp_query->max_num_pages;

            if ( !$pages ) {
                $pages = 1;
            }

        }

        $pagination = [
            'base'      => add_query_arg( 'paged', '%#%' ),
            'format'    => '',
            'total'     => $pages,
            'current'   => $current,
            'prev_text' => $prev,
            'next_text' => $next,
            'type'      => 'array',
        ];

        //rewrite permalinks
        if ( $wp_rewrite->using_permalinks() ) {
            $pagination['base'] = user_trailingslashit( trailingslashit( remove_query_arg( 's', get_pagenum_link( 1 ) ) ) . 'page/%#%/', 'paged' );
        }

        if ( !empty( $wp_query->query_vars['s'] ) ) {
            $pagination['add_args'] = ['s' => get_query_var( 's' )];
        }

        $pagi = '';
        if ( paginate_links( $pagination ) != '' ) {
            $paginations = paginate_links( $pagination );
            $pagi .= '<ul class="mt-60">';
            foreach ( $paginations as $key => $pg ) {
                $pagi .= '<li>' . $pg . '</li>';
            }
            $pagi .= '</ul>';
        }

        print _epixx_pagi_callback( $pagi );
    }
}

// rtl_enable
function rtl_enable() {
    $my_current_lang = apply_filters( 'wpml_current_language', NULL );
    $rtl_enable = get_theme_mod( 'rtl_switch', false );
    if ( $my_current_lang != 'en' && $rtl_enable ) {
        return true;
    } else {
        return false;
    }
}

// header top bg color
function epixx_breadcrumb_bg_color() {
    $color_code = get_theme_mod( 'epixx_breadcrumb_bg_color', '#222' );
    wp_enqueue_style( 'epixx-custom', EPIXX_THEME_CSS_DIR . 'epixx-custom.css', [] );
    if ( $color_code != '' ) {
        $custom_css = '';
        $custom_css .= ".breadcrumb-bg.gray-bg{ background: " . $color_code . "}";

        wp_add_inline_style( 'epixx-breadcrumb-bg', $custom_css );
    }
}
add_action( 'wp_enqueue_scripts', 'epixx_breadcrumb_bg_color' );

// breadcrumb-spacing top
function epixx_breadcrumb_spacing() {
    $padding_px = get_theme_mod( 'epixx_breadcrumb_spacing', '160px' );
    wp_enqueue_style( 'epixx-custom', EPIXX_THEME_CSS_DIR . 'epixx-custom.css', [] );
    if ( $padding_px != '' ) {
        $custom_css = '';
        $custom_css .= ".breadcrumb-spacing{ padding-top: " . $padding_px . "}";

        wp_add_inline_style( 'epixx-breadcrumb-top-spacing', $custom_css );
    }
}
add_action( 'wp_enqueue_scripts', 'epixx_breadcrumb_spacing' );

// breadcrumb-spacing bottom
function epixx_breadcrumb_bottom_spacing() {
    $padding_px = get_theme_mod( 'epixx_breadcrumb_bottom_spacing', '160px' );
    wp_enqueue_style( 'epixx-custom', EPIXX_THEME_CSS_DIR . 'epixx-custom.css', [] );
    if ( $padding_px != '' ) {
        $custom_css = '';
        $custom_css .= ".breadcrumb-spacing{ padding-bottom: " . $padding_px . "}";

        wp_add_inline_style( 'epixx-breadcrumb-bottom-spacing', $custom_css );
    }
}
add_action( 'wp_enqueue_scripts', 'epixx_breadcrumb_bottom_spacing' );

// scrollup
function epixx_scrollup_switch() {
    $scrollup_switch = get_theme_mod( 'epixx_scrollup_switch', false );
    wp_enqueue_style( 'epixx-custom', EPIXX_THEME_CSS_DIR . 'epixx-custom.css', [] );
    if ( $scrollup_switch ) {
        $custom_css = '';
        $custom_css .= "#scrollUp{ display: none !important;}";

        wp_add_inline_style( 'epixx-scrollup-switch', $custom_css );
    }
}
add_action( 'wp_enqueue_scripts', 'epixx_scrollup_switch' );



// theme color
function epixx_custom_color() {
    $color_code = get_theme_mod( 'epixx_color_option', '#007eff' );
    $color_code_border = get_theme_mod( 'epixx_color_option_border', '#3398ff' );

    wp_enqueue_style( 'epixx-custom', EPIXX_THEME_CSS_DIR . 'epixx-custom.css', [] );

    if ( $color_code != '' ) {
        $custom_css = '';
        $custom_css .= ".theme-bg, .epix-btn-1, .epix-btn-2, .epix-single-product:hover .epix-action a.p-cart, .epix-product-thumb-3 .epix-action a.p-cart, span.sale, .header-nav ul li .sub-menu li a::before, div.header-mini-cart p.woocommerce-mini-cart__buttons.buttons a.button.checkout.wc-forward, div.header-mini-cart .woocommerce-mini-cart__buttons .button:hover, div.slider-active-2 .single-slider .epix-btn-black, .epix-btn-black-2:hover, .epix-subscribe-form button, .epix-f-btn:hover, .single-product-4 .thumb .epix-action a, .single-product-4 .thumb .epix-action a, .epix-white-btn-2:hover, .btn-theme, .bt-team .team-social > a, .bt-team .team-social .team-icon a:hover, form.woocommerce-cart-form .actions .coupon .button, .woocommerce form.woocommerce-cart-form .actions .button, .woocommerce .cart_totals a.checkout-button.button, .epixx-page-content .woocommerce table.shop_table.wishlist_table td.product-add-to-cart a, div.shop-pagination-wrap ul li span.current, div.shop-pagination-wrap ul li a.page-numbers:hover, div.shop-pagination-wrap ul li span.current, div.tagcloud a:hover, .epixx_contact_social ul li a:hover, button.os-btn::after, div.epix-action .added_to_cart.wc-forward, div.product_meta span.posted_in a:hover, div.product_meta span.tagged_as a:hover, div.comment-respond .e-btn::after, div.epixx_cart_list_button .p-cart.a_un2, div.epixx_cart_list_button .p-cart.a_un3, div.sidebar__widget-title h4::after, div.sidebar__widget.widget_tag_cloud a:hover,  div.blog__btn .z-btn::after, div.post_gallery_navigation div:hover, div.blog__play.p-absolute a i, .post-text blockquote cite::before, div.blog__tag a:hover, div.epixx_cart_list_button a.added_to_cart.wc-forward { background-color: " . $color_code . "}";

        $custom_css .= ".woocommerce form.woocommerce-cart-form .actions .coupon .button, .woocommerce form.woocommerce-cart-form .actions .button, .woocommerce div.cart_totals a.checkout-button.button, div.woocommerce button.button:hover, .woocommerce .widget_price_filter .ui-slider .ui-slider-range, .woocommerce .widget_price_filter .ui-slider .ui-slider-handle, div.epixx_single_product_right_section button.single_add_to_cart_button.button:hover {background-color: ".$color_code." !important}";

        $custom_css .= ".header-contact a, .epix-side-dropdown ul li a:hover, .select-default ul li a:hover, .epix-btn-1:hover, .epix-btn-2:hover, .epix-c-list ul li a:hover, .epix-p-title a:hover, div.epix-price-box .price, .link-details, .epix-um-list li:hover a, .epix-um-list li:hover::after, .epix-single-service > * a:hover, .header-nav ul > li:hover > a, .header-nav ul li .sub-menu li:hover > a, .header-nav ul > li:hover > a::after, .single-category:hover .cat-link, .single-category:hover .cat-icon i, .epix-header-list-2 ul li:hover > a, div.header-mini-cart .woocommerce-mini-cart__total .amount, div.price-box.epixx_sp_price_box .add_cart_epixx_price, .product-list-style .price-box > .price, .price-box .price span, .single-action-3 .content a span, .header-contact-3 a:hover, .h-top-list-3 li a:hover, .single-action-3 .content a:hover, .actions .add_to_wishlist.epix_wishlist.wishlist-rd:hover, .single-product-4 .content h4:hover, .offer-label span, .bt-team .team-info span, .bt-team .team-social .team-icon a, div.epix-breadcrumb ul li a span, div.footer-widget .epixx_footer_post_title:hover a, div.epixx-page-content table a:hover, 
            div.woocommerce-info::before, li.woocommerce-info.woocommerce-notice:before, div.epix-single-product-3.swiper-slide .woocommerce-loop-product__title:hover, div.product-sidebar.epix-sidebar-area button[value='Search']::before, div.product-sidebar.epix-sidebar-area ul li a:hover, .epixx_icon i, .epixx_contact_social ul li a, .epixx_single_product_right_section a[rel='nofollow']:hover, .yith-wcwl-wishlistexistsbrowse a[rel='nofollow']:hover, div.epix-product-list-content .woocommerce-loop-product__title:hover, div.epixx_cart_list_button a[rel='nofollow']:hover, div.epix-product-list-content div.epixx_cart_list_button .p-cart.a_un2:hover, div.epix-product-list-content div.epixx_cart_list_button .p-cart.a_un3:hover, form.sidebar-search-form button, .sidebar-blog .widget-post-title a:hover, div.sidebar__widget ul li a::after, .blog-area div.sidebar__widget ul li a:hover, div.post-meta span i, div.blog__content-2 h3 a:hover, div.post-meta a:hover, div.blog__play.p-absolute a:hover i, .post-text blockquote::before, div.epixx_cart_list_button a.added_to_cart.wc-forward:hover, p.logged-in-as a:hover, a.epix-btn-2:hover span, div.epixx_sp_price_box.price-box .added_to_cart.wc-forward { color: " . $color_code . "}"; 

        $custom_css .= ".epix-single-banner, .epix-btn-1:hover::before, .epix-btn-2:hover::before, .header-nav ul li .sub-menu, .product-tabs-2 ul li button.active, .btn-theme, .btn-theme:hover, div.woocommerce-info, li.woocommerce-info, div.product-sidebar.epix-sidebar-area input[type='search']:focus, div.product_meta span.posted_in a:hover, div.product_meta span.tagged_as a:hover, div.comment-respond .e-btn:hover, div.epixx_cart_list_button .p-cart.a_un2::after, div.epixx_cart_list_button .p-cart.a_un3::after, div.epix-product-list-content div.epixx_cart_list_button .p-cart.a_un2:after, div.epixx_cart_list_button .p-cart.a_un2, div.epixx_cart_list_button .p-cart.a_un3, div.epix-product-list-content div.epixx_cart_list_button .p-cart.a_un3:hover, form.sidebar-search-form input:focus, div.blog__btn .z-btn:hover, div.blog__tag a:hover, div.conatct-post-form textarea:focus, div.post-comment-form textarea:focus, div.comment-respond textarea:focus, div.conatct-post-form input:focus, div.post-comment-form input:focus, div.comment-respond input:focus, div.contact__input input:focus, div.contact__input textarea:focus, div.epixx_contact_form .os-btn:hover { border-color: " . $color_code . "}";

        


        wp_add_inline_style( 'epixx-custom', $custom_css );
    }



    wp_enqueue_style( 'epixx-custom', EPIXX_THEME_CSS_DIR . 'epixx-custom.css', [] );

    if ( $color_code_border != '' ) {
        $custom_css = ''; 

        $custom_css .= ".header-1 .epix-ht-social:before {background-color: ".$color_code_border."}";

        $custom_css .= ".header-1 .header-top {border-color: ".$color_code_border."}";

        wp_add_inline_style( 'epixx-custom', $custom_css );

    }



}
add_action( 'wp_enqueue_scripts', 'epixx_custom_color' );


// Logo size 
function epixx_logo_size(){
    $logo_size = get_theme_mod( 'epixx_logo_size','120px');
    wp_enqueue_style( 'epixx-custom', EPIXX_THEME_CSS_DIR . 'epixx-custom.css', array());
    if($logo_size!=''){
        $custom_css = '';
        $custom_css .= ".standard-logo img, .epix-header-logo img, .logo img { width: ".$logo_size."px !important}";
        wp_add_inline_style('epixx-custom',$custom_css);
    }
}
add_action('wp_enqueue_scripts', 'epixx_logo_size');


// epixx_kses_intermediate
function epixx_kses_intermediate( $string = '' ) {
    return wp_kses( $string, epixx_get_allowed_html_tags( 'intermediate' ) );
}

function epixx_get_allowed_html_tags( $level = 'basic' ) {
    $allowed_html = [
        'b'      => [],
        'i'      => [],
        'u'      => [],
        'em'     => [],
        'br'     => [],
        'abbr'   => [
            'title' => [],
        ],
        'span'   => [
            'class' => [],
        ],
        'strong' => [],
        'a'      => [
            'href'  => [],
            'title' => [],
            'class' => [],
            'id'    => [],
        ],
    ];

    if ($level === 'intermediate') {
        $allowed_html['a'] = [
            'href' => [],
            'title' => [],
            'class' => [],
            'id' => [],
        ];
        $allowed_html['div'] = [
            'class' => [],
            'id' => [],
        ];
        $allowed_html['img'] = [
            'src' => [],
            'class' => [],
            'alt' => [],
        ];
        $allowed_html['del'] = [
            'class' => [],
        ];
        $allowed_html['ins'] = [
            'class' => [],
        ];
        $allowed_html['bdi'] = [
            'class' => [],
        ];
        $allowed_html['i'] = [
            'class' => [],
            'data-rating-value' => [],
        ];
    }

    return $allowed_html;
}