<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package epixx
 */

get_header();

$blog_column = is_active_sidebar( 'blog-sidebar' ) ? 8 : 12;

?>

<div class="blog-area pt-120 pb-80">
    <div class="container container-1200">
        <div class="row">
            <div class="col-lg-<?php print esc_attr( $blog_column );?> blog-post-items blog-padding">
            	<div class="blog__wrapper mr-50">
	                <?php
						if ( have_posts() ):
					?>
					<div class="result-bar page-header d-none">
						<h1 class="page-title"><?php esc_html_e( 'Search Results For:', 'epixx' );?> <?php print get_search_query();?></h1>
					</div>
					<?php
						while ( have_posts() ): the_post();
							get_template_part( 'template-parts/content', 'search' );
						endwhile;
					?>
	                <div class="row">
                        <div class="col-xl-12">
                            <div class="shop-pagination-wrapper">
                                <div class="basic-pagination">
                                    <?php epixx_pagination( '<i class="fal fa-angle-left"></i>', '<i class="fal fa-angle-right"></i>', '', ['class' => ''] );?>
                                </div>
                            </div>
                        </div>
                    </div>
					<?php
						else:
							get_template_part( 'template-parts/content', 'none' );
						endif;
					?>
            	</div>
            </div>
			<?php if ( is_active_sidebar( 'blog-sidebar' ) ) { ?>
				<div class="col-lg-4 sidebar-blog right-side">
					<?php get_sidebar();?>
				</div>
			<?php
				}
			?>
        </div>
    </div>
</div>

<?php
get_footer();
