<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package epixx
 */

get_header();

$blog_column = is_active_sidebar( 'blog-sidebar' ) ? 8 : 12;

?>

<section class="blog-area blog-single-area pt-120 pb-80">
    <div class="container container-1200">
        <div class="row">
			<div class="col-lg-<?php print esc_attr( $blog_column );?> blog-post-items blog-padding">
				<div class="blog__details-wrapper mr-50">
					<?php
						while ( have_posts() ):
						the_post();

						get_template_part( 'template-parts/content', get_post_format() );

    					?>

						<?php
    						if ( get_previous_post_link() AND get_next_post_link() ): ?>

    						<div class="postbox__related-title d-none">
                                <h3><?php print esc_html__('You might also like', 'epixx'); ?></h3>
                            </div>
                            <div class="postbox__related-item mb-40 d-none">
                                <div class="row align-items-center">
                                	<?php 
                                	$prev_post_img = get_the_post_thumbnail_url( get_previous_post(), 'large' );
                                	if ( get_previous_post_link() ): ?>
                                    <div class="col-xl-6 col-lg-6 col-md-6">
                                        <div class="blog__item mb-30">
                                        	<?php if( !empty($prev_post_img) ) : ?>
                                            <div class="blog__thumb mb-25 fix">
                                                <a href="<?php print get_permalink( get_previous_post() ); ?>" class="w-img"><img src="<?php print esc_url($prev_post_img); ?>" alt="<?php print esc_attr__( 'blog', 'epixx' );?>"></a>

                                            </div>
                                        	<?php endif; ?>
                                            <div class="blog__content">
                                                <h4><?php print get_previous_post_link( '%link ', '%title' );?></h4>
								                <div class="blog__meta">
								                    <span><?php print esc_html__('By', 'epixx'); ?> <a href="<?php print esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) );?>"><?php print get_the_author();?></a></span>
								                    <span><?php print esc_html__('/', 'epixx'); ?> <?php print get_the_date(); ?></span>
								                </div>
                                            </div>
                                        </div>
                                    </div>
                                	<?php endif; ?>
                                	<?php if ( get_next_post_link() ): ?>
                                    <div class="col-xl-6 col-lg-6 col-md-6">
                                        <div class="blog__item mb-30">
                                        	<?php 
                                        	$next_post_img = get_the_post_thumbnail_url( get_next_post(), 'large' );
                                        	if( !empty($next_post_img) ) : ?>
                                            <div class="blog__thumb mb-25 fix">
                                                <a href="<?php print get_permalink( get_next_post() ); ?>" class="w-img"><img src="<?php print esc_url($next_post_img); ?>" alt="<?php print esc_attr__( 'blog', 'epixx' );?>"></a>
                                            </div>
                                        	<?php endif; ?>

                                            <div class="blog__content">
                                                <h4><?php print get_next_post_link( '%link ', '%title' );?></h4>
								                <div class="blog__meta">
								                    <span><?php print esc_html__('By', 'epixx'); ?> <a href="<?php print esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) );?>"><?php print get_the_author();?></a></span>
								                    <span><?php print esc_html__('/', 'epixx'); ?> <?php print get_the_date(); ?></span>
								                </div>
                                            </div>
                                        </div>
                                    </div>
                                	<?php endif; ?>
                                </div>
                            </div>


						<?php
							endif;?>
						<?php

							get_template_part( 'template-parts/biography' );

							// If comments are open or we have at least one comment, load up the comment template.
							if ( comments_open() || get_comments_number() ):
								comments_template();
							endif;

							endwhile; // End of the loop.
						?>
				</div>
			</div>
			<?php
				if ( is_active_sidebar( 'blog-sidebar' ) ) {?>
					<div class="col-lg-4 sidebar-blog right-side">
						<?php get_sidebar();?>
					</div>
				<?php
				}
			?>
		</div>
	</div>
</section>

<?php
get_footer();
